package org.whitesource.agent.dependency.resolver.js;

import java.util.ArrayList;
import java.util.List;

public enum JsLibsRegex {

    JQUERY("jquery", new ArrayList<String>() {{
        add("jquery-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*!? jQuery v(.*?)");
        add("\\* jQuery JavaScript Library v(.*?)");
        add("\\* jQuery (.*?) - New Wave Javascript");
        add("// \\$Id: jquery.js,v (.*?)");
        add("/\\*! jQuery v(.*?)");
        add("[^a-z]f=\"(.*?)\",.*[^a-z]jquery:f,");
        add("[^a-z]m=\"(.*?)\",.*[^a-z]jquery:m,");
        add("[^a-z.]jquery:[ ]?\"(.*?)\"");
    }}),
    JQUERY_MIGRATE("jquery-migrate", new ArrayList<String>() {{
        add("jquery-migrate-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*!?(?:\n \\*)? jQuery Migrate(?: -)? v(.*?)");
    }}),
    JQUERY_VALIDATOR("jquery-validator", new ArrayList<String>() {{
        add("jquery.validation-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*!?(?:\n \\*)? jQuery Validation Plugin v(.*?)");
    }}),
    JQUERY_MOBILE("jquery-mobile", new ArrayList<String>() {{
        add("jquery.mobile-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*!?(?:\n \\*)? jQuery Mobile(?: -)? v(.*?)");
    }}),
    JQUERY_UI("jquery-ui", null, new ArrayList<String>() {{
        add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}.*jquery\\.ui\\.dialog\\.js");
        add("/\\*!?[\n *]+jQuery UI Dialog (.*?)");
        add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}\\* Includes: .* dialog\\.js");
        add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}.*jquery\\.ui\\.autocomplete\\.js");
        add("/\\*!?[\n *]+jQuery UI Autocomplete (.*?)");
        add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}\\* Includes: .* autocomplete\\.js");
        add("/\\*!? jQuery UI - v(.*?)(.*\n){1,3}.*jquery\\.ui\\.tooltip\\.js");
        add("/\\*!?[\n *]+jQuery UI Tooltip (.*?)");
    }}),
    JQUERY_PRETTY_PHOTO("jquery-prettyPhoto", null, new ArrayList<String>() {{
        add("/\\*[\r\n -]+Class: prettyPhoto(?:.*\n){1,3}[ ]*Version: (.*?)");
        add("\\.prettyPhoto[ ]?=[ ]?\\{version:[ ]?(?:'|\")(.*?)(?:'|\")\\}");
    }}),
    JPLAYER("jPlayer", null, new ArrayList<String>() {{
        add("/\\*!?[\n *]+jPlayer Plugin for jQuery (?:.*\n){1,10}[ *]+Version: (.*?)");
        add("/\\*!? jPlayer (.*?) for jQuery");
    }}),
    KNOCKOUT("knockout", new ArrayList<String>() {{
        add("knockout-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("\\* Knockout JavaScript library v(.*?)");
    }}),
    SESSVARS("sessvars", new ArrayList<String>() {{
        add("sessvars-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("sessvars ver (.*?)");
    }}),
    SWFOBJECT("swfobject", new ArrayList<String>() {{
        add("swfobject_(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("SWFObject v(.*?) ");
    }}),
    TINYMCE("tinymce", null, new ArrayList<String>() {{
        add("// (.*?) \\([0-9\\-]+\\)[\n\r]+.{0,1200}l=.tinymce/geom/Rect.");
    }}),
    YUI("yui", new ArrayList<String>() {{
        add("yui-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/*\nYUI (.*?)");
        add("/yui/license.(?:html|txt)\nversion: (.*?)");
    }}),
    PROTOTYPEJS("prototypejs", new ArrayList<String>() {{
        add("prototype-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("Prototype JavaScript framework, version (.*?)");
        add("Prototype[ ]?=[ ]?\\{[ \r\n\t]*Version:[ ]?(?:'|\")(.*?)(?:'|\")");
    }}),
    EMBER("ember", new ArrayList<String>() {{
        add("ember-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("Project:   Ember -(?:.*\n){9,11}// Version: v(.*?)");
        add("// Version: v(.*?)(.*\n){10,15}(Ember Debug|@module ember|@class ember)");
        add("Ember.VERSION[ ]?=[ ]?(?:'|\")(.*?)(?:'|\")");
    }}),
    DOJO("dojo", new ArrayList<String>() {{
        add("dojo-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/dojo.version=\\{major:([0-9]+),minor:([0-9]+),patch:([0-9]+)/$1.$2.$3/");
    }}),
    ANGULARJS("angularjs", new ArrayList<String>() {{
        add("angular(?:js)?-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*[ \n]+AngularJS v(.*?)");
        add("http://errors\\.angularjs\\.org/(.*?)/");
    }}),
    BACKBONEJS("backbonejs", new ArrayList<String>() {{
        add("backbone(?:js)?-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("//[ ]+Backbone.js (.*?)");
        add("a=t.Backbone={}}a.VERSION=\"(.*?)\"");
    }}),
    MUSTACHE("mustache.js", new ArrayList<String>() {{
        add("mustache(?:js)?-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("name:\"mustache.js\",version:\"(.*?)\"");
        add("[^a-z]mustache.version[ ]?=[ ]?(?:'|\")(.*?)(?:'|\")");
        add("exports.name[ ]?=[ ]?\"mustache.js\";[\n ]*exports.version[ ]?=[ ]?(?:'|\")(.*?)(?:'|\");");
    }}),
    HANDLEBARS("handlebars", new ArrayList<String>() {{
        add("handlebars(?:js)?-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("Handlebars.VERSION = \"(.*?)\";");
        add("Handlebars=\\{VERSION:(?:'|\")(.*?)(?:'|\")");
        add("this.Handlebars=\\{\\};[\n\r \t]+\\(function\\([a-z]\\)\\{[a-z].VERSION=(?:'|\")(.*?)(?:'|\")");
        add("/\\*+![\\s]+(?:@license)?[\\s]+handlebars v(.*?)");
    }}),
    EASYXDM("easyXDM", new ArrayList<String>() {{
        add("easyXDM-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add(" \\* easyXDM\n \\* http://easyxdm.net/(?:\r|\n|.)+version:\"(.*?)\"");
        add("@class easyXDM(?:.|\r|\n)+@version (.*?)(\r|\n)");
    }}),
    PLUPLOAD("plupload", new ArrayList<String>() {{
        add("plupload-(.*?)(.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("\\* Plupload - multi-runtime File Uploader(?:\r|\n)+ \\* v(.*?)");
        add("var g=\\{VERSION:\"(.*?)\",.*;window.plupload=g\\}");
    }}),
    DOMPURIFY("dompurify", null, new ArrayList<String>() {{
        add("DOMPurify.version = '(.*?)';");
        add("DOMPurify.version=\"(.*?)\"");
        add("DOMPurify=.[^\\r\\n]{10,500}\\.version=\"(.*?)\"");
    }}),
    REACT("react", null, new ArrayList<String>() {{
        add("/\\*\\*\n +\\* React \\(with addons\\) ?v(.*?)");
        add("/\\*\\*\n +\\* React v(.*?)");
        add("\"\\./ReactReconciler\":[0-9]+,\"\\./Transaction\":[0-9]+,\"fbjs/lib/invariant\":[0-9]+\\}\\],[0-9]+:\\[function\\(require,module,exports\\)\\{\"use strict\";module\\.exports=\"(.*?)\"\\}");
        add("ReactVersion\\.js[\\*! \\\\/\n\r]{0,100}function\\(e,t\\)\\{\"use strict\";e\\.exports=\"(.*?)\"");
        add("expected a ReactNode.[\\s\\S]{0,1800}?function\\(e,t\\)\\{\"use strict\";e\\.exports=\"(.*?)\"");
    }}),
    FLOWPLAYER("flowplayer", new ArrayList<String>() {{
        add("flowplayer-(.*?)(\\.min)?\\.js");
    }}, null),
    DWR("DWR", null, new ArrayList<String>() {{
        add(" dwr-(.*?).jar");
    }}),
    MOMENTJS("momentjs", null, new ArrayList<String>() {{
        add("//! moment.js(?:[\n\r]+)//! version : (.*?)");
    }}),
    BOOTSTRAP("bootstrap", new ArrayList<String>() {{
        add("bootstrap-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*!? Bootstrap v(.*?)");
        add("\\* Bootstrap v(.*?)");
        add("/\\*! Bootstrap v(.*?)");
        add("this\\.close\\)};.\\.VERSION=\"(.*?)\"(?:,.\\.TRANSITION_DURATION=150)?,.\\.prototype\\.close");
    }}),
    CKEDITOR("ckeditor", new ArrayList<String>() {{
        add("ckeditor-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("ckeditor..js.{4,20}=\\{timestamp:\"[^\"]+\",version:\"(.*?)");
        add("window.CKEDITOR=function\\(\\)\\{var [a-z]=\\{timestamp:\"[^\"]+\",version:\"(.*?)");
    }}),
    VUE("vue", new ArrayList<String>() {{
        add("vue-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/\\*!\\n \\* Vue.js v(.*?)");
        add("Vue.version = '(.*?)';");
        add("'(.*?)'[^\\n]{0,8000}Vue compiler");
    }}),
    EXTJS("extjs", new ArrayList<String>() {{
        add("/ext-all-(.*?)(\\.min)?\\.js");
        add("/ext-all-debug-(.*?)(\\.min)?\\.js");
        add("/ext-base-(.*?)(\\.min)?\\.js");
    }}, new ArrayList<String>() {{
        add("/*!\n * Ext JS Library (.*?)");
    }});

    private String libName;
    private List<String> fileNameRegex;
    private List<String> fileContentRegex;

    JsLibsRegex(String libName, List<String> fileNameRegex, List<String> fileContentRegex) {
        this.libName = libName;
        this.fileNameRegex = fileNameRegex;
        this.fileContentRegex = fileContentRegex;
    }

    public String getLibName() {
        return libName;
    }

    public List<String> getFileNameRegex() {
        return fileNameRegex;
    }

    public List<String> getFileContentRegex() {
        return fileContentRegex;
    }

}
