package org.whitesource.agent.dependency.resolver.nuget.packagesConfig;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

import java.util.LinkedList;
import java.util.List;

/**
 * @author raz.nitzan
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "ItemGroup")
public class NugetCsprojItemGroup {

    /* --- Members --- */
    @XmlElement(name = "PackageReference")
    private List<PackageReference> packagesReference = new LinkedList<>();
    @XmlElement(name = "Reference")
    private List<ReferenceTag> references = new LinkedList<>();

    /* --- Constructors --- */

    public NugetCsprojItemGroup(List<PackageReference> packagesReference, List<ReferenceTag> references) {
        this.packagesReference = packagesReference;
        this.references = references;
    }

    public NugetCsprojItemGroup() {
    }

    /* --- Getters / Setters --- */
    public List<PackageReference> getPackageReference() {
        return packagesReference;
    }

    public void setPackageReference(List<PackageReference> packagesReference) {
        this.packagesReference = packagesReference;
    }

    //    @XmlElement(name = "Reference")
    public List<ReferenceTag> getReferences() {
        return references;
    }

    public void setReferences(List<ReferenceTag> references) {
        this.references = references;
    }

}
