package org.whitesource.agent.dependency.resolver.nuget.packagesConfig;

import jakarta.xml.bind.annotation.*;

/**
 * @author raz.nitzan
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "PackageReference")
public class PackageReference implements NugetPackageInterface {

    /* --- Members --- */
    @XmlAttribute(name = "Include")
    private String pkgNameAtt;
    @XmlAttribute(name = "Version")
    private String pkgVersionAtt;
    @XmlAttribute(name = "VersionOverride")
    private String pkgVersionOverrideAtt;

    @XmlElement(name = "Include")
    private String pkgNameElm;
    @XmlElement(name = "Version")
    private String pkgVersionElm;

    /* --- Constructors --- */

    public PackageReference(String pkgNameAtt, String pkgVersionAtt, String pkgVersionOverrideAtt,
                            String pkgNameElm, String pkgVersionElm) {
        this.pkgNameAtt = pkgNameAtt;
        this.pkgVersionAtt = pkgVersionAtt;
        this.pkgVersionOverrideAtt = pkgVersionOverrideAtt;
        this.pkgNameElm = pkgNameElm;
        this.pkgVersionElm = pkgVersionElm;
    }

    public PackageReference() {
    }

    /* --- Getters / Setters --- */

    public String getPkgName() {
        return pkgNameAtt != null ? pkgNameAtt : pkgNameElm;
    }

    public void setPkgName(String pkgName) {
        this.pkgNameAtt = pkgName;
    }

    public String getPkgVersion() {
        String version = pkgVersionAtt != null ? pkgVersionAtt : pkgVersionElm;
        return version != null ? version : pkgVersionOverrideAtt;
    }

    public void setPkgVersion(String pkgVersion) {
        this.pkgVersionAtt = pkgVersion;
        this.pkgVersionElm = pkgVersion;
        this.pkgVersionOverrideAtt = pkgVersion;
    }

}
