package org.whitesource.agent.dependency.resolver.nuget.packagesConfig;

import jakarta.xml.bind.annotation.*;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "Reference")
public class ReferenceTag {

    /* --- Members --- */
    @XmlAttribute(name = "Include")
    private String include;
    @XmlAttribute(name = "Version")
    private String version;

    @XmlElement(name = "HintPath")
    private String hintPath;

    public ReferenceTag(String include, String version, String hintPath) {
        this.include = include;
        this.version = version;
        this.hintPath = hintPath;
    }

    public ReferenceTag() {
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHintPath() {
        return this.hintPath;
    }

    public void setHintPath(String hintPath) {
        this.hintPath = hintPath;
    }
}
