package org.whitesource.agent.dependency.resolver.sbt;


import jakarta.xml.bind.annotation.*;

import java.util.List;

@XmlRootElement(name = "ivy-report")
public class IvyReport {

    @XmlElement(name = "info")
    private Info info;
    @XmlElement(name = "module")
    @XmlElementWrapper(name = "dependencies")
    private List<Module> dependencies;

    /* --- Getters --- */

    public List<Module> getDependencies() {
        return dependencies;
    }

    public Info getInfo() {
        return info;
    }
}

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "info")
class Info {

    @XmlAttribute(name = "organisation")
    private String organisation;
    @XmlAttribute(name = "module")
    private String module;
    @XmlAttribute(name = "revision")
    private String revision;
    @XmlAttribute(name = "date")
    private String date;

    public Info() {
    }

    public String getGroupId() {
        return this.organisation;
    }

    public String getArtifactId() {
        return this.module;
    }

    public String getVersion() {
        return this.revision;
    }

    public String getDate() {
        return this.date;
    }

    public void setVersion(String version) {
        this.revision = version;
    }

    public void setGroupId(String groupId) {
        this.organisation = groupId;
    }

    public void setArtifactId(String module) {
        this.module = module;
    }

    public void setDate(String date) {
        this.date = date;
    }

}

//@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "module")
class Module {

    @XmlAttribute(name = "organisation")
    private String organisation;

    @XmlAttribute(name = "name")
    private String name;

    @XmlElement(name = "revision")
    private List<Revision> revisionsList;

    /* --- Getters --- */

    public String getGroupId() {
        return organisation;
    }

    public String getArtifactId() {
        return name;
    }

    public List<Revision> getRevisions() {
        return revisionsList;
    }
}

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "revision")
class Revision {

    @XmlAttribute(name = "name")
    private String name;

    @XmlAttribute(name = "position")
    private int position;

    @XmlElement(name = "caller")
    private List<Caller> callerList;

    @XmlElement(name = "artifact")
    @XmlElementWrapper(name = "artifacts")
    private List<Artifact> artifacts;

    /* --- Getters --- */

    public String getVersion() {
        return name;
    }

    // dependencies with multiple versions, only the latest is used.  the others have property 'position=-1"
    public boolean isIgnored() {
        return position == -1;
    }

    public List<Caller> getParentsList() {
        return callerList;
    }

    public List<Artifact> getArtifacts() {
        return artifacts;
    }
}

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "caller")
class Caller {

    @XmlAttribute(name = "organisation")
    private String organisation;

    @XmlAttribute(name = "name")
    private String name;

    @XmlAttribute(name = "callerrev")
    private String callerrev;

    /* --- Getters --- */

    public String getGroupId() {
        return organisation;
    }

    public String getArtifactId() {
        return name;
    }

    public String getVersion() {
        return callerrev;
    }
}

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "artifact")
class Artifact {

    @XmlAttribute(name = "location")
    private String location;

    /* --- Getters --- */

    public String getPathToJar() {
        return location;
    }
}