package org.whitesource.agent.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class CommandLineErrors {

    private static final Logger log = LoggerFactory.getLogger(CommandLineErrors.class);

    public static final String MAVEN = "Maven";
    public static final String GRADLE = "Gradle";
    public static final String NPM = "NPM";
    public static final String DOTNET = "DotNet";
    public static final String NUGET = "Nuget";

    private static List<String> failedCommands = Collections.synchronizedList(new ArrayList<>());
    private static Set<String> failedResolver = Collections.synchronizedSet(new HashSet<>());

    public static void addFailedCmd(String cmd) {
        if (StringUtils.isNotEmpty(cmd)) {
            failedCommands.add(cmd);
            addFailedResolver();
        }
    }

    public static void removeFailedCmd(String cmd, String resolver) {
        try {
            if (StringUtils.isNotEmpty(cmd) &&
                    failedCommands.remove(cmd) &&
                    !failedCommands.contains(cmd) &&
                    StringUtils.isNotEmpty(resolver)) {

                failedResolver.remove(resolver);

            }
        } catch (Exception e) {
            log.error("Fail to remove command: " + cmd, e);
        }
    }

    public static List<String> getFailedCommands() {
        return failedCommands;
    }

    public static Set<String> getFailedResolver() {
        return failedResolver;
    }

    private static void addFailedResolver() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (StringUtils.containsIgnoreCase(ste.getClassName(), MAVEN)) {
                failedResolver.add(MAVEN);
                break;
            } else if (StringUtils.containsIgnoreCase(ste.getClassName(), GRADLE)) {
                failedResolver.add(GRADLE);
                break;
            } else if (StringUtils.containsIgnoreCase(ste.getClassName(), NPM)) {
                failedResolver.add(NPM);
                break;
            } else if (StringUtils.containsIgnoreCase(ste.getClassName(), DOTNET)) {
                failedResolver.add(DOTNET);
                break;
            } else if (StringUtils.containsIgnoreCase(ste.getClassName(), NUGET)) {
                failedResolver.add(NUGET);
                break;
            }
        }
    }

}
