package org.whitesource.agent.utils;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import org.glassfish.jaxb.runtime.v2.JAXBContextFactory;
import org.w3c.dom.Document;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.*;
import java.nio.file.Files;

public class JaxbUtil {

    private static final Object lock = new Object();

    public static JAXBContext getJAXBContext(Class type) throws JAXBException {
        synchronized (lock) {
            JAXBContextFactory jaxbContextFactory = new JAXBContextFactory();
            return jaxbContextFactory.createContext(new Class[]{type}, null);
        }
    }

    public static <JaxbObject> JaxbObject readFromPath(File xmlFile, Class<JaxbObject> jaxbObjectType) {
        JaxbObject jaxbObject;
        try {
            InputStream is = Files.newInputStream(xmlFile.toPath());
            jaxbObject = readJaxbObject(is, jaxbObjectType);
            is.close();
        } catch (Exception e) {
            throw new RuntimeException("Failed to parse xml", e);
        }
        return jaxbObject;
    }

    public static <JaxbObject> JaxbObject readJaxbObject(String xmlContent, Class<JaxbObject> jaxbObjectType) throws JAXBException {
        return readJaxbObject(new ByteArrayInputStream(xmlContent.getBytes()), jaxbObjectType);
    }

    public static <JaxbObject> JaxbObject readJaxbObject(InputStream inputStream, Class<JaxbObject> jaxbObjectType) throws JAXBException {
        try {
            JAXBContext jaxbContext;
            JaxbObject jaxbObject;
            jaxbContext = getJAXBContext(jaxbObjectType);
            Unmarshaller um = jaxbContext.createUnmarshaller();

            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(inputStream);

            jaxbObject = (JaxbObject) um.unmarshal(doc);
            return jaxbObject;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <JaxbObject> byte[] writeJaxbObjectToBytes(JaxbObject jaxbObject) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writeJaxbObject(out, jaxbObject);
        return out.toByteArray();
    }

    public static <JaxbObject> String write(JaxbObject jaxbObject) {
        try {
            return writeJaxbObject(jaxbObject);
        } catch (JAXBException e) {
            throw new RuntimeException("Failed to write jaxbObject " + jaxbObject.toString(), e);
        }
    }

    public static <JaxbObject> String writeJaxbObject(JaxbObject jaxbObject) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writeJaxbObject(out, jaxbObject);
        return out.toString();
    }

    public static <JaxbObject> void writeJaxbObject(OutputStream outputStream, JaxbObject jaxbObject) throws JAXBException {
        JAXBContext jaxbContext;
        jaxbContext = getJAXBContext(jaxbObject.getClass());
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
        marshaller.marshal(jaxbObject, outputStream);
    }

    public static <JaxbObject> void writeToFile(JaxbObject jaxbObject, File file) {
        try {
            JAXBContext jaxbContext = getJAXBContext(jaxbObject.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            marshaller.marshal(jaxbObject, file);
        } catch (JAXBException e) {
            throw new RuntimeException("Failed to write jaxbObject " + jaxbObject.toString(), e);
        }
    }

    public static <JaxbObject> JaxbObject clone(JaxbObject jaxbObject) throws JAXBException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        writeJaxbObject(byteArrayOutputStream, jaxbObject);
        return (JaxbObject) readJaxbObject(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), jaxbObject.getClass());
    }

}
