package org.whitesource.fs;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

/**
 * Author: Ilan Dayan
 */
public class FsUtils {

    private static final Logger logger = LoggerFactory.getLogger(FsUtils.class);

    public static String getTmpDir() {
        String tmpDir = System.getenv("FSA_TMP_DIR");
        tmpDir = StringUtils.isNotEmpty(tmpDir) ? tmpDir : System.getProperty("FSA_TMP_DIR");

        return isDirExist(tmpDir) ? tmpDir : System.getProperty("java.io.tmpdir");
    }

    private static boolean isDirExist(String path) {
        if (StringUtils.isNotEmpty(path)) {
            File dir = new File(path);
            try {
                return dir.exists() && dir.isDirectory();
            } catch (Exception e) {
                logger.error("Fail to set FSA temp folder on: " + path);
            }
        }
        return false;
    }

}
