/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.DependencyCalculator;
import org.whitesource.agent.ViaComponents;
import org.whitesource.agent.ViaLanguage;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.archive.ArchiveExtractor;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.DependencyResolutionService;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.agent.utils.MemoryUsageHelper;
import org.whitesource.fs.FileSystemAgent;
import org.whitesource.fs.configuration.AgentConfiguration;
import org.whitesource.fs.configuration.ResolverConfiguration;

public class FileSystemScanner {
    private final Logger logger = LoggerFactory.getLogger(FileSystemAgent.class);
    private String FSA_FILE = "**/*whitesource-fs-agent-*.*jar";
    private final boolean isSeparateProjects;
    private final AgentConfiguration agent;
    private final boolean showProgressBar;
    private boolean enableImpactAnalysis;
    private ViaLanguage iaLanguage;
    private DependencyResolutionService dependencyResolutionService;

    public FileSystemScanner(ResolverConfiguration resolver, AgentConfiguration agentConfiguration, boolean enableImpactAnalysis) {
        this.dependencyResolutionService = new DependencyResolutionService(resolver);
        this.isSeparateProjects = this.dependencyResolutionService.isSeparateProjects();
        this.agent = agentConfiguration;
        this.showProgressBar = agentConfiguration.isShowProgressBar();
        this.enableImpactAnalysis = enableImpactAnalysis;
    }

    public FileSystemScanner(ResolverConfiguration resolver, AgentConfiguration agentConfiguration, boolean enableImpactAnalysis, ViaLanguage iaLanguage) {
        this(resolver, agentConfiguration, enableImpactAnalysis);
        this.iaLanguage = iaLanguage;
    }

    public List<DependencyInfo> createProjects(List<String> scannerBaseDirs, Map<String, Set<String>> appPathsToDependencyDirs, boolean scmConnector, String[] includes, String[] excludes, boolean globCaseSensitive, int archiveExtractionDepth, String[] archiveIncludes, String[] archiveExcludes, boolean archiveFastUnpack, boolean followSymlinks, Collection<String> excludedCopyrights, boolean partialSha1Match, String[] pythonRequirementsFileIncludes) {
        Set<AgentProjectInfo> projects = this.createProjects(scannerBaseDirs, appPathsToDependencyDirs, scmConnector, includes, excludes, globCaseSensitive, archiveExtractionDepth, archiveIncludes, archiveExcludes, archiveFastUnpack, followSymlinks, excludedCopyrights, partialSha1Match, false, false, pythonRequirementsFileIncludes, false).keySet();
        return projects.stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList());
    }

    public List<DependencyInfo> createProjects(List<String> scannerBaseDirs, boolean scmConnector, String[] includes, String[] excludes, boolean globCaseSensitive, int archiveExtractionDepth, String[] archiveIncludes, String[] archiveExcludes, boolean archiveFastUnpack, boolean followSymlinks, Collection<String> excludedCopyrights, boolean partialSha1Match, String[] pythonRequirementsFileIncludes) {
        return this.createProjects(scannerBaseDirs, this.convertListDirsToMap(scannerBaseDirs), scmConnector, includes, excludes, globCaseSensitive, archiveExtractionDepth, archiveIncludes, archiveExcludes, archiveFastUnpack, followSymlinks, excludedCopyrights, partialSha1Match, pythonRequirementsFileIncludes);
    }

    public Map<AgentProjectInfo, LinkedList<ViaComponents>> createProjects(List<String> scannerBaseDirs, boolean hasScmConnector) {
        return this.createProjects(scannerBaseDirs, this.convertListDirsToMap(scannerBaseDirs), hasScmConnector);
    }

    public Map<AgentProjectInfo, LinkedList<ViaComponents>> createProjects(List<String> scannerBaseDirs, Map<String, Set<String>> appPathsToDependencyDirs, boolean hasScmConnector) {
        return this.createProjects(scannerBaseDirs, appPathsToDependencyDirs, hasScmConnector, this.agent.getIncludes(), this.agent.getExcludes(), this.agent.getGlobCaseSensitive(), this.agent.getArchiveExtractionDepth(), this.agent.getArchiveIncludes(), this.agent.getArchiveExcludes(), this.agent.isArchiveFastUnpack(), this.agent.isFollowSymlinks(), this.agent.getExcludedCopyrights(), this.agent.isPartialSha1Match(), this.agent.isCalculateHints(), this.agent.isCalculateMd5(), this.agent.getPythonRequirementsFileIncludes(), false);
    }

    public Map<AgentProjectInfo, LinkedList<ViaComponents>> createProjects(List<String> scannerBaseDirs, boolean scmConnector, String[] includes, String[] excludes, boolean globCaseSensitive, int archiveExtractionDepth, String[] archiveIncludes, String[] archiveExcludes, boolean archiveFastUnpack, boolean followSymlinks, Collection<String> excludedCopyrights, boolean partialSha1Match, boolean calculateHints, boolean calculateMd5, String[] pythonRequirementsFileIncludes) {
        return this.createProjects(scannerBaseDirs, this.convertListDirsToMap(scannerBaseDirs), scmConnector, includes, excludes, globCaseSensitive, archiveExtractionDepth, archiveIncludes, archiveExcludes, archiveFastUnpack, followSymlinks, excludedCopyrights, partialSha1Match, calculateHints, calculateMd5, pythonRequirementsFileIncludes, false);
    }

    public Map<AgentProjectInfo, LinkedList<ViaComponents>> createProjects(List<String> scannerBaseDirs, Map<String, Set<String>> appPathsToDependencyDirs, boolean scmConnector, String[] includes, String[] excludes, boolean globCaseSensitive, int archiveExtractionDepth, String[] archiveIncludes, String[] archiveExcludes, boolean archiveFastUnpack, boolean followSymlinks, Collection<String> excludedCopyrights, boolean partialSha1Match, boolean calculateHints, boolean calculateMd5, String[] pythonRequirementsFileIncludes, boolean includeFsDependencies) {
        MemoryUsageHelper.SystemStats systemStats = MemoryUsageHelper.getMemoryUsage();
        this.logger.debug(systemStats.toString());
        Set<String> pathsToScan = this.getCanonicalPaths(scannerBaseDirs);
        for (String appPath : appPathsToDependencyDirs.keySet()) {
            appPathsToDependencyDirs.put(appPath, this.getCanonicalPaths((Collection<String>)appPathsToDependencyDirs.get(appPath)));
        }
        int totalFiles = 0;
        boolean archiveExtraction = false;
        HashMap<String, String> archiveToBaseDirMap = new HashMap<String, String>();
        ArrayList<String> archiveDirectories = new ArrayList<String>();
        if (archiveExtractionDepth > 0) {
            ArchiveExtractor archiveExtractor = new ArchiveExtractor(archiveIncludes, archiveExcludes, excludes, archiveFastUnpack);
            this.logger.info("Starting Archive Extraction (may take a few minutes)");
            for (String scannerBaseDir : new LinkedHashSet<String>(pathsToScan)) {
                String unpackDirectory = archiveExtractor.extractArchives(scannerBaseDir, archiveExtractionDepth, archiveDirectories);
                if (unpackDirectory == null) continue;
                archiveExtraction = true;
                String parentFileUrl = new File(scannerBaseDir).getParent();
                this.logger.debug("Unpack directory: {}, parent file: {}", (Object)unpackDirectory, (Object)parentFileUrl);
                archiveToBaseDirMap.put(unpackDirectory, parentFileUrl);
                pathsToScan.add(unpackDirectory);
                if (!appPathsToDependencyDirs.containsKey("defaultKey")) {
                    appPathsToDependencyDirs.put("defaultKey", new HashSet());
                }
                appPathsToDependencyDirs.get("defaultKey").add(unpackDirectory);
            }
        }
        this.logger.info("Starting analysis");
        LinkedHashMap<AgentProjectInfo, Path> allProjects = new LinkedHashMap<AgentProjectInfo, Path>();
        LinkedHashMap<AgentProjectInfo, LinkedList<ViaComponents>> allProjectsToViaComponents = new LinkedHashMap<AgentProjectInfo, LinkedList<ViaComponents>>();
        AgentProjectInfo mainProject = new AgentProjectInfo();
        allProjects.put(mainProject, null);
        allProjectsToViaComponents.put(mainProject, new LinkedList());
        this.logger.info("Scanning directories {} for matching Files (may take a few minutes)", pathsToScan);
        this.logger.info("Included file types: {}", (Object)String.join((CharSequence)",", includes));
        this.logger.info("Excluded file types: {}", (Object)String.join((CharSequence)",", excludes));
        String[] resolversIncludesPattern = this.createResolversIncludesPattern(this.dependencyResolutionService.getDependencyResolvers());
        Map<File, Collection<String>> fileMapBeforeResolve = new FilesUtils().fillFilesMap(pathsToScan, resolversIncludesPattern, excludes, followSymlinks, globCaseSensitive);
        Set<String> allFiles = fileMapBeforeResolve.entrySet().stream().flatMap(folder -> ((Collection)folder.getValue()).stream()).collect(Collectors.toSet());
        int[] totalDependencies = new int[]{0};
        boolean isIgnoreSourceFiles = this.dependencyResolutionService.isDependenciesOnly();
        if (this.enableImpactAnalysis && this.iaLanguage != null) {
            for (String string : appPathsToDependencyDirs.keySet()) {
                if (string.equals("defaultKey") || appPathsToDependencyDirs.get(string).iterator().next() == null) continue;
                String pojoAppPath = string;
                ((LinkedList)allProjectsToViaComponents.get(allProjects.keySet().stream().findFirst().get())).add(new ViaComponents(pojoAppPath, this.iaLanguage));
            }
        } else if (this.dependencyResolutionService != null && this.dependencyResolutionService.shouldResolveDependencies(allFiles)) {
            this.logger.info("Attempting to resolve dependencies");
            ArrayList<Object> resolutionResults = new ArrayList<Object>();
            for (String appPath : appPathsToDependencyDirs.keySet()) {
                ViaComponents viaComponents = null;
                ViaLanguage impactAnalysisLanguage = null;
                List<Object> resolutionResult = new LinkedList();
                LinkedList<String> pathsList = new LinkedList<String>();
                pathsList.addAll((Collection)appPathsToDependencyDirs.get(appPath));
                if (appPath.equals("defaultKey") && appPathsToDependencyDirs.keySet().size() == 1) {
                    resolutionResult = this.dependencyResolutionService.resolveDependencies(pathsList, excludes);
                } else if (!appPath.equals("defaultKey") && appPathsToDependencyDirs.keySet().size() > 1) {
                    resolutionResult = this.dependencyResolutionService.resolveDependencies(pathsList, excludes);
                }
                if (resolutionResult.size() == 1 && !appPath.equals("defaultKey")) {
                    DependencyType dependencyType = ((ResolutionResult)resolutionResult.stream().findFirst().get()).getDependencyType();
                    if (dependencyType == null) break;
                    switch (dependencyType) {
                        case NPM: 
                        case BOWER: {
                            impactAnalysisLanguage = ViaLanguage.JAVA_SCRIPT;
                            break;
                        }
                        case MAVEN: 
                        case GRADLE: {
                            impactAnalysisLanguage = ViaLanguage.JAVA;
                            break;
                        }
                    }
                } else if (resolutionResult.size() <= 1 || this.enableImpactAnalysis) {
                    // empty if block
                }
                if (impactAnalysisLanguage != null) {
                    viaComponents = new ViaComponents(appPath, impactAnalysisLanguage);
                }
                for (ResolutionResult resolutionResult2 : resolutionResult) {
                    Map<AgentProjectInfo, Path> projects = resolutionResult2.getResolvedProjects();
                    ArrayList dependenciesToVia = new ArrayList();
                    for (Map.Entry<AgentProjectInfo, Path> project2 : projects.entrySet()) {
                        Collection dependencies = project2.getKey().getDependencies();
                        dependenciesToVia.addAll(dependencies);
                        if (dependencies.isEmpty()) continue;
                        if ((DependencyType.MAVEN.equals((Object)resolutionResult2.getDependencyType()) && (!this.dependencyResolutionService.isMavenAggregateModules() || !this.dependencyResolutionService.isSbtAggregateModules()) || DependencyType.GRADLE.equals((Object)resolutionResult2.getDependencyType()) && !this.dependencyResolutionService.isGradleAggregateModules()) && resolutionResult2.getResolvedProjects().size() > 1) {
                            allProjects.put(project2.getKey(), project2.getValue());
                            LinkedList<ViaComponents> listToNewProject = new LinkedList<ViaComponents>();
                            if (impactAnalysisLanguage != null) {
                                listToNewProject.add(viaComponents);
                            }
                            allProjectsToViaComponents.put(project2.getKey(), listToNewProject);
                        } else {
                            AgentProjectInfo currentProject = (AgentProjectInfo)allProjects.keySet().stream().findFirst().get();
                            currentProject.getDependencies().addAll(project2.getKey().getDependencies());
                            if (impactAnalysisLanguage != null) {
                                ((LinkedList)allProjectsToViaComponents.get(allProjects.keySet().stream().findFirst().get())).add(viaComponents);
                            }
                        }
                        impactAnalysisLanguage = null;
                        totalDependencies[0] = totalDependencies[0] + dependencies.size();
                        dependencies.forEach(dependency -> this.increaseCount((DependencyInfo)dependency, totalDependencies));
                    }
                    if (viaComponents == null) continue;
                    viaComponents.getDependencies().addAll(dependenciesToVia);
                }
                resolutionResults.addAll(resolutionResult);
            }
            this.logger.info(MessageFormat.format("Total dependencies found: {0}", totalDependencies[0]));
            if (!includeFsDependencies) {
                Set<String> set = resolutionResults.stream().flatMap(resolution -> resolution.getExcludes().stream()).collect(Collectors.toSet());
                set.addAll(Arrays.stream(excludes).collect(Collectors.toList()));
                excludes = new String[set.size()];
                excludes = set.toArray(excludes);
            }
            this.dependencyResolutionService = null;
        }
        String[] excludesExtended = this.excludeFileSystemAgent(excludes);
        this.logger.info("Scanning directories {} for matching Files (may take a few minutes)", pathsToScan);
        Map<File, Collection<String>> map = new FilesUtils().fillFilesMap(pathsToScan, includes, excludesExtended, followSymlinks, globCaseSensitive);
        long filesCount = map.entrySet().stream().flatMap(folder -> ((Collection)folder.getValue()).stream()).count();
        totalFiles = (int)((long)totalFiles + filesCount);
        this.logger.info(MessageFormat.format("Total files found according to the includes/excludes pattern: {0}", totalFiles));
        DependencyCalculator dependencyCalculator = new DependencyCalculator(this.showProgressBar);
        LinkedList<DependencyInfo> filesDependencies = new LinkedList<DependencyInfo>();
        if (!isIgnoreSourceFiles) {
            filesDependencies.addAll(dependencyCalculator.createDependencies(scmConnector, totalFiles, map, excludedCopyrights, partialSha1Match, calculateHints, calculateMd5));
        }
        if (allProjects.size() == 1) {
            AgentProjectInfo project3 = (AgentProjectInfo)allProjects.keySet().stream().findFirst().get();
            project3.getDependencies().addAll(filesDependencies);
        } else {
            Iterator entriesList = new ArrayList();
            allProjects.entrySet().forEach(entry -> {
                if (entry.getValue() != null) {
                    entriesList.add(entry);
                }
            });
            entriesList.sort(Map.Entry.comparingByValue());
            Collections.reverse(entriesList);
            LinkedHashMap result = new LinkedHashMap();
            entriesList.forEach(entry -> result.put((AgentProjectInfo)entry.getKey(), (Path)entry.getValue()));
            result.entrySet().forEach(project -> {
                Collection projectDependencies = filesDependencies.stream().filter(dependencyInfo -> project.getValue() != null && dependencyInfo.getSystemPath().contains(((Path)project.getValue()).toString())).collect(Collectors.toList());
                ((AgentProjectInfo)project.getKey()).getDependencies().addAll(projectDependencies);
                filesDependencies.removeAll(projectDependencies);
            });
            if (!isIgnoreSourceFiles && filesDependencies.size() > 0) {
                scannerBaseDirs.stream().forEach(directory -> {
                    String[] includesAll = new String[]{"**/*"};
                    List<Path> subDirectories = new FilesUtils().getSubDirectories((String)directory, includesAll, null, followSymlinks, globCaseSensitive);
                    subDirectories.forEach(subFolder -> {
                        List projectDependencies;
                        if (filesDependencies.size() > 0 && !(projectDependencies = filesDependencies.stream().filter(dependencyInfo -> dependencyInfo.getSystemPath().contains(subFolder.toString())).collect(Collectors.toList())).isEmpty()) {
                            AgentProjectInfo subProject;
                            if (this.isSeparateProjects) {
                                subProject = new AgentProjectInfo();
                                allProjects.put(subProject, null);
                                allProjectsToViaComponents.put(subProject, new LinkedList());
                                subProject.setCoordinates(new Coordinates(null, subFolder.toFile().getName(), null));
                            } else {
                                subProject = (AgentProjectInfo)((Map.Entry)allProjects.entrySet().stream().findFirst().get()).getKey();
                            }
                            subProject.getDependencies().addAll(filesDependencies);
                            filesDependencies.removeAll(projectDependencies);
                        }
                    });
                });
                if (!filesDependencies.isEmpty()) {
                    AgentProjectInfo agentProjectInfo = (AgentProjectInfo)((Map.Entry)allProjects.entrySet().stream().findFirst().get()).getKey();
                    agentProjectInfo.getDependencies().addAll(filesDependencies);
                }
            }
        }
        for (AgentProjectInfo innerProject : allProjects.keySet()) {
            block11: for (DependencyInfo dependencyInfo : innerProject.getDependencies()) {
                String systemPath = dependencyInfo.getSystemPath();
                if (systemPath == null) {
                    this.logger.debug("Dependency {} has no system path", (Object)dependencyInfo.getArtifactId());
                    continue;
                }
                for (String key : archiveToBaseDirMap.keySet()) {
                    if (!systemPath.contains(key) || !archiveExtraction) continue;
                    String newSystemPath = systemPath.replace(key, (CharSequence)archiveToBaseDirMap.get(key)).replaceAll("_depth_[0-9]", "");
                    this.logger.debug("Original system path: {}, new system path: {}, key: {}", new Object[]{systemPath, newSystemPath, key});
                    dependencyInfo.setSystemPath(newSystemPath);
                    continue block11;
                }
            }
        }
        if (!archiveDirectories.isEmpty()) {
            for (String archiveDirectory : archiveDirectories) {
                File file = new File(archiveDirectory);
                if (!file.exists()) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
        this.logger.info("Finished analyzing Files");
        systemStats = MemoryUsageHelper.getMemoryUsage();
        this.logger.debug(systemStats.toString());
        if (this.enableImpactAnalysis && this.iaLanguage != null) {
            AgentProjectInfo agentProjectInfo = (AgentProjectInfo)allProjectsToViaComponents.keySet().iterator().next();
            ((ViaComponents)((LinkedList)allProjectsToViaComponents.get(agentProjectInfo)).getFirst()).getDependencies().addAll(agentProjectInfo.getDependencies());
        }
        return allProjectsToViaComponents;
    }

    private String[] createResolversIncludesPattern(Collection<AbstractDependencyResolver> dependencyResolvers) {
        ArrayList<String> resultIncludes = new ArrayList<String>();
        for (AbstractDependencyResolver dependencyResolver : dependencyResolvers) {
            for (String extension : dependencyResolver.getSourceFileExtensions()) {
                resultIncludes.add("**/*" + extension);
            }
        }
        String[] resultArray = new String[resultIncludes.size()];
        resultIncludes.toArray(resultArray);
        return resultArray;
    }

    private Map<String, Set<String>> convertListDirsToMap(List<String> scannerBaseDirs) {
        HashMap<String, Set<String>> appPathsToDependencyDirs = new HashMap<String, Set<String>>();
        appPathsToDependencyDirs.put("defaultKey", new HashSet());
        for (String dir : scannerBaseDirs) {
            ((Set)appPathsToDependencyDirs.get("defaultKey")).add(dir);
        }
        return appPathsToDependencyDirs;
    }

    private Set<String> getCanonicalPaths(Collection<String> scannerBaseDirs) {
        HashSet<String> pathsToScan = new HashSet<String>();
        for (String path : scannerBaseDirs) {
            try {
                pathsToScan.add(new File(path).getCanonicalPath());
            }
            catch (IOException e) {
                this.logger.debug("Error finding the canonical path of {}", (Object)path);
                pathsToScan.add(path);
            }
        }
        return pathsToScan;
    }

    private void increaseCount(DependencyInfo dependency, int[] totalDependencies) {
        totalDependencies[0] = totalDependencies[0] + dependency.getChildren().size();
        dependency.getChildren().forEach(dependencyInfo -> this.increaseCount((DependencyInfo)dependencyInfo, totalDependencies));
    }

    private String[] excludeFileSystemAgent(String[] excludes) {
        String[] allExcludes = excludes == null ? new String[]{} : excludes;
        String[] excludesFSA = new String[allExcludes.length + 1];
        System.arraycopy(allExcludes, 0, excludesFSA, 0, allExcludes.length);
        excludesFSA[allExcludes.length] = this.FSA_FILE;
        return excludesFSA;
    }
}

