/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.Constants;
import org.whitesource.agent.ViaComponents;
import org.whitesource.agent.ViaLanguage;
import org.whitesource.agent.api.dispatch.BaseCheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.api.dispatch.UpdateType;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.client.WhitesourceService;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.agent.report.OfflineUpdateRequest;
import org.whitesource.agent.report.PolicyCheckReport;
import org.whitesource.agent.utils.Pair;
import org.whitesource.contracts.PluginInfo;
import org.whitesource.fs.LogMapAppender;
import org.whitesource.fs.ProjectsDetails;
import org.whitesource.fs.StatusCode;
import org.whitesource.fs.configuration.OfflineConfiguration;
import org.whitesource.fs.configuration.RequestConfiguration;
import org.whitesource.fs.configuration.SenderConfiguration;

public class ProjectsSender {
    private static final String DATE_FORMAT = "HH:mm:ss";
    public static final String PROJECT_URL_PREFIX = "Wss/WSS.html#!project;id=";
    protected static final int MAX_LOG_EVENTS = 1000;
    private final Logger logger = LoggerFactory.getLogger(ProjectsSender.class);
    private final SenderConfiguration senderConfig;
    private final OfflineConfiguration offlineConfig;
    private final RequestConfiguration requestConfig;
    private final PluginInfo pluginInfo;
    protected StatusCode prepStepStatusCode = StatusCode.SUCCESS;

    public ProjectsSender(SenderConfiguration senderConfig, OfflineConfiguration offlineConfig, RequestConfiguration requestConfig, PluginInfo pluginInfo) {
        this.senderConfig = senderConfig;
        this.offlineConfig = offlineConfig;
        this.requestConfig = requestConfig;
        this.pluginInfo = pluginInfo;
    }

    public Pair<String, StatusCode> sendRequest(ProjectsDetails projectsDetails) {
        this.logger.info("Initializing WhiteSource Client");
        Collection<AgentProjectInfo> projects = projectsDetails.getProjects();
        WhitesourceService service = this.createService();
        String resultInfo = "";
        if (this.offlineConfig.isEnabled()) {
            resultInfo = this.offlineUpdate(service, projects);
            return new Pair<String, StatusCode>(resultInfo, this.prepStepStatusCode);
        }
        UpdateType updateType = UpdateType.OVERRIDE;
        String updateTypeValue = this.senderConfig.getUpdateTypeValue();
        try {
            updateType = UpdateType.valueOf((String)updateTypeValue);
        }
        catch (Exception e) {
            this.logger.info("Invalid value {} for updateType, defaulting to {}", (Object)updateTypeValue, (Object)UpdateType.OVERRIDE);
        }
        this.logger.info("UpdateType set to {} ", (Object)updateTypeValue);
        this.checkDependenciesUpbound(projects);
        StatusCode statusCode = StatusCode.SUCCESS;
        if (this.senderConfig.isEnableImpactAnalysis()) {
            this.runViaAnalysis(projectsDetails, service);
        } else if (!this.senderConfig.isEnableImpactAnalysis()) {
            // empty if block
        }
        int retries = this.senderConfig.getConnectionRetries();
        while (retries-- > -1) {
            try {
                statusCode = this.checkPolicies(service, projects);
                if (statusCode != StatusCode.SUCCESS && (!this.senderConfig.isForceUpdate() || !this.senderConfig.isForceUpdateFailBuildOnPolicyViolation())) break;
                resultInfo = this.update(service, projects);
                break;
            }
            catch (WssServiceException e) {
                String requestToken;
                if (e.getCause() != null && e.getCause().getClass().getCanonicalName().substring(0, e.getCause().getClass().getCanonicalName().lastIndexOf(".")).equals("java.net")) {
                    statusCode = StatusCode.CONNECTION_FAILURE;
                    this.logger.error("Trying " + (retries + 1) + " more time" + (retries != 0 ? "s" : ""));
                } else {
                    statusCode = StatusCode.SERVER_FAILURE;
                    retries = -1;
                }
                resultInfo = "Failed to send request to Checkmarx server: " + e.getMessage();
                this.logger.error(resultInfo, (Object)e.getMessage());
                this.logger.debug(resultInfo, (Throwable)e);
                if (retries > -1) {
                    try {
                        Thread.sleep(this.senderConfig.getConnectionRetriesIntervals());
                    }
                    catch (InterruptedException e1) {
                        this.logger.error("Failed to sleep while retrying to connect to server " + e1.getMessage(), (Throwable)e1);
                    }
                }
                if (!StringUtils.isNotBlank((String)(requestToken = e.getRequestToken()))) continue;
                resultInfo = resultInfo + Constants.NEW_LINE + "Support token: " + requestToken;
                this.logger.info("Support token: {}", (Object)requestToken);
            }
        }
        if (service != null) {
            service.shutdown();
        }
        if (statusCode == StatusCode.SUCCESS) {
            return new Pair<String, StatusCode>(resultInfo, this.prepStepStatusCode);
        }
        return new Pair<String, StatusCode>(resultInfo, statusCode);
    }

    private void runViaAnalysis(ProjectsDetails projectsDetails, WhitesourceService service) {
        try {
            Class<?> vulnerabilitiesAnalysisClass = Class.forName("whitesource.analysis.vulnerabilities.VulnerabilitiesAnalysis");
            Method getAnalysisMethod = vulnerabilitiesAnalysisClass.getMethod("getAnalysis", String.class, Integer.TYPE);
            Object vulnerabilitiesAnalysis = null;
            for (AgentProjectInfo project : projectsDetails.getProjectToViaComponents().keySet()) {
                LinkedList<ViaComponents> viaComponentsList = projectsDetails.getProjectToViaComponents().get(project);
                for (ViaComponents viaComponents : viaComponentsList) {
                    this.logger.info("Starting VIA impact analysis");
                    String appPath = viaComponents.getAppPath();
                    ViaLanguage language = viaComponents.getLanguage();
                    try {
                        vulnerabilitiesAnalysis = getAnalysisMethod.invoke(null, language.toString(), this.requestConfig.getViaAnalysisLevel());
                        if (language.equals((Object)ViaLanguage.JAVA_SCRIPT)) {
                            int lastIndex = appPath.lastIndexOf("\\") != -1 ? appPath.lastIndexOf("\\") : appPath.lastIndexOf("/");
                            appPath = appPath.substring(0, lastIndex);
                        }
                        if (vulnerabilitiesAnalysis == null) continue;
                        AgentProjectInfo projectToServer = new AgentProjectInfo();
                        projectToServer.setDependencies(Lists.newArrayList((Collection)project.getDependencies()));
                        projectToServer.setProjectSetupDescription(project.getProjectSetupDescription());
                        projectToServer.setCoordinates(project.getCoordinates());
                        projectToServer.setProjectToken(project.getProjectToken());
                        projectToServer.setProjectSetupStatus(project.getProjectSetupStatus());
                        projectToServer.setParentCoordinates(project.getParentCoordinates());
                        Class<?> fsaAgentServerClass = Class.forName("whitesource.analysis.server.FSAgentServer");
                        Object server = fsaAgentServerClass.getConstructor(AgentProjectInfo.class, WhitesourceService.class, String.class, String.class).newInstance(projectToServer, service, this.requestConfig.getApiToken(), this.requestConfig.getUserKey());
                        this.logger.info("Starting analysis for: {}", (Object)appPath);
                        Class<?> serverClass = Class.forName("whitesource.analysis.server.Server");
                        Method runAnalysis = vulnerabilitiesAnalysisClass.getDeclaredMethod("runAnalysis", serverClass, String.class, Collection.class, Boolean.class);
                        runAnalysis.invoke(vulnerabilitiesAnalysis, server, appPath, project.getDependencies(), Boolean.valueOf(this.requestConfig.getViaDebug()));
                        this.logger.info("Got impact analysis result from server");
                    }
                    catch (InvocationTargetException e) {
                        this.logger.error("Failed to run VIA impact analysis {}", (Object)e.getTargetException().getMessage());
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to run VIA impact analysis {}", (Object)e.getMessage());
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            this.logger.error("Failed to run VIA impact analysis, couldn't find method {}", (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Failed to run VIA impact analysis, couldn't find class {}", (Object)e.getMessage());
        }
    }

    private void checkDependenciesUpbound(Collection<AgentProjectInfo> projects) {
        int numberOfDependencies = projects.stream().map(x -> x.getDependencies()).mapToInt(x -> x.size()).sum();
        if (numberOfDependencies > 1000000) {
            this.logger.warn("Number of dependencies: {} exceeded the maximum supported: {}", (Object)numberOfDependencies, (Object)1000000);
        }
    }

    protected WhitesourceService createService() {
        this.logger.info("Service URL is " + this.senderConfig.getServiceUrl());
        boolean setProxy = false;
        if (StringUtils.isNotBlank((String)this.senderConfig.getProxyHost()) || !this.offlineConfig.isEnabled()) {
            setProxy = true;
        }
        int connectionTimeoutMinutes = this.senderConfig.getConnectionTimeOut();
        WhitesourceService service = new WhitesourceService(this.pluginInfo.getAgentType(), this.pluginInfo.getAgentVersion(), this.pluginInfo.getPluginVersion(), this.senderConfig.getServiceUrl(), setProxy, connectionTimeoutMinutes, this.senderConfig.isIgnoreCertificateCheck());
        if (StringUtils.isNotBlank((String)this.senderConfig.getProxyHost())) {
            service.getClient().setProxy(this.senderConfig.getProxyHost(), this.senderConfig.getProxyPort(), this.senderConfig.getProxyUser(), this.senderConfig.getProxyPassword());
        }
        return service;
    }

    private StatusCode checkPolicies(WhitesourceService service, Collection<AgentProjectInfo> projects) throws WssServiceException {
        boolean policyCompliance = true;
        if (this.senderConfig.isCheckPolicies()) {
            String requestToken;
            CheckPolicyComplianceResult checkPoliciesResult;
            this.logger.info("Checking policies");
            if (this.senderConfig.isSendLogsToWss()) {
                String logData = this.getLogData();
                checkPoliciesResult = service.checkPolicyCompliance(this.requestConfig.getApiToken(), this.requestConfig.getProductNameOrToken(), this.requestConfig.getProductVersion(), projects, this.senderConfig.isForceCheckAllDependencies(), this.requestConfig.getUserKey(), this.requestConfig.getRequesterEmail(), logData);
            } else {
                checkPoliciesResult = service.checkPolicyCompliance(this.requestConfig.getApiToken(), this.requestConfig.getProductNameOrToken(), this.requestConfig.getProductVersion(), projects, this.senderConfig.isForceCheckAllDependencies(), this.requestConfig.getUserKey(), this.requestConfig.getRequesterEmail());
            }
            if (checkPoliciesResult.hasRejections()) {
                if (this.senderConfig.isForceUpdate()) {
                    this.logger.info("Some dependencies violate open source policies, however all were force updated to organization inventory.");
                    if (this.senderConfig.isForceUpdateFailBuildOnPolicyViolation()) {
                        policyCompliance = false;
                    }
                } else {
                    this.logger.info("Some dependencies did not conform with open source policies, review report for details");
                    this.logger.info("=== UPDATE ABORTED ===");
                    policyCompliance = false;
                }
            } else {
                this.logger.info("All dependencies conform with open source policies.");
            }
            if (StringUtils.isNotBlank((String)(requestToken = checkPoliciesResult.getRequestToken()))) {
                this.logger.info("Check Policies Support Token: {}", (Object)requestToken);
            }
            try {
                PolicyCheckReport report = new PolicyCheckReport((BaseCheckPoliciesResult)checkPoliciesResult);
                File outputDir = new File(this.offlineConfig.getWhiteSourceFolderPath());
                report.generate(outputDir, false);
                report.generateJson(outputDir);
                this.logger.info("Policies report generated successfully");
            }
            catch (IOException e) {
                this.logger.error("Error generating check policies report: " + e.getMessage(), (Throwable)e);
            }
        }
        return policyCompliance ? StatusCode.SUCCESS : StatusCode.POLICY_VIOLATION;
    }

    protected String update(WhitesourceService service, Collection<AgentProjectInfo> projects) throws WssServiceException {
        UpdateInventoryResult updateResult;
        this.logger.info("Sending Update");
        if (this.senderConfig.isSendLogsToWss()) {
            String logData = this.getLogData();
            updateResult = service.update(this.requestConfig.getApiToken(), this.requestConfig.getRequesterEmail(), UpdateType.valueOf((String)this.senderConfig.getUpdateTypeValue()), this.requestConfig.getProductNameOrToken(), this.requestConfig.getProductVersion(), projects, this.requestConfig.getUserKey(), logData);
        } else {
            updateResult = service.update(this.requestConfig.getApiToken(), this.requestConfig.getRequesterEmail(), UpdateType.valueOf((String)this.senderConfig.getUpdateTypeValue()), this.requestConfig.getProductNameOrToken(), this.requestConfig.getProductVersion(), projects, this.requestConfig.getUserKey());
        }
        String resultInfo = this.logResult(updateResult);
        resultInfo = resultInfo.replace(System.lineSeparator(), "");
        return resultInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String offlineUpdate(WhitesourceService service, Collection<AgentProjectInfo> projects) {
        String resultInfo = "";
        this.logger.info("Generating offline update request");
        UpdateInventoryRequest updateRequest = service.offlineUpdate(this.requestConfig.getApiToken(), this.requestConfig.getProductNameOrToken(), this.requestConfig.getProductVersion(), projects, this.requestConfig.getUserKey());
        if (this.senderConfig.isSendLogsToWss()) {
            updateRequest.setLogData(this.getLogData());
        }
        updateRequest.setRequesterEmail(this.requestConfig.getRequesterEmail());
        try {
            UpdateType updateTypeFinal;
            OfflineUpdateRequest offlineUpdateRequest = new OfflineUpdateRequest(updateRequest);
            if (StringUtils.isNotBlank((String)this.senderConfig.getUpdateTypeValue())) {
                try {
                    updateTypeFinal = UpdateType.valueOf((String)this.senderConfig.getUpdateTypeValue());
                }
                catch (Exception e) {
                    this.logger.info("Invalid value {} for updateType, defaulting to {}", (Object)this.senderConfig.getUpdateTypeValue(), (Object)UpdateType.OVERRIDE);
                    updateTypeFinal = UpdateType.OVERRIDE;
                }
            } else {
                updateTypeFinal = updateRequest.getUpdateType();
            }
            this.logger.info("UpdateType offline set to {} ", (Object)updateTypeFinal);
            updateRequest.setUpdateType(updateTypeFinal);
            File outputDir = new File(this.offlineConfig.getWhiteSourceFolderPath()).getAbsoluteFile();
            if (!outputDir.exists() && !outputDir.mkdir()) {
                throw new IOException("Unable to make output directory: " + outputDir);
            }
            File file = offlineUpdateRequest.generate(outputDir, this.offlineConfig.isZip(), this.offlineConfig.isPrettyJson());
            resultInfo = "Offline request generated successfully at " + file.getPath();
            this.logger.info(resultInfo);
        }
        catch (IOException e) {
            resultInfo = "Error generating offline update request: " + e.getMessage();
            this.logger.error(resultInfo);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        return resultInfo;
    }

    private String logResult(UpdateInventoryResult updateResult) {
        String requestToken;
        StringBuilder resultLogMsg = new StringBuilder("Inventory update results for ").append(updateResult.getOrganization()).append(Constants.NEW_LINE);
        this.logger.info("Inventory update results for {}", (Object)updateResult.getOrganization());
        Collection createdProjects = updateResult.getCreatedProjects();
        if (createdProjects.isEmpty()) {
            this.logger.info("No new projects found.");
            resultLogMsg.append("No new projects found.").append(Constants.NEW_LINE);
        } else {
            this.logger.info("Newly created projects:");
            resultLogMsg.append("Newly created projects:").append(Constants.NEW_LINE);
            for (Object projectName : createdProjects) {
                this.logger.info("# {}", projectName);
                resultLogMsg.append((String)projectName).append(Constants.NEW_LINE);
            }
        }
        Collection updatedProjects = updateResult.getUpdatedProjects();
        if (updatedProjects.isEmpty()) {
            this.logger.info("No projects were updated.");
            resultLogMsg.append("No projects were updated.").append(Constants.NEW_LINE);
        } else {
            this.logger.info("Updated projects:");
            resultLogMsg.append("Updated projects:").append(Constants.NEW_LINE);
            for (Object projectName : updatedProjects) {
                this.logger.info("# {}", projectName);
                resultLogMsg.append((String)projectName).append(Constants.NEW_LINE);
            }
        }
        HashMap projectsUrls = updateResult.getProjectNamesToIds();
        if (projectsUrls != null && !projectsUrls.isEmpty()) {
            for (String projectName : projectsUrls.keySet()) {
                String appUrl = this.senderConfig.getServiceUrl().replace("agent", "");
                String projectsUrl = appUrl + PROJECT_URL_PREFIX + projectsUrls.get(projectName);
                this.logger.info("Project name: {}, URL: {}", (Object)projectName, (Object)projectsUrl);
                resultLogMsg.append(Constants.NEW_LINE).append("Project name: ").append(projectName).append(", project URL:").append(projectsUrl);
            }
        }
        if (StringUtils.isNotBlank((String)(requestToken = updateResult.getRequestToken()))) {
            this.logger.info("Support Token: {}", (Object)requestToken);
            resultLogMsg.append(Constants.NEW_LINE).append("Support Token: ").append(requestToken);
        }
        return resultLogMsg.toString();
    }

    private String getLogData() {
        String logs = "";
        ch.qos.logback.classic.Logger setLog = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.whitesource");
        ConcurrentSkipListMap collectToSet = ((LogMapAppender)setLog.getAppender("collectToMap")).getLogEvents();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        List events = collectToSet.values().stream().filter(iLoggingEvent -> !iLoggingEvent.getMessage().isEmpty() && !iLoggingEvent.getMessage().equals(Constants.NEW_LINE)).collect(Collectors.toList());
        if (events.size() > 1000) {
            events = events.stream().filter(iLoggingEvent -> iLoggingEvent.getLevel().levelInt >= Level.INFO.levelInt).collect(Collectors.toList());
        }
        for (ILoggingEvent event : events) {
            logs = logs.concat("[" + event.getLevel() + "] " + simpleDateFormat.format(new Date(event.getTimeStamp())) + " - " + event.getFormattedMessage()).concat(Constants.NEW_LINE);
        }
        return logs;
    }
}

