/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.bower;

import java.text.MessageFormat;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.dependency.resolver.npm.NpmBomParser;

public class BowerBomParser
extends NpmBomParser {
    public static final String RESOLUTION = "_resolution";
    public static final String BOWER_PACKAGE_FILENAME_FORMAT = "{0}-{1}";
    private final Logger logger = LoggerFactory.getLogger(NpmBomParser.class);

    @Override
    protected String getVersion(JSONObject json, String fileName) {
        String version = "";
        if (json.has(RESOLUTION)) {
            JSONObject jObj = json.getJSONObject(RESOLUTION);
            if (jObj.has("tag")) {
                return jObj.getString("tag");
            }
            this.logger.debug("version not found in file {}", (Object)fileName);
            return "";
        }
        return version;
    }

    @Override
    protected String getFilename(String name, String version) {
        return MessageFormat.format(BOWER_PACKAGE_FILENAME_FORMAT, name, version);
    }
}

