/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.bower;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.bower.BowerBomParser;
import org.whitesource.agent.dependency.resolver.bower.BowerLsJsonDependencyCollector;
import org.whitesource.agent.dependency.resolver.npm.NpmDependencyResolver;

public class BowerDependencyResolver
extends NpmDependencyResolver {
    private static final String BOWER_JSON = "bower.json";
    public static final String WS_BOWER_FILE2 = "**/*ws_bower.json";
    public static final String WS_BOWER_FILE1 = "**/*ws-log-response-bower.json";
    private final BowerBomParser bomParser = new BowerBomParser();
    private final BowerLsJsonDependencyCollector bomCollector;

    public BowerDependencyResolver(long npmTimeoutDependenciesCollector, boolean runPreStep) {
        super(runPreStep, null);
        this.bomCollector = new BowerLsJsonDependencyCollector(npmTimeoutDependenciesCollector);
    }

    @Override
    protected BowerLsJsonDependencyCollector getDependencyCollector() {
        return this.bomCollector;
    }

    @Override
    public String[] getBomPattern() {
        return new String[]{"**/*bower.json"};
    }

    @Override
    public String getPreferredFileName() {
        return ".bower.json";
    }

    @Override
    protected BowerBomParser getBomParser() {
        return this.bomParser;
    }

    @Override
    protected void enrichDependency(DependencyInfo dependency, BomFile packageJson, String npmAccessToken) {
        dependency.setGroupId(packageJson.getName());
        dependency.setArtifactId(packageJson.getName());
        dependency.setVersion(packageJson.getVersion());
        dependency.setSystemPath(packageJson.getLocalFileName());
        dependency.setFilename(packageJson.getFileName());
        dependency.setDependencyType(this.getDependencyType());
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add(WS_BOWER_FILE2);
        excludes.add(WS_BOWER_FILE1);
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return Arrays.asList(".js");
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.BOWER;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.BOWER.name();
    }

    @Override
    protected boolean isMatchChildDependency(DependencyInfo childDependency, String name, String version) {
        return childDependency.getGroupId().equals(name) && childDependency.getVersion().equals(version);
    }
}

