/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.dotNet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.npm.NpmLsJsonDependencyCollector;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.fs.FsUtils;

public class DotNetRestoreCollector
extends DependencyCollector {
    private static final Logger logger = LoggerFactory.getLogger(NpmLsJsonDependencyCollector.class);
    public static final String DOTNET_RESTORE_TMP_DIRECTORY = Paths.get(FsUtils.getTmpDir(), "WhiteSource-DotnetRestore").toString();
    public static final String DOTNET_COMMAND = "dotnet";
    public static final String RESTORE = "restore";
    public static final String PACKAGES = "--packages";
    public static final String DOT_NET_RESTORE_WS = "DotNetRestoreWS";
    public static final String NUPKG = ".nupkg";
    public static final String BACK_SLASH = DotNetRestoreCollector.isWindows() ? "\\" : "/";
    private static String[] includes = new String[]{"**/*.nupkg"};
    private static String[] excludes = new String[0];
    private int serialNumber = 0;
    private Collection<String> pathsToScan = new LinkedList<String>();

    @Override
    public Collection<AgentProjectInfo> collectDependencies(String rootDirectory) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        Map<File, Collection<String>> folderMapToFiles = new FilesUtils().fillFilesMap(this.pathsToScan, includes, excludes, true, false);
        for (File file : folderMapToFiles.keySet()) {
            for (String shortPath : folderMapToFiles.get(file)) {
                String nugetFilePath = file.getAbsolutePath() + BACK_SLASH + shortPath;
                DependencyInfo dependency = this.getDependency(nugetFilePath, shortPath);
                dependencies.add(dependency);
            }
        }
        this.deleteDirectories();
        logger.debug("Finish deleting directories of {} {}", (Object)DOTNET_COMMAND, (Object)RESTORE);
        return this.getSingleProjectList(dependencies);
    }

    public void executeDotNetRestore(String folder, Set<String> csprojFiles) {
        for (String csprojFile : csprojFiles) {
            String pathToDownloadPackages = DOTNET_RESTORE_TMP_DIRECTORY + BACK_SLASH + this.getNameOfFolderPackages(csprojFile) + this.serialNumber;
            ++this.serialNumber;
            CharSequence[] command = this.getInstallParams(pathToDownloadPackages, csprojFile);
            String commandString = String.join((CharSequence)" ", command);
            logger.debug("Running command : '{}'", (Object)commandString);
            CommandLineProcess dotNetRestore = new CommandLineProcess(folder, (String[])command);
            try {
                dotNetRestore.executeProcess();
            }
            catch (IOException e) {
                logger.error("Could not run '{}' in folder: {}", (Object)commandString, (Object)folder);
            }
            if (!dotNetRestore.isErrorInProcess()) {
                logger.debug("Finish to run '{}'", (Object)commandString);
                this.pathsToScan.add(pathToDownloadPackages);
                continue;
            }
            logger.warn("Could not run '{}' in folder: {}", (Object)commandString, (Object)folder);
        }
    }

    protected String[] getInstallParams(String pathToDownloadPackages, String csprojFile) {
        return new String[]{DOTNET_COMMAND, RESTORE, csprojFile, PACKAGES, pathToDownloadPackages};
    }

    private String getNameOfFolderPackages(String csprojFile) {
        Pattern pattern = Pattern.compile(".*[/\\\\](.*)\\.csproj");
        Matcher matcher = pattern.matcher(csprojFile);
        matcher.find();
        return matcher.group(1) + DOT_NET_RESTORE_WS;
    }

    private void deleteDirectories() {
        File mainDirectory = new File(DOTNET_RESTORE_TMP_DIRECTORY);
        FilesUtils.deleteDirectory(mainDirectory);
    }

    private String getSha1(String filePath) {
        try {
            return ChecksumUtils.calculateSHA1((File)new File(filePath));
        }
        catch (IOException e) {
            logger.info("Failed getting " + filePath + ". File will not be send to Checkmarx server.");
            return "";
        }
    }

    private DependencyInfo getDependency(String nugetFilePath, String shortPath) {
        DependencyInfo dependency = new DependencyInfo();
        String name = this.getPackageName(shortPath);
        dependency.setArtifactId(name + "." + this.getVersion(shortPath) + NUPKG);
        String sha1 = this.getSha1(nugetFilePath);
        dependency.setSha1(sha1);
        return dependency;
    }

    private String getPackageName(String path) {
        int indexBackslash = path.indexOf(BACK_SLASH);
        return path.substring(0, indexBackslash);
    }

    private String getVersion(String path) {
        int indexBackslash = path.indexOf(BACK_SLASH);
        int indexSecondBackslash = path.indexOf(BACK_SLASH, indexBackslash + 1);
        return path.substring(indexBackslash + 1, indexSecondBackslash);
    }
}

