/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.go;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.go.GoDependencyManager;
import org.whitesource.agent.utils.Cli;
import org.whitesource.agent.utils.CommandLineProcess;

public class GoDependencyResolver
extends AbstractDependencyResolver {
    private final Logger logger = LoggerFactory.getLogger(GoDependencyResolver.class);
    private static final String PROJECTS = "[[projects]]";
    private static final String DEPS = "Deps";
    private static final String REV = "Rev";
    private static final String COMMENT = "Comment";
    private static final String IMPORT_PATH = "ImportPath";
    private static final String NAME = "name = ";
    private static final String VERSION = "version = ";
    private static final String REVISION = "revision = ";
    private static final String PACKAGES = "packages = ";
    private static final String BRACKET = "]";
    private static final String DOT = ".";
    private static final String GOPKG_LOCK = "Gopkg.lock";
    private static final String GODEPS_JSON = "Godeps.json";
    private static final String VNDR_CONF = "vendor.conf";
    private static final String GO_EXTENTION = ".go";
    private static final String GO_ENSURE = "ensure";
    private static final String GO_INIT = "init";
    private static final String GO_SAVE = "save";
    private static final List<String> GO_SCRIPT_EXTENSION = Arrays.asList(".lock", ".json", ".go");
    private Cli cli = new Cli();
    private GoDependencyManager goDependencyManager;
    private boolean collectDependenciesAtRuntime;
    private boolean isDependenciesOnly;

    public GoDependencyResolver(GoDependencyManager goDependencyManager, boolean collectDependenciesAtRuntime, boolean isDependenciesOnly) {
        this.goDependencyManager = goDependencyManager;
        this.collectDependenciesAtRuntime = collectDependenciesAtRuntime;
        this.isDependenciesOnly = isDependenciesOnly;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        List<DependencyInfo> dependencies = this.collectDependencies(topLevelFolder);
        return new ResolutionResult(dependencies, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    @Override
    protected Collection<String> getExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        if (!this.collectDependenciesAtRuntime && this.goDependencyManager != null && this.isDependenciesOnly) {
            excludes.add("**/*.go");
        }
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return GO_SCRIPT_EXTENSION;
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.GO;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.GO.name();
    }

    @Override
    protected String[] getBomPattern() {
        if (this.collectDependenciesAtRuntime || this.goDependencyManager == null) {
            return new String[]{"**/*.go"};
        }
        if (this.goDependencyManager != null) {
            switch (this.goDependencyManager) {
                case DEP: {
                    return new String[]{"**/*Gopkg.lock"};
                }
                case GO_DEP: {
                    return new String[]{"**/*Godeps.json"};
                }
                case VNDR: {
                    return new String[]{"**/*vendor.conf"};
                }
            }
        }
        return new String[]{""};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return null;
    }

    private List<DependencyInfo> collectDependencies(String rootDirectory) {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        String error = null;
        long creationTime = new Date().getTime();
        if (this.goDependencyManager != null) {
            try {
                switch (this.goDependencyManager) {
                    case DEP: {
                        this.collectDepDependencies(rootDirectory, dependencyInfos);
                        break;
                    }
                    case GO_DEP: {
                        this.collectGoDepDependencies(rootDirectory, dependencyInfos);
                        break;
                    }
                    case VNDR: {
                        this.collectVndrDependencies(rootDirectory, dependencyInfos);
                        break;
                    }
                    default: {
                        error = "The selected dependency manager - " + this.goDependencyManager.getType() + " - is not supported.";
                        break;
                    }
                }
            }
            catch (Exception e) {
                error = e.getMessage();
            }
        } else {
            error = this.collectDependenciesWithoutDefinedManager(rootDirectory, dependencyInfos);
        }
        if (error != null) {
            this.logger.error(error);
        }
        if (this.collectDependenciesAtRuntime) {
            this.removeTempFiles(rootDirectory, creationTime);
        }
        return dependencyInfos;
    }

    private String collectDependenciesWithoutDefinedManager(String rootDirectory, List<DependencyInfo> dependencyInfos) {
        String error = null;
        try {
            this.collectDepDependencies(rootDirectory, dependencyInfos);
        }
        catch (Exception e) {
            try {
                this.collectGoDepDependencies(rootDirectory, dependencyInfos);
            }
            catch (Exception e1) {
                try {
                    this.collectVndrDependencies(rootDirectory, dependencyInfos);
                }
                catch (Exception e2) {
                    error = "Couldn't collect dependencies - no dependency manager is installed";
                }
            }
        }
        return error;
    }

    private void collectDepDependencies(String rootDirectory, List<DependencyInfo> dependencyInfos) throws Exception {
        this.logger.debug("collecting dependencies using 'dep'");
        File goPkgLock = new File(rootDirectory + fileSeparator + GOPKG_LOCK);
        String error = "";
        if (goPkgLock.isFile()) {
            if (!this.runCmd(rootDirectory, this.cli.getCommandParams(GoDependencyManager.DEP.getType(), GO_ENSURE))) {
                this.logger.warn("Can't run 'dep ensure' command, output might be outdated.  Run the 'dep ensure' command manually.");
            }
            dependencyInfos.addAll(this.parseGopckLock(goPkgLock));
        } else if (this.collectDependenciesAtRuntime) {
            if (this.runCmd(rootDirectory, this.cli.getCommandParams(GoDependencyManager.DEP.getType(), GO_INIT))) {
                dependencyInfos.addAll(this.parseGopckLock(goPkgLock));
            } else {
                error = "Can't run 'dep init' command.  Make sure dep is installed and run the 'dep init' command manually.";
            }
        } else {
            error = "Can't find Gopkg.lock file.  Run the 'dep init' command.";
        }
        if (!error.isEmpty()) {
            throw new Exception(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DependencyInfo> parseGopckLock(File goPckLock) {
        this.logger.debug("parsing {}", (Object)goPckLock.getPath());
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        FileReader fileReader = null;
        try {
            String currLine;
            fileReader = new FileReader(goPckLock);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean insideProject = false;
            boolean resolveRepositoryPackages = false;
            boolean useParent = false;
            DependencyInfo dependencyInfo2 = null;
            ArrayList<String> repositoryPackages = null;
            while ((currLine = bufferedReader.readLine()) != null) {
                if (insideProject) {
                    String name;
                    if (currLine.isEmpty()) {
                        insideProject = false;
                        if (dependencyInfo2 == null) continue;
                        if (repositoryPackages == null || useParent) {
                            dependencyInfos.add(dependencyInfo2);
                        }
                        if (repositoryPackages == null) continue;
                        for (String name2 : repositoryPackages) {
                            DependencyInfo packageDependencyInfo = new DependencyInfo(dependencyInfo2.getGroupId(), dependencyInfo2.getArtifactId() + "/" + name2, dependencyInfo2.getVersion());
                            packageDependencyInfo.setCommit(dependencyInfo2.getCommit());
                            dependencyInfos.add(packageDependencyInfo);
                        }
                        repositoryPackages = null;
                        continue;
                    }
                    if (resolveRepositoryPackages) {
                        if (currLine.contains(BRACKET)) {
                            resolveRepositoryPackages = false;
                            continue;
                        }
                        name = this.getValue(currLine);
                        if (name.equals(DOT)) {
                            useParent = true;
                            continue;
                        }
                        repositoryPackages.add(this.getValue(currLine));
                        continue;
                    }
                    if (currLine.contains(NAME)) {
                        name = this.getValue(currLine);
                        dependencyInfo2.setGroupId(this.getGroupId(name));
                        dependencyInfo2.setArtifactId(name);
                        continue;
                    }
                    if (currLine.contains(VERSION)) {
                        dependencyInfo2.setVersion(this.getValue(currLine));
                        continue;
                    }
                    if (currLine.contains(REVISION)) {
                        dependencyInfo2.setCommit(this.getValue(currLine));
                        continue;
                    }
                    if (currLine.contains(PACKAGES) && !currLine.contains(BRACKET)) {
                        resolveRepositoryPackages = true;
                        repositoryPackages = new ArrayList<String>();
                        continue;
                    }
                    if (!currLine.contains(PACKAGES) || currLine.contains(DOT)) continue;
                    name = this.getValue(currLine);
                    repositoryPackages = new ArrayList<String>(Arrays.asList(name));
                    continue;
                }
                if (!currLine.equals(PROJECTS)) continue;
                dependencyInfo2 = new DependencyInfo();
                insideProject = true;
                useParent = false;
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Can't find " + goPckLock.getPath());
        }
        catch (IOException e) {
            this.logger.error("Can't read " + goPckLock.getPath());
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    this.logger.error("can't close {}: {}", (Object)goPckLock.getPath(), (Object)e.getMessage());
                }
            }
        }
        dependencyInfos.stream().forEach(dependencyInfo -> {
            dependencyInfo.setSystemPath(goPckLock.getPath());
            dependencyInfo.setDependencyType(DependencyType.GO);
        });
        return dependencyInfos;
    }

    private String getValue(String line) {
        int firstIndex = line.indexOf("\"");
        int lastIndex = line.lastIndexOf("\"");
        String value = line.substring(firstIndex + 1, lastIndex);
        return value;
    }

    private void collectGoDepDependencies(String rootDirectory, List<DependencyInfo> dependencyInfos) throws Exception {
        this.logger.debug("collecting dependencies using 'godep'");
        File goDepJson = new File(rootDirectory + fileSeparator + "Godeps" + fileSeparator + GODEPS_JSON);
        if (!(goDepJson.isFile() || this.collectDependenciesAtRuntime && this.runCmd(rootDirectory, this.cli.getCommandParams(GoDependencyManager.GO_DEP.getType(), GO_SAVE)))) {
            throw new Exception("Can't find Godeps.json file.  Please make sure 'godep' is installed and run 'godep save' command");
        }
        dependencyInfos.addAll(this.parseGoDeps(goDepJson));
    }

    private List<DependencyInfo> parseGoDeps(File goDeps) throws IOException {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        JsonParser parser = new JsonParser();
        try (FileReader fileReader = null;){
            fileReader = new FileReader(goDeps.getPath());
            JsonElement element = parser.parse((Reader)fileReader);
            if (element.isJsonObject()) {
                JsonArray deps = element.getAsJsonObject().getAsJsonArray(DEPS);
                for (int i = 0; i < deps.size(); ++i) {
                    DependencyInfo dependencyInfo = new DependencyInfo();
                    JsonObject dep = deps.get(i).getAsJsonObject();
                    String importPath = dep.get(IMPORT_PATH).getAsString();
                    dependencyInfo.setGroupId(this.getGroupId(importPath));
                    dependencyInfo.setArtifactId(importPath);
                    dependencyInfo.setCommit(dep.get(REV).getAsString());
                    dependencyInfo.setDependencyType(DependencyType.GO);
                    dependencyInfo.setSystemPath(goDeps.getPath());
                    JsonElement commentElement = dep.get(COMMENT);
                    if (commentElement != null) {
                        String comment = commentElement.getAsString();
                        if (comment.indexOf("-") > -1) {
                            comment = comment.substring(0, comment.indexOf("-"));
                        }
                        dependencyInfo.setVersion(comment);
                    }
                    dependencyInfos.add(dependencyInfo);
                }
            }
        }
        return dependencyInfos;
    }

    private String getGroupId(String name) {
        String groupId = "";
        if (name.contains("/")) {
            String[] split = name.split("/");
            groupId = split[1];
        }
        return groupId;
    }

    private void collectVndrDependencies(String rootDirectory, List<DependencyInfo> dependencyInfos) throws Exception {
        this.logger.debug("collecting dependencies using 'vndr'");
        File vndrConf = new File(rootDirectory + fileSeparator + VNDR_CONF);
        if (!(vndrConf.isFile() || this.collectDependenciesAtRuntime && this.runCmd(rootDirectory, this.cli.getCommandParams(GoDependencyManager.VNDR.getType(), GO_INIT)))) {
            throw new Exception("Can't find vendor.conf file.  Please make sure 'vndr' is installed and run 'vndr init' command");
        }
        dependencyInfos.addAll(this.parseVendorConf(vndrConf));
    }

    private List<DependencyInfo> parseVendorConf(File vendorConf) throws IOException {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        try (InputStreamReader fileReader = null;){
            String currLine;
            fileReader = new FileReader(vendorConf);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((currLine = bufferedReader.readLine()) != null) {
                DependencyInfo dependencyInfo = new DependencyInfo();
                String[] split = currLine.split(" ");
                String name = split[0];
                dependencyInfo.setGroupId(this.getGroupId(name));
                dependencyInfo.setArtifactId(name);
                dependencyInfo.setCommit(split[1]);
                dependencyInfo.setDependencyType(DependencyType.GO);
                dependencyInfo.setSystemPath(vendorConf.getPath());
                dependencyInfos.add(dependencyInfo);
            }
        }
        return dependencyInfos;
    }

    public boolean runCmd(String rootDirectory, String[] params) {
        try {
            CommandLineProcess commandLineProcess = new CommandLineProcess(rootDirectory, params);
            commandLineProcess.executeProcessWithErrorOutput();
            if (!commandLineProcess.isErrorInProcess()) {
                return true;
            }
        }
        catch (IOException e) {
            this.logger.warn("Error getting dependencies after running {} on {}, {}", new Object[]{params, rootDirectory, e.getMessage()});
            this.logger.debug("Error: {}", (Object[])e.getStackTrace());
        }
        return false;
    }

    private void removeTempFiles(String rootDirectory, long creationTime) {
        FileTime fileCreationTime = FileTime.fromMillis(creationTime);
        File directory = new File(rootDirectory);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                try {
                    BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (fileAttributes.creationTime().compareTo(fileCreationTime) <= 0) continue;
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.error("can't remove {}: {}", (Object)file.getPath(), (Object)e.getMessage());
                }
            }
        }
    }
}

