/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.gradle.GradleCli;
import org.whitesource.agent.dependency.resolver.gradle.GradleLinesParser;
import org.whitesource.agent.dependency.resolver.gradle.MvnCommand;

public class GradleDependencyResolver
extends AbstractDependencyResolver {
    private static final String BUILD_GRADLE = "**/*build.gradle";
    private static final String BUILD_GRADLE_KOTLIN = "**/*build.gradle.kts";
    private static final List<String> GRADLE_SCRIPT_EXTENSION = Arrays.asList(".gradle", ".groovy", ".java", ".jar", ".war", ".ear", ".car", ".class");
    private static final String JAR_EXTENSION = ".jar";
    private static final String SETTINGS_GRADLE = "settings.gradle";
    protected static final String COMMENT_START = "/*";
    protected static final String COMMENT_END = "*/";
    private String[] ignoredScopes;
    private boolean allowDaemon;
    private GradleLinesParser gradleLinesParser;
    private GradleCli gradleCli;
    private ArrayList<String> topLevelFoldersNames;
    private boolean dependenciesOnly;
    private boolean gradleAggregateModules;
    private final Logger logger = LoggerFactory.getLogger(GradleDependencyResolver.class);

    public GradleDependencyResolver(boolean runAssembleCommand, boolean dependenciesOnly, boolean gradleAggregateModules, String[] gradleIgnoredScopes, boolean gradleAllowDaemon) {
        this.gradleLinesParser = new GradleLinesParser(runAssembleCommand, gradleAllowDaemon);
        this.gradleCli = new GradleCli();
        this.ignoredScopes = gradleIgnoredScopes;
        this.allowDaemon = gradleAllowDaemon;
        this.topLevelFoldersNames = new ArrayList();
        this.dependenciesOnly = dependenciesOnly;
        this.gradleAggregateModules = gradleAggregateModules;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        ArrayList<AgentProjectInfo> projects = new ArrayList<AgentProjectInfo>();
        String settingsFileContent = null;
        this.gradleCli.setTopLevelFolderGradlew(topLevelFolder);
        this.gradleLinesParser.gradleCli.setTopLevelFolderGradlew(topLevelFolder);
        ArrayList<Integer[]> commentBlocks = null;
        if (bomFiles.size() > 1) {
            settingsFileContent = this.readSettingsFile(topLevelFolder);
            settingsFileContent = settingsFileContent.replaceFirst("include", "include '" + topLevelFolder.substring(topLevelFolder.lastIndexOf(File.separator) + 1) + "', ");
            commentBlocks = this.findCommentBlocksInSettingsFile(settingsFileContent);
        }
        this.logger.debug("Got {} gradle build scripts", (Object)bomFiles.size());
        for (String bomFile : bomFiles) {
            String bomFileFolder = new File(bomFile).getParent();
            File bomFolder = new File(new File(bomFile).getParent());
            String moduleName = bomFolder.getName();
            if (settingsFileContent != null && !this.validateModule(moduleName, settingsFileContent, commentBlocks)) {
                this.logger.warn("Ignoring invalid Gradle build script: {}", (Object)bomFile);
                continue;
            }
            List<DependencyInfo> dependencies = this.collectDependencies(bomFileFolder);
            if (dependencies.size() <= 0) continue;
            AgentProjectInfo agentProjectInfo = new AgentProjectInfo();
            agentProjectInfo.getDependencies().addAll(dependencies);
            if (!this.gradleAggregateModules) {
                Coordinates coordinates = new Coordinates();
                coordinates.setArtifactId(moduleName);
                agentProjectInfo.setCoordinates(coordinates);
            }
            projects.add(agentProjectInfo);
        }
        this.topLevelFoldersNames.add(topLevelFolder.substring(topLevelFolder.lastIndexOf(fileSeparator) + 1));
        Collection<String> excludes = this.getExcludes();
        Map<AgentProjectInfo, Path> projectInfoPathMap = projects.stream().collect(Collectors.toMap(projectInfo -> projectInfo, projectInfo -> {
            if (this.dependenciesOnly) {
                excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder, GRADLE_SCRIPT_EXTENSION, null));
            }
            return Paths.get(topLevelFolder, new String[0]);
        }));
        ResolutionResult resolutionResult = !this.gradleAggregateModules ? new ResolutionResult(projectInfoPathMap, excludes, this.getDependencyType(), topLevelFolder) : new ResolutionResult(projectInfoPathMap.keySet().stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList()), excludes, this.getDependencyType(), topLevelFolder);
        return resolutionResult;
    }

    @Override
    protected Collection<String> getExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        for (String topLeverFolderName : this.topLevelFoldersNames) {
            excludes.add("**/" + topLeverFolderName + JAR_EXTENSION);
        }
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return GRADLE_SCRIPT_EXTENSION;
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.GRADLE;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.GRADLE.name();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{BUILD_GRADLE, BUILD_GRADLE_KOTLIN};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return null;
    }

    private String readSettingsFile(String folder) {
        String content = "";
        File settingsFile = new File(folder + fileSeparator + SETTINGS_GRADLE);
        if (settingsFile.isFile()) {
            try {
                content = new String(Files.readAllBytes(Paths.get(settingsFile.getPath(), new String[0])));
            }
            catch (IOException e) {
                this.logger.warn("could not read settings file {} - {}", (Object)settingsFile.getPath(), (Object)e.getMessage());
                this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
            }
        }
        return content;
    }

    private ArrayList<Integer[]> findCommentBlocksInSettingsFile(String content) {
        ArrayList<Integer[]> commentBlock = new ArrayList<Integer[]>();
        int startIndex = content.indexOf(COMMENT_START);
        while (startIndex > -1) {
            int endIndex = content.indexOf(COMMENT_END, startIndex);
            commentBlock.add(new Integer[]{startIndex, endIndex});
            startIndex = content.indexOf(COMMENT_START, endIndex);
        }
        return commentBlock;
    }

    private boolean validateModule(String moduleName, String settings, ArrayList<Integer[]> commentBlocks) {
        this.logger.debug("Validating gradle build scripts {}", (Object)moduleName);
        if (settings == null || !settings.contains(moduleName)) {
            this.logger.debug("Module doesn't exist in the settings content");
            return false;
        }
        int startIndex = settings.indexOf(moduleName);
        char proceedingChar = settings.charAt(startIndex - 1);
        if (proceedingChar != "\"".charAt(0) && proceedingChar != "'".charAt(0) && proceedingChar != ":".charAt(0)) {
            this.logger.debug("Wrong opening syntax in the settings file");
            return false;
        }
        int endIndex = startIndex + moduleName.length();
        char followingChar = settings.charAt(endIndex);
        if (followingChar != "\"".charAt(0) && followingChar != "'".charAt(0)) {
            this.logger.debug("Wrong ending syntax in the settings file");
            return false;
        }
        while (settings.charAt(startIndex) != '\n' && settings.charAt(startIndex) != '\r' && startIndex > 0) {
            if (settings.charAt(--startIndex) == '=') {
                this.logger.debug("Wrong syntax in the settings file ('=')");
                return false;
            }
            if (settings.charAt(startIndex) != "/".charAt(0) || startIndex <= 0 || settings.charAt(startIndex - 1) != "/".charAt(0)) continue;
            this.logger.debug("Wrong syntax in the settings file ('//')");
            return false;
        }
        if (commentBlocks != null) {
            for (Integer[] commentBlock : commentBlocks) {
                if (settings.indexOf(moduleName) <= commentBlock[0] || endIndex >= commentBlock[1]) continue;
                this.logger.debug("The module is commented out in the settings file");
                return false;
            }
        }
        return true;
    }

    private List<DependencyInfo> collectDependencies(String rootDirectory) {
        ArrayList<DependencyInfo> dependencyInfos = new ArrayList<DependencyInfo>();
        List<String> lines = this.gradleCli.runGradleCmd(rootDirectory, this.gradleCli.getGradleCommandParams(MvnCommand.DEPENDENCIES, this.allowDaemon));
        if (lines != null) {
            dependencyInfos.addAll(this.gradleLinesParser.parseLines(lines, rootDirectory, this.ignoredScopes));
        }
        return dependencyInfos;
    }
}

