/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.gradle.GradleCli;
import org.whitesource.agent.dependency.resolver.gradle.MvnCommand;
import org.whitesource.agent.dependency.resolver.maven.MavenTreeDependencyCollector;
import org.whitesource.agent.utils.FilesUtils;

public class GradleLinesParser
extends MavenTreeDependencyCollector {
    protected static final String ARROW = " -> ";
    private final Logger logger = LoggerFactory.getLogger(GradleLinesParser.class);
    private static final String TMP_JAVA_FILE = "tmp.java";
    private static final String MAIN = "main";
    private static final String JAVA = "java";
    private static final String JAVA_EXTENSION = ".java";
    private static final String AAR_EXTENSION = ".aar";
    private static final String PLUS = "+---";
    private static final String SLASH = "\\---";
    private static final String USER_HOME = "user.home";
    private static final int INDENTETION_SPACE = 5;
    private static final String JAR_EXTENSION = ".jar";
    private static final String ASTERIX = "(*)";
    private static final String CONSTRAINT = "(c)";
    private String fileSeparator;
    private String dotGradlePath;
    private String rootDirectory;
    private boolean runAssembleCommand;
    private boolean dependenciesDownloadAttemptPerformed;
    private boolean allowDaemon;
    public GradleCli gradleCli;
    private String javaDirPath;
    private String mainDirPath;
    private String srcDirPath;
    private boolean removeJavaDir;
    private boolean removeMainDir;
    private boolean removeSrcDir;
    private boolean removeJavaFile;

    GradleLinesParser(boolean runAssembleCommand, boolean allowDaemon) {
        super(null, true, false, false);
        this.runAssembleCommand = runAssembleCommand;
        this.allowDaemon = allowDaemon;
        this.gradleCli = new GradleCli();
        this.fileSeparator = System.getProperty("file.separator");
        this.srcDirPath = this.fileSeparator + "src";
        this.mainDirPath = this.srcDirPath + this.fileSeparator + MAIN;
        this.javaDirPath = this.mainDirPath + this.fileSeparator + JAVA;
    }

    public List<DependencyInfo> parseLines(List<String> lines, String rootDirectory, String[] ignoredScopes) {
        if (StringUtils.isBlank((String)this.dotGradlePath)) {
            this.dotGradlePath = this.getDotGradleFolderPath();
        }
        if (this.dotGradlePath == null) {
            return new ArrayList<DependencyInfo>();
        }
        this.rootDirectory = rootDirectory;
        this.logger.info("Start parsing gradle dependencies of: {}", (Object)rootDirectory);
        this.logger.debug("Ignoring scopes: {}", (Object)String.join((CharSequence)",", ignoredScopes));
        if (ignoredScopes.length != 0) {
            lines = this.ignoreScopesOfGradleDependencies(ignoredScopes, lines);
        }
        List projectsLines = lines.stream().filter(line -> (line.contains(PLUS) || line.contains(SLASH) || line.contains("|")) && !line.contains(ASTERIX) && !line.contains(CONSTRAINT)).collect(Collectors.toList());
        ArrayList<DependencyInfo> dependenciesList = new ArrayList<DependencyInfo>();
        Stack<DependencyInfo> parentDependencies = new Stack<DependencyInfo>();
        ArrayList<String> sha1s = new ArrayList<String>();
        int prevLineIndentation = 0;
        boolean duplicateDependency = false;
        for (String line2 : projectsLines) {
            String version;
            String artifactId;
            if (line2.indexOf(":") == -1 || line2.contains("project :")) continue;
            String[] strings = line2.split(":");
            String groupId = strings[0];
            int lastSpace = groupId.lastIndexOf(" ");
            groupId = groupId.substring(lastSpace + 1);
            if (strings.length == 2) {
                if (!strings[1].contains(ARROW)) continue;
                artifactId = strings[1].split(ARROW)[0];
                version = strings[1].split(ARROW)[1];
            } else {
                artifactId = strings[1];
                version = strings[2];
                if (version.contains(" ")) {
                    version = version.contains(ARROW) ? version.split(ARROW)[1] : version.split(" ")[0];
                }
            }
            DependencyInfo currentDependency = new DependencyInfo(groupId, artifactId, version);
            DependencyFile dependencyFile = this.getDependencySha1(currentDependency);
            if (dependencyFile != null && !dependencyFile.getSha1().equals("") && !sha1s.contains(dependencyFile.getSha1())) {
                sha1s.add(dependencyFile.getSha1());
                currentDependency.setSha1(dependencyFile.getSha1());
                currentDependency.setSystemPath(dependencyFile.getFilePath());
                currentDependency.setFilename(dependencyFile.getFileName());
                String extension = FilesUtils.getFileExtension(dependencyFile.getFilePath());
                currentDependency.setType(extension);
            }
            currentDependency.setDependencyType(DependencyType.GRADLE);
            if (dependenciesList.contains(currentDependency)) {
                duplicateDependency = true;
                continue;
            }
            if (line2.startsWith(" ") || line2.startsWith("|")) {
                if (duplicateDependency || parentDependencies.isEmpty()) continue;
                if (lastSpace == prevLineIndentation) {
                    parentDependencies.pop();
                } else if (lastSpace < prevLineIndentation) {
                    while (prevLineIndentation > lastSpace - 5 && !parentDependencies.isEmpty()) {
                        parentDependencies.pop();
                        prevLineIndentation -= 5;
                    }
                }
                if (!parentDependencies.isEmpty()) {
                    ((DependencyInfo)parentDependencies.peek()).getChildren().add(currentDependency);
                }
                parentDependencies.push(currentDependency);
            } else {
                duplicateDependency = false;
                dependenciesList.add(currentDependency);
                parentDependencies.clear();
                parentDependencies.push(currentDependency);
            }
            prevLineIndentation = lastSpace;
        }
        return dependenciesList;
    }

    private List<String> ignoreScopesOfGradleDependencies(String[] ignoredScopes, List<String> lines) {
        String scope = "";
        HashMap<String, String> gradleScopes = new HashMap<String, String>();
        for (String line : lines) {
            if (Character.isLetter(line.charAt(0))) {
                int indexOfWhiteSpace = line.indexOf(32);
                scope = indexOfWhiteSpace == -1 ? line : line.substring(0, indexOfWhiteSpace);
                gradleScopes.put(scope, "");
                continue;
            }
            if (!gradleScopes.containsKey(scope)) continue;
            String strConcatinator = (String)gradleScopes.get(scope);
            strConcatinator = strConcatinator + line + "\n";
            gradleScopes.put(scope, strConcatinator);
        }
        for (String ignoredScope : ignoredScopes) {
            gradleScopes.remove(ignoredScope);
        }
        return Arrays.asList(gradleScopes.values().toString().split("\n"));
    }

    private String getDotGradleFolderPath() {
        String currentUsersHomeDir = System.getProperty(USER_HOME);
        File dotGradle = Paths.get(currentUsersHomeDir, ".gradle", "caches", "modules-2", "files-2.1").toFile();
        if (dotGradle.exists()) {
            return dotGradle.getAbsolutePath();
        }
        this.logger.error("Could not get .gradle path, dependencies information will not be send to Checkmarx server.");
        return null;
    }

    private DependencyFile getDependencySha1(DependencyInfo dependencyInfo) {
        DependencyFile dependencyFile = this.getSha1FromGradleCache(dependencyInfo);
        if (dependencyFile != null) {
            return dependencyFile;
        }
        dependencyFile = this.getSha1FromM2(dependencyInfo);
        if (dependencyFile != null && !dependencyFile.getSha1().equals("")) {
            return dependencyFile;
        }
        if (!this.dependenciesDownloadAttemptPerformed && this.downloadDependencies()) {
            return this.getDependencySha1(dependencyInfo);
        }
        return dependencyFile;
    }

    private DependencyFile getSha1FromGradleCache(DependencyInfo dependencyInfo) {
        String groupId = dependencyInfo.getGroupId();
        String artifactId = dependencyInfo.getArtifactId();
        String version = dependencyInfo.getVersion();
        String fullName = groupId + "." + artifactId + "." + version;
        this.logger.debug("Looking for [{}] in .gradle cache", (Object)fullName);
        Object dependencyFile = null;
        if (this.dotGradlePath == null) {
            this.logger.warn("Couldn't find binary for {}, DotGradlePath is missing", (Object)fullName);
            return null;
        }
        String pathToDependency = this.dotGradlePath.concat(this.fileSeparator + groupId + this.fileSeparator + artifactId + this.fileSeparator + version);
        File dependencyFolder = new File(pathToDependency);
        if (!dependencyFolder.exists()) {
            this.logger.warn("Couldn't find binary for {}, [{}] does not exist", (Object)fullName, (Object)dependencyFolder);
            return null;
        }
        if (!dependencyFolder.isDirectory()) {
            this.logger.warn("Couldn't find binary for {}, [{}] is not a directory", (Object)fullName, (Object)dependencyFolder);
            return null;
        }
        for (File folder : Objects.requireNonNull(dependencyFolder.listFiles())) {
            if (!folder.isDirectory()) continue;
            for (File file : Objects.requireNonNull(folder.listFiles())) {
                if (!file.getName().contains(JAR_EXTENSION) && !file.getName().contains(AAR_EXTENSION) || file.getName().contains("-sources")) continue;
                String pattern = Pattern.quote(this.fileSeparator);
                String[] splitFileName = folder.getName().split(pattern);
                String sha1 = splitFileName[splitFileName.length - 1];
                return new DependencyFile(sha1, file);
            }
        }
        this.logger.warn("Couldn't find binary for: {}, under: {}", (Object)fullName, (Object)pathToDependency);
        return null;
    }

    private DependencyFile getSha1FromM2(DependencyInfo dependencyInfo) {
        String groupId = dependencyInfo.getGroupId();
        String artifactId = dependencyInfo.getArtifactId();
        String version = dependencyInfo.getVersion();
        DependencyFile dependencyFile = null;
        if (StringUtils.isBlank((String)this.M2Path)) {
            try {
                String curM2Path = this.getMavenM2Path(".");
                String string = this.M2Path = curM2Path != null ? curM2Path : this.getMavenM2Path("");
                if (this.M2Path == null) {
                    return null;
                }
            }
            catch (Exception ex) {
                this.logger.warn("Failed to look in .m2 cache, .m2 folder wasn't found or maven isn't installed");
                return null;
            }
        }
        this.logger.debug("Looking for [" + groupId + "." + artifactId + "." + version + "] in .m2 cache");
        String pathToDependency = this.M2Path.concat(this.fileSeparator + String.join((CharSequence)this.fileSeparator, groupId.split("\\.")) + this.fileSeparator + artifactId + this.fileSeparator + version + this.fileSeparator + artifactId + "-" + version + JAR_EXTENSION);
        File file = new File(pathToDependency);
        if (file.isFile()) {
            String sha1 = this.getSha1(pathToDependency);
            dependencyFile = new DependencyFile(sha1, file);
            if (sha1.equals("")) {
                this.logger.debug("Couldn't calculate sha1 for " + groupId + "." + artifactId + "." + version + ".  ");
            }
        } else {
            this.logger.debug("Couldn't find sha1 for " + groupId + "." + artifactId + "." + version + " inside .m2 cache.");
        }
        return dependencyFile;
    }

    private boolean downloadDependencies() {
        this.dependenciesDownloadAttemptPerformed = true;
        if (this.runAssembleCommand) {
            try {
                this.logger.info("running 'gradle assemble' command");
                this.validateJavaFileExistence();
                List<String> lines = this.gradleCli.runGradleCmd(this.rootDirectory, this.gradleCli.getGradleCommandParams(MvnCommand.ASSEMBLE, this.allowDaemon));
                this.removeTempJavaFolder();
                if (lines != null) {
                    for (String line : lines) {
                        if (!line.contains("BUILD SUCCESSFUL")) continue;
                        return true;
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed running 'gradle assemble' command, got exception: " + e.getMessage());
            }
        } else {
            this.logger.error("Can't run 'gradle assemble' to download missing dependencies.  Change 'gradle.runAssembleCommand' in the configuration file to 'true'");
        }
        this.logger.error("Failed running 'gradle assemble' command");
        return false;
    }

    private void validateJavaFileExistence() throws IOException {
        String javaDirPath = this.rootDirectory + this.javaDirPath;
        File javaDir = new File(javaDirPath);
        String srcDirPath = this.rootDirectory + this.srcDirPath;
        File srcDir = new File(srcDirPath);
        this.removeSrcDir = false;
        if (!srcDir.isDirectory()) {
            FileUtils.forceMkdir((File)javaDir);
            this.removeSrcDir = true;
        } else {
            String mainDirPath = this.rootDirectory + this.mainDirPath;
            File mainDir = new File(mainDirPath);
            this.removeMainDir = false;
            if (!mainDir.isDirectory()) {
                FileUtils.forceMkdir((File)javaDir);
                this.removeMainDir = true;
            } else {
                this.removeJavaDir = false;
                if (!javaDir.isDirectory()) {
                    FileUtils.forceMkdir((File)javaDir);
                    this.removeJavaDir = true;
                }
            }
        }
        this.removeJavaFile = false;
        if (!this.javaFileExists(this.rootDirectory + this.javaDirPath)) {
            File javaFile = new File(javaDirPath + this.fileSeparator + TMP_JAVA_FILE);
            this.removeJavaFile = javaFile.createNewFile();
        }
    }

    private boolean javaFileExists(String directoryName) {
        File directory = new File(directoryName);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(JAVA_EXTENSION)) continue;
                    return true;
                }
                if (!file.isDirectory()) continue;
                return this.javaFileExists(file.getAbsolutePath());
            }
        }
        return false;
    }

    private void removeTempJavaFolder() throws IOException {
        if (this.removeJavaDir) {
            FileUtils.forceDelete((File)new File(this.rootDirectory + this.javaDirPath));
        } else if (this.removeMainDir) {
            FileUtils.forceDelete((File)new File(this.rootDirectory + this.mainDirPath));
        } else if (this.removeSrcDir) {
            FileUtils.forceDelete((File)new File(this.rootDirectory + this.srcDirPath));
        } else if (this.removeJavaFile) {
            FileUtils.forceDelete((File)new File(this.rootDirectory + this.javaDirPath + this.fileSeparator + TMP_JAVA_FILE));
        }
    }

    private class DependencyFile {
        private String sha1;
        private String filePath;
        private String fileName;

        public DependencyFile(String sha1, File file) {
            this.sha1 = sha1;
            this.filePath = file.getPath();
            this.fileName = file.getName();
        }

        public String getSha1() {
            return this.sha1;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

