/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.js;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.js.JsLibsRegex;

public class JavascriptDependencyResolver
extends AbstractDependencyResolver {
    private final Logger log = LoggerFactory.getLogger(JavascriptDependencyResolver.class);
    public static final List<String> jsTypeExtensions = Arrays.asList("js");

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) throws FileNotFoundException {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        block2: for (String jsFile : bomFiles) {
            try {
                DependencyInfo dependencyInfo = null;
                for (JsLibsRegex jsLib : JsLibsRegex.values()) {
                    if (jsLib.getFileNameRegex() == null) continue;
                    for (String regex : jsLib.getFileNameRegex()) {
                        dependencyInfo = this.collectDependency(jsFile, jsFile, jsLib.getLibName(), regex, true);
                        if (dependencyInfo == null) continue;
                        dependencies.add(dependencyInfo);
                        break;
                    }
                    if (dependencyInfo != null) break;
                }
                if (dependencyInfo != null) continue;
                String jsStr = this.readFile(jsFile, StandardCharsets.UTF_8);
                for (JsLibsRegex jsLib : JsLibsRegex.values()) {
                    if (jsLib.getFileContentRegex() == null || (dependencyInfo = this.collectDependencyFromContent(jsStr, jsFile, jsLib.getLibName(), jsLib.getFileContentRegex())) == null) continue;
                    dependencies.add(dependencyInfo);
                    continue block2;
                }
            }
            catch (Exception e) {
                this.log.error("Fail to collect Javascript libraries.");
            }
        }
        return new ResolutionResult(dependencies, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    private DependencyInfo collectDependencyFromContent(String str, String filePath, String groupId, List<String> regexList) {
        try {
            for (String regex : regexList) {
                DependencyInfo dependencyInfo = this.collectDependency(str, filePath, groupId, regex, false);
                if (dependencyInfo == null) continue;
                return dependencyInfo;
            }
        }
        catch (Exception e) {
            this.log.trace("Fail to match library by content: " + filePath);
        }
        return null;
    }

    private DependencyInfo collectDependency(String str, String filePath, String groupId, String regex, boolean isByName) {
        try {
            String artifactId;
            DependencyInfo dependencyInfo = new DependencyInfo();
            this.log.trace("Running regex: " + regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(str);
            matcher.find();
            String version = matcher.group(1);
            String string = artifactId = isByName ? filePath.substring(filePath.lastIndexOf(File.separator) + 1) : groupId + "-" + version + ".js";
            if (StringUtils.isEmpty((CharSequence)artifactId) || StringUtils.isEmpty((CharSequence)version) || StringUtils.isNotEmpty((CharSequence)version) && !Character.isDigit(version.charAt(0))) {
                return null;
            }
            dependencyInfo.setGroupId(groupId);
            dependencyInfo.setArtifactId(artifactId);
            dependencyInfo.setFilename(artifactId);
            dependencyInfo.setVersion(version);
            dependencyInfo.setSystemPath(filePath);
            return dependencyInfo;
        }
        catch (Exception e) {
            this.log.trace("Fail to match library by regex: " + filePath);
            return null;
        }
    }

    private String readFile(String path, Charset encoding) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(encoded, encoding);
        }
        catch (IOException e) {
            this.log.error("Failed to load file: " + path, (Throwable)e);
            return null;
        }
    }

    @Override
    protected Collection<String> getExcludes() {
        return new ArrayList<String>();
    }

    @Override
    protected DependencyType getDependencyType() {
        return null;
    }

    @Override
    protected String getDependencyTypeName() {
        return "js".toUpperCase();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{"**/*.js"};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return jsTypeExtensions;
    }
}

