/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.npm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.npm.NpmBomParser;
import org.whitesource.agent.utils.CommandLineErrors;
import org.whitesource.agent.utils.CommandLineProcess;

public class NpmLsJsonDependencyCollector
extends DependencyCollector {
    private static final Logger logger = LoggerFactory.getLogger(NpmLsJsonDependencyCollector.class);
    public static final String LS_COMMAND = "ls";
    public static final String LS_PARAMETER_JSON = "--json";
    private static String NPM_COMMAND;
    private static final String RESOLVED = "resolved";
    private static final String LS_ONLY_PROD_ARGUMENT = "--only=prod";
    public static final String PEER_MISSING = "peerMissing";
    private static final String DEDUPED = "deduped";
    private static final String REQUIRED = "required";
    private static final String IGNORE_SCRIPTS = "--ignore-scripts";
    private static final String UNMET_DEPENDENCY = "+-- UNMET DEPENDENCY";
    protected final boolean includeDevDependencies;
    protected final boolean ignoreNpmLsErrors;
    private final Pattern patternOfNameOfPackageFromLine = Pattern.compile(".* (.*)@(\\^)?[0-9]+\\.[0-9]+");
    private final Pattern patternOfNameOfPackageFromLineSecondChance = Pattern.compile(".* (.*)@");
    private boolean showNpmLsError;
    protected boolean npmLsFailureStatus = false;
    protected final long npmTimeoutDependenciesCollector;
    private final boolean ignoreScripts;

    public NpmLsJsonDependencyCollector(boolean includeDevDependencies, long npmTimeoutDependenciesCollector, boolean ignoreNpmLsErrors, boolean ignoreScripts) {
        this.npmTimeoutDependenciesCollector = npmTimeoutDependenciesCollector;
        this.includeDevDependencies = includeDevDependencies;
        this.ignoreNpmLsErrors = ignoreNpmLsErrors;
        this.ignoreScripts = ignoreScripts;
    }

    @Override
    public Collection<AgentProjectInfo> collectDependencies(String rootDirectory) {
        ArrayList<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
        try {
            CommandLineProcess npmLsJson = new CommandLineProcess(rootDirectory, this.getLsCommandParamsJson());
            npmLsJson.setTimeoutReadLineSeconds(this.npmTimeoutDependenciesCollector);
            List<String> linesOfNpmLsJson = npmLsJson.executeProcess();
            this.npmLsFailureStatus = npmLsJson.isErrorInProcess() && !this.ignoreNpmLsErrors;
            StringBuilder json = new StringBuilder();
            for (String line : linesOfNpmLsJson) {
                json.append(line);
            }
            if (json != null && json.length() > 0) {
                logger.debug("'npm ls' output is not empty");
                if (npmLsJson.isErrorInProcess() && this.ignoreNpmLsErrors) {
                    logger.info("Ignore errors of 'npm ls'");
                }
                this.getDependencies(new JSONObject(json.toString()), rootDirectory, dependencies);
            }
        }
        catch (IOException e) {
            this.npmLsFailureStatus = true;
            logger.warn("Error getting dependencies after running 'npm ls --json' on {}, error : {}", (Object)rootDirectory, (Object)e.getMessage());
            logger.debug("Error: {}", (Object[])e.getStackTrace());
        }
        catch (JSONException e) {
            logger.debug("File is not an NPM package.json file type, under folder: " + rootDirectory);
        }
        if (dependencies.isEmpty()) {
            if (!this.showNpmLsError && this.npmLsFailureStatus) {
                logger.warn("Failed to getting dependencies after running '{}', run {} on {} folder", new Object[]{this.getLsCommandParams(), this.getInstallParams(), rootDirectory});
                this.showNpmLsError = true;
            }
        } else if (this.ignoreNpmLsErrors) {
            logger.debug("Ignoring 'NPM LS' failures");
            CommandLineErrors.removeFailedCmd(Arrays.toString(this.getLsCommandParamsJson()), "NPM");
            CommandLineErrors.removeFailedCmd(Arrays.toString(this.getLsCommandParams()), "NPM");
        }
        return this.getSingleProjectList(dependencies);
    }

    public boolean executePreparationStep(String folder) {
        Object[] command = this.getInstallParams();
        logger.debug("Running install command : " + Arrays.toString(command));
        CommandLineProcess npmInstall = new CommandLineProcess(folder, (String[])command);
        try {
            npmInstall.executeProcessWithoutOutput();
        }
        catch (IOException e) {
            logger.debug("Could not run " + Arrays.toString(command) + " in folder " + folder);
            return false;
        }
        return npmInstall.isErrorInProcess();
    }

    private int getDependencies(JSONObject npmLsJson, List<String> linesOfNpmLs, int currentLineNumber, Collection<DependencyInfo> dependencies) {
        JSONObject dependenciesJsonObject;
        if (npmLsJson.has("dependencies") && (dependenciesJsonObject = npmLsJson.getJSONObject("dependencies")) != null) {
            for (int i = 0; i < dependenciesJsonObject.keySet().size(); ++i) {
                String currentLine = linesOfNpmLs.get(currentLineNumber);
                if (currentLine.endsWith(DEDUPED) || currentLine.startsWith(UNMET_DEPENDENCY)) {
                    ++currentLineNumber;
                    continue;
                }
                String dependencyAlias = this.getTheNextPackageNameFromNpmLs(currentLine);
                if (dependencyAlias == null) continue;
                try {
                    JSONObject dependencyJsonObject = dependenciesJsonObject.getJSONObject(dependencyAlias);
                    DependencyInfo dependency = this.getDependency(dependencyAlias, dependencyJsonObject);
                    if (dependency != null) {
                        dependencies.add(dependency);
                        logger.debug("Collect child dependencies of {}", (Object)dependencyAlias);
                        ArrayList<DependencyInfo> childDependencies = new ArrayList<DependencyInfo>();
                        currentLineNumber = this.getDependencies(dependencyJsonObject, linesOfNpmLs, currentLineNumber + 1, childDependencies);
                        dependency.getChildren().addAll(childDependencies);
                        continue;
                    }
                    if (dependencyJsonObject.has(REQUIRED)) {
                        try {
                            Object requiredObject = dependencyJsonObject.get(REQUIRED);
                            if (requiredObject instanceof JSONObject) {
                                currentLineNumber = this.getDependencies((JSONObject)requiredObject, linesOfNpmLs, currentLineNumber + 1, new ArrayList<DependencyInfo>());
                                continue;
                            }
                            ++currentLineNumber;
                        }
                        catch (Exception e) {
                            logger.warn("Fail to create Json object");
                            ++currentLineNumber;
                        }
                        continue;
                    }
                    ++currentLineNumber;
                    continue;
                }
                catch (JSONException e) {
                    if (this.ignoreNpmLsErrors) {
                        logger.warn(e.getMessage());
                        logger.debug("Fail to parse JSONObject", (Throwable)e);
                        ++currentLineNumber;
                        continue;
                    }
                    throw e;
                }
            }
        }
        return currentLineNumber;
    }

    private static String getNpmCommand() {
        String npmPath = System.getenv("CX_NPM_PATH");
        String string = npmPath = StringUtils.isNotEmpty((CharSequence)npmPath) ? npmPath : System.getProperty("CX_NPM_PATH");
        if (StringUtils.isNotEmpty((CharSequence)npmPath)) {
            npmPath = npmPath.endsWith(File.separator) ? npmPath : npmPath + File.separator;
            NPM_COMMAND = npmPath + (NpmLsJsonDependencyCollector.isWindows() ? "npm.cmd" : "npm");
        } else {
            NPM_COMMAND = NpmLsJsonDependencyCollector.isWindows() ? "npm.cmd" : "npm";
        }
        return NPM_COMMAND;
    }

    private String getNpmInstallOptions() {
        String npmInstallOpt = System.getenv("CX_NPM_INSTALL_OPT");
        return StringUtils.isNotEmpty((CharSequence)npmInstallOpt) ? npmInstallOpt : System.getProperty("CX_NPM_INSTALL_OPT");
    }

    private String getNpmLsOptions() {
        String npmLsOpt = System.getenv("CX_NPM_LS_OPT");
        return StringUtils.isNotEmpty((CharSequence)npmLsOpt) ? npmLsOpt : System.getProperty("CX_NPM_LS_OPT");
    }

    private String getTheNextPackageNameFromNpmLs(String line) {
        String result;
        Matcher matcher = this.patternOfNameOfPackageFromLine.matcher(line);
        matcher.find();
        try {
            result = matcher.group(1);
        }
        catch (IllegalStateException e) {
            return null;
        }
        if (result == null) {
            matcher = this.patternOfNameOfPackageFromLineSecondChance.matcher(line);
            result = matcher.group(1);
        }
        return result;
    }

    private String getVersionFromLink(String linkResolved) {
        URI uri = null;
        try {
            uri = new URI(linkResolved);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String path = uri.getPath();
        String idStr = path.substring(path.lastIndexOf(47) + 1);
        int lastIndexOfDash = idStr.lastIndexOf("-");
        int lastIndexOfDot = idStr.lastIndexOf(".");
        String resultVersion = idStr.substring(lastIndexOfDash + 1, lastIndexOfDot);
        return resultVersion;
    }

    protected void getDependencies(JSONObject jsonObject, String rootDirectory, Collection<DependencyInfo> dependencies) {
        try {
            CommandLineProcess npmLs = new CommandLineProcess(rootDirectory, this.getLsCommandParams());
            npmLs.setTimeoutReadLineSeconds(this.npmTimeoutDependenciesCollector);
            List<String> linesOfNpmLs = npmLs.executeProcess();
            this.getDependencies(jsonObject, linesOfNpmLs, 1, dependencies);
        }
        catch (IOException e) {
            logger.warn("Error getting dependencies after running 'npm ls --json' on {}, error : {}", (Object)rootDirectory, (Object)e.getMessage());
            logger.debug("Error: {}", (Object[])e.getStackTrace());
        }
    }

    protected String[] getInstallParams() {
        String npmInsOpt = this.getNpmInstallOptions();
        if (StringUtils.isNotEmpty((CharSequence)npmInsOpt)) {
            if (this.ignoreScripts) {
                return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), "install", IGNORE_SCRIPTS, npmInsOpt};
            }
            return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), "install", npmInsOpt};
        }
        if (this.ignoreScripts) {
            return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), "install", IGNORE_SCRIPTS};
        }
        return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), "install"};
    }

    protected String[] getLsCommandParams() {
        String npmLsOpt = this.getNpmLsOptions();
        if (StringUtils.isNotEmpty((CharSequence)npmLsOpt)) {
            if (this.includeDevDependencies) {
                return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, npmLsOpt};
            }
            return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, LS_ONLY_PROD_ARGUMENT, npmLsOpt};
        }
        if (this.includeDevDependencies) {
            return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND};
        }
        return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, LS_ONLY_PROD_ARGUMENT};
    }

    protected String[] getLsCommandParamsJson() {
        String npmLsOpt = this.getNpmLsOptions();
        if (StringUtils.isNotEmpty((CharSequence)npmLsOpt)) {
            if (this.includeDevDependencies) {
                return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, LS_PARAMETER_JSON, npmLsOpt};
            }
            return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, LS_ONLY_PROD_ARGUMENT, LS_PARAMETER_JSON, npmLsOpt};
        }
        if (this.includeDevDependencies) {
            return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, LS_PARAMETER_JSON};
        }
        return new String[]{NpmLsJsonDependencyCollector.getNpmCommand(), LS_COMMAND, LS_ONLY_PROD_ARGUMENT, LS_PARAMETER_JSON};
    }

    protected DependencyInfo getDependency(String dependencyAlias, JSONObject jsonObject) {
        String version;
        String name = dependencyAlias;
        if (jsonObject.has("version")) {
            version = jsonObject.getString("version");
        } else if (jsonObject.has(RESOLVED)) {
            version = this.getVersionFromLink(jsonObject.getString(RESOLVED));
        } else {
            if (jsonObject.has("missing") && jsonObject.getBoolean("missing")) {
                logger.warn("Unmet dependency --> {}", (Object)name);
                return null;
            }
            if (jsonObject.has(PEER_MISSING) && jsonObject.getBoolean(PEER_MISSING)) {
                logger.warn("Unmet dependency --> peer missing {}", (Object)name);
                return null;
            }
            logger.warn("Unknown error. 'version' tag could not be found for {}", (Object)name);
            return null;
        }
        String filename = NpmBomParser.getNpmArtifactId(name, version);
        DependencyInfo dependency = new DependencyInfo();
        dependency.setGroupId(name);
        dependency.setArtifactId(filename);
        dependency.setVersion(version);
        dependency.setFilename(filename);
        dependency.setDependencyType(DependencyType.NPM);
        return dependency;
    }

    public boolean getNpmLsFailureStatus() {
        return this.npmLsFailureStatus;
    }

    class ReadLineTask
    implements Callable<String> {
        private final BufferedReader reader;

        ReadLineTask(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public String call() throws Exception {
            return this.reader.readLine();
        }
    }
}

