/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.nuget;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetConfigFileType;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetPackagesConfigXmlParser;
import org.whitesource.agent.utils.CommandLineProcess;
import org.whitesource.agent.utils.FilesScanner;

public class NugetDependencyResolver
extends AbstractDependencyResolver {
    private final Logger logger = LoggerFactory.getLogger(NugetDependencyResolver.class);
    public static final String CONFIG = ".config";
    public static final String CSPROJ = ".csproj";
    private final String whitesourceConfiguration;
    private final String bomPattern;
    private final NugetConfigFileType nugetConfigFileType;
    private boolean nugetRestoreDependencies;

    public NugetDependencyResolver(String whitesourceConfiguration, NugetConfigFileType nugetConfigFileType, boolean nugetRestoreDependencies) {
        this.nugetRestoreDependencies = nugetRestoreDependencies;
        this.whitesourceConfiguration = whitesourceConfiguration;
        this.nugetConfigFileType = nugetConfigFileType;
        this.bomPattern = this.nugetConfigFileType == NugetConfigFileType.CONFIG_FILE_TYPE ? "**/*.config" : "**/*.csproj";
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> configFiles) {
        if (StringUtils.isNotEmpty((CharSequence)this.getNugetExePath())) {
            this.executeNugetRestore(projectFolder);
        }
        return this.getResolutionResultFromParsing(topLevelFolder, configFiles, false);
    }

    protected ResolutionResult getResolutionResultFromParsing(String topLevelFolder, Set<String> configFiles, boolean onlyDependenciesFromReferenceTag) {
        Collection<DependencyInfo> dependencies = this.parseNugetPackageFiles(configFiles, onlyDependenciesFromReferenceTag);
        return new ResolutionResult(dependencies, new LinkedList<String>(), this.getDependencyType(), topLevelFolder);
    }

    protected void executeNugetRestore(String projectFolder) {
        List<String> slnFiles = this.getSlnFiles(projectFolder);
        this.logger.info("Nuget .sln files: " + ArrayUtils.toString(slnFiles));
        if (slnFiles != null && slnFiles.size() > 0) {
            this.executeNugetRestore(projectFolder, this.getNugetExePath(), slnFiles, this.getNugetOptions());
        } else {
            this.logger.warn("No '.sln' files were found under: " + projectFolder);
        }
    }

    @Override
    protected Collection<String> getExcludes() {
        LinkedList<String> excludes = new LinkedList<String>();
        excludes.add("whitesource-fs-agent.config");
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return new ArrayList<String>(Arrays.asList(".dll", ".exe", ".nupkg", ".cs"));
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.NUGET;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.NUGET.name();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{this.bomPattern};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }

    protected Collection<DependencyInfo> parseNugetPackageFiles(Set<String> configFilesPath, boolean getDependenciesFromReferenceTag) {
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        for (String configFilePath : configFilesPath) {
            NugetPackagesConfigXmlParser parser;
            Set<DependencyInfo> dependenciesFromSingleFile;
            File configFile;
            if (this.whitesourceConfiguration != null && new File(this.whitesourceConfiguration).getAbsolutePath().equals(configFilePath) || (configFile = new File(configFilePath)).getName().equals("whitesource-fs-agent.config") || (dependenciesFromSingleFile = (parser = new NugetPackagesConfigXmlParser(configFile, this.nugetConfigFileType)).parsePackagesConfigFile(getDependenciesFromReferenceTag, configFilePath)).isEmpty()) continue;
            dependencies.addAll(dependenciesFromSingleFile);
        }
        return dependencies;
    }

    public void executeNugetRestore(String folder, String nugetExe, List<String> slnFiles, String nugetOpt) {
        for (String slnFile : slnFiles) {
            String slnFilePath = this.buildPath(folder, slnFile);
            CharSequence[] command = NugetDependencyResolver.getRestoreParams(nugetExe, slnFilePath, nugetOpt);
            String commandString = String.join((CharSequence)" ", command);
            this.logger.info("Running command : '{}'", (Object)commandString);
            CommandLineProcess NugetRestore = new CommandLineProcess(this.getNugetRunningDir(folder), (String[])command);
            try {
                NugetRestore.executeProcess();
            }
            catch (IOException e) {
                this.logger.error("Could not run '{}' in folder: {}", (Object)commandString, (Object)folder);
            }
            if (!NugetRestore.isErrorInProcess()) {
                this.logger.info("Successfully finished to run '{}'", (Object)commandString);
                continue;
            }
            this.logger.warn("Could not run '{}' in folder: {}", (Object)commandString, (Object)folder);
        }
    }

    private String buildPath(String basePath, String filePath) {
        try {
            basePath = basePath.replaceAll("/[\\\\|\\/]/", File.separator);
            filePath = filePath.replaceAll("/[\\\\|\\/]/", File.separator);
            File file = new File(filePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            filePath = filePath.startsWith(File.separator) ? filePath : File.separator + filePath;
            filePath = basePath + filePath;
            file = new File(filePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            this.logger.error("Fail to build path for solution file: {}, in folder: {}", (Object)filePath, (Object)basePath);
            return null;
        }
        catch (Exception e) {
            this.logger.error("Fail to build path due to exception for solution file: {}, in folder: {}", (Object)filePath, (Object)basePath);
            return null;
        }
    }

    protected static String[] getRestoreParams(String nugetExe, String slnFile, String nugetOpt) {
        Object[] cmd = new String[]{nugetExe, "restore", slnFile, nugetOpt};
        return (String[])ArrayUtils.removeElements((Object[])cmd, (Object[])new String[]{null, null, null});
    }

    protected String getNugetExePath() {
        String nugetPath = StringUtils.isNotEmpty((CharSequence)System.getenv("CX_NUGET_PATH")) ? System.getenv("CX_NUGET_PATH") : System.getProperty("CX_NUGET_PATH");
        return StringUtils.isNotEmpty((CharSequence)nugetPath) ? nugetPath.trim() : null;
    }

    protected String getNugetRunningDir(String dir) {
        String runDir;
        String string = runDir = StringUtils.isNotEmpty((CharSequence)System.getenv("CX_NUGET_RUN_DIR")) ? System.getenv("CX_NUGET_RUN_DIR") : System.getProperty("CX_NUGET_RUN_DIR");
        if (StringUtils.isEmpty((CharSequence)runDir)) {
            return dir;
        }
        return (runDir = runDir.trim()).startsWith(File.separator) ? dir + runDir : dir + File.separator + runDir;
    }

    protected List<String> getSlnFiles(String projectFolder) {
        String slnFilesPath = System.getenv("CX_NUGET_SLN_FILES");
        slnFilesPath = StringUtils.isNotEmpty((CharSequence)slnFilesPath) ? slnFilesPath : System.getProperty("CX_NUGET_SLN_FILES");
        if (StringUtils.isNotEmpty((CharSequence)(slnFilesPath = slnFilesPath.trim()))) {
            return Arrays.stream(slnFilesPath.split(",")).map(String::trim).map(str -> {
                str = projectFolder + File.separator + str;
                return str;
            }).collect(Collectors.toList());
        }
        return Arrays.stream(new FilesScanner().getDirectoryContent(projectFolder, new String[]{"**/*.sln"}, null, false, false)).map(str -> {
            str = projectFolder + File.separator + str;
            return str;
        }).collect(Collectors.toList());
    }

    protected String getNugetOptions() {
        String nugetOpt = StringUtils.isNotEmpty((CharSequence)System.getenv("CX_NUGET_OPTIONS")) ? System.getenv("CX_NUGET_OPTIONS") : System.getProperty("CX_NUGET_OPTIONS");
        return StringUtils.isNotEmpty((CharSequence)nugetOpt) ? nugetOpt.trim() : null;
    }
}

