/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.paket;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.paket.AbstractPaketDependencyCollector;
import org.whitesource.agent.dependency.resolver.paket.GroupPaketDependencyCollector;
import org.whitesource.agent.dependency.resolver.paket.MainGroupPaketDependencyCollector;
import org.whitesource.agent.utils.CommandLineProcess;

public class PaketDependencyResolver
extends AbstractDependencyResolver {
    private static final String PAKET_DEPENDENCIES = "paket.dependencies";
    private static final String GROUP = "group";
    private static final String NUGET = "nuget";
    private static final String MAIN = "Main";
    private static final String PAKET_EXE = "paket.exe";
    private static final String PAKET = "paket";
    private final String PAKET_LOCK = "paket.lock";
    private final Logger logger = LoggerFactory.getLogger(PaketDependencyResolver.class);
    private final boolean paketIgnoreFiles;
    private final boolean paketRunPreStep;
    private String[] paketIgnoredGroups;
    private String paketPath;

    public PaketDependencyResolver(String[] paketIgnoredGroups, boolean paketIgnoreFiles, boolean paketRunPreStep, String paketPath) {
        this.changePaketIgnoredScopesToLowerCase(paketIgnoredGroups);
        this.paketIgnoredGroups = paketIgnoredGroups;
        this.paketIgnoreFiles = paketIgnoreFiles;
        this.paketRunPreStep = paketRunPreStep;
        this.paketPath = paketPath;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> paketDependenciesFiles) {
        boolean installSuccess = true;
        ArrayList<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
        LinkedList<String> excludes = new LinkedList<String>();
        if (this.paketRunPreStep) {
            File paket = new File(topLevelFolder + "/" + PAKET_EXE);
            if (StringUtils.isNotEmpty((String)this.paketPath)) {
                paket = new File(this.paketPath);
            } else if (!paket.exists()) {
                paket = null;
            }
            boolean bl = installSuccess = !this.executePreparationStep(topLevelFolder, paket);
        }
        if (installSuccess) {
            String paketLockPath = topLevelFolder + "/" + "paket.lock";
            File paketLockFile = new File(paketLockPath);
            if (paketLockFile.exists()) {
                this.logger.debug("Found paket.lock file: {}", (Object)paketLockPath);
                Map<String, List<String>> groupToDirectDependenciesMap = this.getGroupToDirectDependencies(paketDependenciesFiles.iterator().next());
                if (groupToDirectDependenciesMap != null && !groupToDirectDependenciesMap.keySet().isEmpty()) {
                    LinkedList<AbstractPaketDependencyCollector> paketDependencyCollectors = new LinkedList<AbstractPaketDependencyCollector>();
                    for (String groupName : groupToDirectDependenciesMap.keySet()) {
                        if (groupName.equals(MAIN)) {
                            paketDependencyCollectors.add(new MainGroupPaketDependencyCollector(groupToDirectDependenciesMap.get(MAIN), this.paketIgnoredGroups));
                            continue;
                        }
                        paketDependencyCollectors.add(new GroupPaketDependencyCollector(groupToDirectDependenciesMap.get(groupName), this.paketIgnoredGroups, groupName));
                    }
                    this.logger.info("Start collecting paket dependencies");
                    paketDependencyCollectors.forEach(paketDependencyCollector -> {
                        Collection<AgentProjectInfo> prjectInfo = paketDependencyCollector.collectDependencies(topLevelFolder);
                        dependencies.addAll(prjectInfo.iterator().next().getDependencies());
                    });
                }
                if (!dependencies.isEmpty()) {
                    if (this.paketIgnoreFiles) {
                        excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder, Arrays.asList("**/*.nupkg", "**/*.dll", "**/*.exe", "**/*.cs", "**/*.js"), null));
                    } else {
                        excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder, Arrays.asList("**/*.nupkg", "**/*.dll", "**/*.exe", "**/*.cs", "**/*.js"), "packages"));
                    }
                }
            } else {
                this.logger.warn("Could not find paket.lock file in {}. Please execute 'paket install' first.", (Object)topLevelFolder);
            }
        } else {
            this.logger.warn("'paket install' command failed");
        }
        return new ResolutionResult(dependencies, excludes, this.getDependencyType(), topLevelFolder);
    }

    private boolean executePreparationStep(String folder, File paket) {
        CharSequence[] command = paket == null ? this.getInstallParams(PAKET) : this.getInstallParams(paket.getAbsolutePath());
        String commandString = String.join((CharSequence)" ", command);
        this.logger.debug("Running install command : " + commandString);
        CommandLineProcess npmInstall = new CommandLineProcess(folder, (String[])command);
        try {
            npmInstall.executeProcessWithoutOutput();
        }
        catch (IOException e) {
            this.logger.debug("Could not run " + commandString + " in folder " + folder);
            return true;
        }
        return npmInstall.isErrorInProcess();
    }

    private String[] getInstallParams(String firstParameter) {
        return new String[]{firstParameter, "install"};
    }

    @Override
    protected Collection<String> getExcludes() {
        return new ArrayList<String>();
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return new ArrayList<String>(Arrays.asList(".dll", ".exe", ".nupkg", ".cs"));
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.NUGET;
    }

    @Override
    protected String getDependencyTypeName() {
        return DependencyType.NUGET.name();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{"**/*paket.dependencies"};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }

    private Map<String, List<String>> getGroupToDirectDependencies(String paketDependenciesPath) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(paketDependenciesPath));){
            String line;
            String groupName = MAIN;
            LinkedList<String> groupDependencies = new LinkedList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                String processedLine = line.toLowerCase().trim();
                if (processedLine.startsWith(NUGET)) {
                    String nugetDependencyName = line.substring(NUGET.length() + 1).trim();
                    int indexOfSpace = nugetDependencyName.indexOf(" ");
                    if (indexOfSpace < 0) {
                        indexOfSpace = nugetDependencyName.length();
                    }
                    groupDependencies.add(nugetDependencyName.substring(0, indexOfSpace));
                }
                if (!processedLine.startsWith(GROUP)) continue;
                if (!groupDependencies.isEmpty()) {
                    result.put(groupName, groupDependencies);
                }
                groupName = line.substring(GROUP.length() + 1);
                groupDependencies = new LinkedList();
            }
            if (!groupDependencies.isEmpty()) {
                result.put(groupName, groupDependencies);
            }
        }
        catch (IOException e) {
            this.logger.warn("Could not find paket.dependencies file in {}.", (Object)paketDependenciesPath);
        }
        return result;
    }

    private void changePaketIgnoredScopesToLowerCase(String[] paketIgnoredScopes) {
        if (paketIgnoredScopes != null) {
            for (int i = 0; i < paketIgnoredScopes.length; ++i) {
                paketIgnoredScopes[i] = paketIgnoredScopes[i].toLowerCase();
            }
        }
    }
}

