/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.sbt;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.sbt.Caller;
import org.whitesource.agent.dependency.resolver.sbt.IvyReport;
import org.whitesource.agent.dependency.resolver.sbt.Module;
import org.whitesource.agent.dependency.resolver.sbt.Revision;
import org.whitesource.agent.dependency.resolver.sbt.SbtBomParser;
import org.whitesource.agent.hash.ChecksumUtils;
import org.whitesource.agent.utils.Cli;
import org.whitesource.agent.utils.FilesScanner;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.agent.utils.JaxbUtil;

public class SbtDependencyResolver
extends AbstractDependencyResolver {
    public static final String BUILD_SBT = "build.sbt";
    private static final String SCALA = "scala";
    private static final String SBT = "sbt";
    private static final String SCALA_EXTENSION = ".scala";
    private static final List<String> SCALA_SCRIPT_EXTENSION = Arrays.asList(".scala", ".sbt");
    private static final String COMPILE = "compile";
    private static final String TARGET = "target";
    private static final String RESOLUTION_CACHE = "resolution-cache";
    private static final String REPORTS = "reports";
    private static final String SUCCESS = "success";
    private static final String PROJECT = "project";
    private static final String COMPILE_XML = "-compile.xml";
    private static final String SBT_TARGET_FOLDER = "sbt.targetFolder";
    private static final Pattern linuxPattern = Pattern.compile("\\/.*\\/target");
    private static final String windowsPattern = ".*\\s";
    private boolean sbtAggregateModules;
    private boolean dependenciesOnly;
    private boolean sbtRunPreStep;
    private String sbtTargetFolder;
    private String[] includes = new String[]{"**" + fileSeparator + "target" + fileSeparator + "**" + fileSeparator + "" + "resolution-cache" + fileSeparator + "reports" + fileSeparator + "*" + "-compile.xml"};
    private String[] excludes = new String[]{"**" + fileSeparator + "project" + fileSeparator + "**"};
    private final Logger logger = LoggerFactory.getLogger(SbtDependencyResolver.class);

    public SbtDependencyResolver(boolean sbtAggregateModules, boolean dependenciesOnly, boolean sbtRunPreStep, String sbtTargetFolder) {
        this.sbtAggregateModules = sbtAggregateModules;
        this.dependenciesOnly = dependenciesOnly;
        this.bomParser = new SbtBomParser();
        this.sbtRunPreStep = sbtRunPreStep;
        this.sbtTargetFolder = sbtTargetFolder;
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        Map<File, List<File>> mapBomFiles = bomFiles.stream().map(file -> new File((String)file)).collect(Collectors.groupingBy(File::getParentFile));
        ArrayList<AgentProjectInfo> projects = new ArrayList<AgentProjectInfo>();
        List<File> xmlFiles = new LinkedList<File>();
        if (this.sbtRunPreStep) {
            for (File bomFolder : mapBomFiles.keySet()) {
                String compilePath = bomFolder.getAbsolutePath();
                this.logger.info("Running sbt compile for: " + compilePath);
                this.runPreStep(compilePath);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.sbtTargetFolder) && bomFiles.size() > 1) {
            Path path = Paths.get(this.sbtTargetFolder, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                xmlFiles = this.findXmlReport(this.sbtTargetFolder, xmlFiles, new String[]{"**/*-compile.xml"}, this.excludes);
            } else {
                this.logger.warn("The target folder path {} doesn't exist", (Object)this.sbtTargetFolder);
            }
        } else {
            for (File bomFolder : mapBomFiles.keySet()) {
                String sbtModulePath = bomFolder.getAbsolutePath();
                Collection<String> targetFolders = this.findTargetFolders(sbtModulePath);
                if (!targetFolders.isEmpty()) {
                    for (String targetPath : targetFolders) {
                        xmlFiles = this.findXmlReport(targetPath, xmlFiles, new String[]{"**/*-compile.xml"}, this.excludes);
                    }
                    continue;
                }
                this.logger.debug("Didn't find any target folder in {}", (Object)sbtModulePath);
            }
        }
        if (xmlFiles.isEmpty() && !this.sbtRunPreStep) {
            this.logger.warn("Didn't find compile.xml please try to turn on the flag {}", (Object)SBT_TARGET_FOLDER);
        }
        for (File xmlFile : xmlFiles) {
            AgentProjectInfo sbtPrjInfo = this.parseXmlReport(xmlFile);
            ArrayList<Object> curDepList = this.removeDuplicates(sbtPrjInfo.getDependencies());
            if (!projects.isEmpty()) {
                ArrayList<DependencyInfo> tempDependencies = new ArrayList<DependencyInfo>();
                for (AgentProjectInfo prj : projects) {
                    Collection depCol = prj.getDependencies();
                    for (DependencyInfo dependency : depCol) {
                        if (curDepList.contains(dependency)) continue;
                        tempDependencies.add(dependency);
                    }
                }
                curDepList = tempDependencies;
            }
            if (curDepList.isEmpty()) continue;
            sbtPrjInfo.setDependencies(curDepList);
            projects.add(sbtPrjInfo);
        }
        HashSet<String> excludes = new HashSet<String>();
        Map<AgentProjectInfo, Path> projectInfoPathMap = projects.stream().collect(Collectors.toMap(projectInfo -> projectInfo, projectInfo -> {
            if (this.dependenciesOnly) {
                excludes.addAll(this.normalizeLocalPath(projectFolder, topLevelFolder.toString(), SCALA_SCRIPT_EXTENSION, null));
            }
            return Paths.get(topLevelFolder, new String[0]);
        }));
        ResolutionResult resolutionResult = !this.sbtAggregateModules ? new ResolutionResult(projectInfoPathMap, excludes, this.getDependencyType(), topLevelFolder) : new ResolutionResult(projectInfoPathMap.keySet().stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList()), excludes, this.getDependencyType(), topLevelFolder);
        return resolutionResult;
    }

    private ArrayList<DependencyInfo> removeDuplicates(Collection<DependencyInfo> dependencies) {
        ArrayList<DependencyInfo> tempDependencies = new ArrayList<DependencyInfo>();
        for (DependencyInfo dependency : dependencies) {
            if (tempDependencies.contains(dependency)) continue;
            tempDependencies.add(dependency);
        }
        return tempDependencies;
    }

    @Override
    protected Collection<String> getExcludes() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("**/*.scala");
        excludes.add("**" + fileSeparator + PROJECT + fileSeparator + "**");
        return excludes;
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return SCALA_SCRIPT_EXTENSION;
    }

    @Override
    protected DependencyType getDependencyType() {
        return DependencyType.MAVEN;
    }

    @Override
    protected String getDependencyTypeName() {
        return SBT.toUpperCase();
    }

    @Override
    protected String[] getBomPattern() {
        return new String[]{"**" + fileSeparator + BUILD_SBT};
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return null;
    }

    private List<File> findXmlReport(String folderPath, List<File> files, String[] includes, String[] excludes) {
        String[] directoryContent;
        FilesScanner filesScanner = new FilesScanner();
        this.logger.debug("Trying to find *-compile.xml file under target folder in {}", (Object)folderPath);
        for (String filePath : directoryContent = filesScanner.getDirectoryContent(folderPath, includes, excludes, false, false)) {
            boolean add = true;
            File reportFile = new File(folderPath + fileSeparator + filePath);
            for (File file : files) {
                if (!file.getParent().equals(reportFile.getParent())) continue;
                add = false;
                if (reportFile.getName().length() >= file.getName().length()) continue;
                files.remove(file);
                files.add(reportFile);
                break;
            }
            if (!add) continue;
            files.add(reportFile);
        }
        return files;
    }

    private void runPreStep(String folderPath) {
        Cli cli = new Cli();
        boolean success = false;
        List<String> compileOutput = cli.runCmd(folderPath, cli.getCommandParams(SBT, COMPILE));
        if (compileOutput != null && compileOutput.get(compileOutput.size() - 1).contains(SUCCESS)) {
            success = true;
        }
        if (!success) {
            this.logger.warn("Can't run '{} {}'", (Object)SBT, (Object)COMPILE);
        }
    }

    private Collection<String> findTargetFolders(String folderPath) {
        Cli cli = new Cli();
        LinkedList<String> targetFolders = new LinkedList<String>();
        List<String> lines = cli.runCmd(folderPath, cli.getCommandParams(SBT, TARGET));
        if (lines != null && !lines.isEmpty()) {
            for (String line : lines) {
                Matcher matcher;
                if (DependencyCollector.isWindows()) {
                    if (!line.endsWith(TARGET) || !line.contains(fileSeparator)) continue;
                    String[] split = line.split(windowsPattern);
                    targetFolders.add(split[1]);
                    continue;
                }
                if (!line.contains(TARGET) || !line.contains(fileSeparator) || !(matcher = linuxPattern.matcher(line)).find()) continue;
                targetFolders.add(matcher.group(0));
            }
            for (int i = 0; i < targetFolders.size(); ++i) {
                String targetFolder = (String)targetFolders.get(i);
                Path path = Paths.get(targetFolder, new String[0]);
                if (Files.exists(path, new LinkOption[0])) continue;
                targetFolders.remove(targetFolder);
                this.logger.warn("The target folder {} path doesn't exist", (Object)this.sbtTargetFolder);
            }
        }
        return targetFolders;
    }

    private AgentProjectInfo parseXmlReport(File xmlReportFile) {
        AgentProjectInfo agentProjectInfo = new AgentProjectInfo();
        HashMap<String, DependencyInfo> parentsMap = new HashMap<String, DependencyInfo>();
        HashMap childrenMap = new HashMap();
        try {
            IvyReport ivyReport = JaxbUtil.readFromPath(xmlReportFile, IvyReport.class);
            String projectGroupId = ivyReport.getInfo().getGroupId();
            String projectArtifactId = ivyReport.getInfo().getArtifactId();
            String projectVersion = ivyReport.getInfo().getVersion();
            agentProjectInfo.setCoordinates(new Coordinates(projectGroupId, projectArtifactId, projectVersion));
            for (Module dependency : ivyReport.getDependencies()) {
                String groupId = dependency.getGroupId();
                String artifactId = dependency.getArtifactId();
                for (Revision revision : dependency.getRevisions()) {
                    if (revision.isIgnored()) continue;
                    String version = revision.getVersion();
                    if (revision.getArtifacts().size() > 0 && revision.getArtifacts().get(0) != null) {
                        File jarFile = new File(revision.getArtifacts().get(0).getPathToJar());
                        if (jarFile.isFile()) {
                            String sha1 = ChecksumUtils.calculateSHA1((File)jarFile);
                            if (sha1 != null) {
                                DependencyInfo dependencyInfo = new DependencyInfo(groupId, artifactId, version);
                                dependencyInfo.setSha1(sha1);
                                dependencyInfo.setDependencyType(DependencyType.MAVEN);
                                dependencyInfo.setFilename(jarFile.getName());
                                dependencyInfo.setSystemPath(jarFile.getPath());
                                String extension = FilesUtils.getFileExtension(jarFile.getName());
                                dependencyInfo.setType(extension);
                                String dependencyName = groupId + ":" + artifactId + ":" + version;
                                parentsMap.put(dependencyName, dependencyInfo);
                                for (Caller parent : revision.getParentsList()) {
                                    String parentGroupId = parent.getGroupId();
                                    String parentArtifactId = parent.getArtifactId();
                                    if (!parentGroupId.equals(projectGroupId) && !parentArtifactId.equals(projectArtifactId)) {
                                        String parentVersion = parent.getVersion();
                                        String parentName = parentGroupId + ":" + parentArtifactId + ":" + parentVersion;
                                        DependencyInfo parentDependencyInfo = (DependencyInfo)parentsMap.get(parentName);
                                        if (parentDependencyInfo != null) {
                                            parentDependencyInfo.getChildren().add(dependencyInfo);
                                            continue;
                                        }
                                        if (childrenMap.get(dependencyName) == null) {
                                            childrenMap.put(dependencyName, new ArrayList());
                                        }
                                        ((List)childrenMap.get(dependencyName)).add(parentName);
                                        continue;
                                    }
                                    agentProjectInfo.getDependencies().add(dependencyInfo);
                                }
                                continue;
                            }
                            this.logger.warn("Could not find SHA1 for {}-{}-{}", new Object[]{groupId, revision.getArtifacts().get(0), version});
                            continue;
                        }
                        this.logger.warn("Could not find jar file {}", (Object)jarFile.getPath());
                        continue;
                    }
                    this.logger.warn("Could not find artifact ID for {}-{}", (Object)groupId, (Object)version);
                }
            }
            for (String child : childrenMap.keySet()) {
                List parents = (List)childrenMap.get(child);
                for (String parent : parents) {
                    if (this.isDescendant((DependencyInfo)parentsMap.get(child), (DependencyInfo)parentsMap.get(parent))) continue;
                    ((DependencyInfo)parentsMap.get(parent)).getChildren().add((DependencyInfo)parentsMap.get(child));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not read {}: {}", (Object)xmlReportFile.getPath(), (Object)e.getMessage());
            this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
        }
        return agentProjectInfo;
    }

    private boolean isDescendant(DependencyInfo ancestor, DependencyInfo descendant) {
        Iterator iterator = ancestor.getChildren().iterator();
        if (iterator.hasNext()) {
            DependencyInfo child = (DependencyInfo)iterator.next();
            if (child.equals((Object)descendant)) {
                return true;
            }
            return this.isDescendant(child, descendant);
        }
        return false;
    }
}

