/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.dependency.resolver.DependencyCollector;
import org.whitesource.agent.utils.CommandLineProcess;

public class Cli {
    private final Logger logger = LoggerFactory.getLogger(Cli.class);

    public List<String> runCmd(String rootDirectory, String[] params) {
        try {
            CommandLineProcess commandLineProcess = new CommandLineProcess(rootDirectory, params);
            List<String> lines = commandLineProcess.executeProcess();
            if (!commandLineProcess.isErrorInProcess()) {
                return lines;
            }
        }
        catch (IOException e) {
            this.logger.warn("Error getting dependencies after running {} on {}, {}", new Object[]{params, rootDirectory, e.getMessage()});
            this.logger.debug("Error: {}", (Object[])e.getStackTrace());
        }
        return null;
    }

    public String[] getCommandParams(String command, String param) {
        if (DependencyCollector.isWindows()) {
            return new String[]{"cmd", "/c", command, param};
        }
        return new String[]{command, param};
    }

    public String[] getCommandParams(String command, String ... params) {
        ArrayList commandParams = new ArrayList();
        if (DependencyCollector.isWindows()) {
            Collections.addAll(commandParams, "cmd", "/c", command);
        } else {
            Collections.addAll(commandParams, command);
        }
        Collections.addAll(commandParams, params);
        return commandParams.toArray(new String[0]);
    }
}

