/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineErrors {
    private static final Logger log = LoggerFactory.getLogger(CommandLineErrors.class);
    public static final String MAVEN = "Maven";
    public static final String GRADLE = "Gradle";
    public static final String NPM = "NPM";
    public static final String DOTNET = "DotNet";
    public static final String NUGET = "Nuget";
    private static List<String> failedCommands = Collections.synchronizedList(new ArrayList());
    private static Set<String> failedResolver = Collections.synchronizedSet(new HashSet());

    public static void addFailedCmd(String cmd) {
        if (StringUtils.isNotEmpty((CharSequence)cmd)) {
            failedCommands.add(cmd);
            CommandLineErrors.addFailedResolver();
        }
    }

    public static void removeFailedCmd(String cmd, String resolver) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)cmd) && failedCommands.remove(cmd) && !failedCommands.contains(cmd) && StringUtils.isNotEmpty((CharSequence)resolver)) {
                failedResolver.remove(resolver);
            }
        }
        catch (Exception e) {
            log.error("Fail to remove command: " + cmd, (Throwable)e);
        }
    }

    public static List<String> getFailedCommands() {
        return failedCommands;
    }

    public static Set<String> getFailedResolver() {
        return failedResolver;
    }

    private static void addFailedResolver() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (StringUtils.containsIgnoreCase((CharSequence)ste.getClassName(), (CharSequence)MAVEN)) {
                failedResolver.add(MAVEN);
                break;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)ste.getClassName(), (CharSequence)GRADLE)) {
                failedResolver.add(GRADLE);
                break;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)ste.getClassName(), (CharSequence)NPM)) {
                failedResolver.add(NPM);
                break;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)ste.getClassName(), (CharSequence)DOTNET)) {
                failedResolver.add(DOTNET);
                break;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)ste.getClassName(), (CharSequence)NUGET)) continue;
            failedResolver.add(NUGET);
            break;
        }
    }
}

