/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.SingleFileScanner;
import org.whitesource.agent.dependency.resolver.ResolvedFolder;

public class FilesScanner {
    private Logger logger = LoggerFactory.getLogger(FilesScanner.class);

    public String[] getDirectoryContent(String scannerBaseDir, String[] includes, String[] excludes, boolean followSymlinks, boolean globCaseSensitive) {
        return this.getDirectoryContent(scannerBaseDir, includes, excludes, followSymlinks, globCaseSensitive, false);
    }

    public String[] getDirectoryContent(String scannerBaseDir, String[] includes, String[] excludes, boolean followSymlinks, boolean globCaseSensitive, boolean scanDirectories) {
        File file = new File(scannerBaseDir);
        if (file.exists() && file.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(scannerBaseDir);
            scanner.setIncludes(includes);
            scanner.setExcludes(excludes);
            scanner.setFollowSymlinks(followSymlinks);
            scanner.setCaseSensitive(globCaseSensitive);
            scanner.scan();
            String[] fileNames = !scanDirectories ? scanner.getIncludedFiles() : scanner.getIncludedDirectories();
            return fileNames;
        }
        this.logger.debug("{} is not a folder", (Object)scannerBaseDir);
        return new String[0];
    }

    public Collection<ResolvedFolder> findTopFolders(Collection<String> pathsToScan, String[] includesPattern, Collection<String> excludes) {
        ArrayList<ResolvedFolder> resolvedFolders = new ArrayList<ResolvedFolder>();
        Map<String, String[]> pathToBomFilesMap = this.findAllFiles(pathsToScan, includesPattern, excludes);
        pathToBomFilesMap.forEach((folder, bomFile) -> {
            Map<String, Set<String>> topFolders = this.getTopFoldersWithIncludedFiles((String)folder, (String[])bomFile);
            resolvedFolders.add(new ResolvedFolder((String)folder, topFolders));
        });
        return resolvedFolders;
    }

    private Map<String, String[]> findAllFiles(Collection<String> pathsToScan, String[] includesPattern, Collection<String> excludes) {
        HashMap<String, String[]> pathToIncludedFilesMap = new HashMap<String, String[]>();
        pathsToScan.stream().forEach(scanFolder -> {
            String[] includedFiles = this.getDirectoryContent(new File((String)scanFolder).getPath(), includesPattern, excludes.toArray(new String[excludes.size()]), false, false);
            pathToIncludedFilesMap.put(new File((String)scanFolder).getAbsolutePath(), includedFiles);
        });
        return pathToIncludedFilesMap;
    }

    private Map<String, Set<String>> getTopFoldersWithIncludedFiles(String rootFolder, String[] includedFiles) {
        List fullPaths = Arrays.stream(includedFiles).map(file -> Paths.get(new File(rootFolder).getAbsolutePath(), file).toString()).collect(Collectors.toList());
        Map<String, List<String>> foldersGroupedByLengthMap = fullPaths.stream().collect(Collectors.groupingBy(filename -> new File((String)filename).getParentFile().getParent()));
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        if (!foldersGroupedByLengthMap.isEmpty()) {
            this.logger.info("Found {} folders", (Object)foldersGroupedByLengthMap.size());
            foldersGroupedByLengthMap.keySet().forEach(folder -> this.logger.debug("\t" + folder));
        }
        while (foldersGroupedByLengthMap.entrySet().size() > 0) {
            String shortestFolder = foldersGroupedByLengthMap.keySet().stream().min(Comparator.comparingInt(String::length)).get();
            List<String> foundShortestFolder = foldersGroupedByLengthMap.get(shortestFolder);
            foldersGroupedByLengthMap.remove(shortestFolder);
            List<String> topFolders = foundShortestFolder.stream().map(file -> new File((String)file).getParent()).collect(Collectors.toList());
            topFolders.forEach(folder -> {
                resultMap.put((String)folder, fullPaths.stream().filter(fileName -> fileName.contains((CharSequence)folder)).collect(Collectors.toSet()));
                foldersGroupedByLengthMap.entrySet().removeIf(otherFolder -> {
                    Path otherFolderPath = Paths.get((String)otherFolder.getKey(), new String[0]);
                    Path folderPath = Paths.get(folder, new String[0]).getParent();
                    boolean shouldRemove = false;
                    try {
                        shouldRemove = otherFolder.getValue() != null && !((List)otherFolder.getValue()).isEmpty() && (((String)((List)otherFolder.getValue()).get(0)).endsWith(".csproj") || ((String)((List)otherFolder.getValue()).get(0)).endsWith(".config") && !((String)((List)otherFolder.getValue()).get(0)).contains(File.separator + ".vs" + File.separator) || ((String)((List)otherFolder.getValue()).get(0)).endsWith("build.sbt")) ? false : otherFolderPath.toFile().getCanonicalPath().startsWith(folderPath.toFile().getCanonicalPath());
                    }
                    catch (Exception e) {
                        this.logger.warn("Couldn't get file path [{}{}]: {}", new Object[]{otherFolderPath, folderPath, e.getMessage()});
                        this.logger.debug("Exception: {}", (Object)e.toString());
                    }
                    if (shouldRemove) {
                        this.logger.debug("Removed possible duplicated folder [{}]", otherFolder.getKey());
                        return true;
                    }
                    return false;
                });
            });
        }
        return resultMap;
    }

    public boolean isIncluded(File file, String[] includes, String[] excludes, boolean followSymlinks, boolean globCaseSensitive) {
        SingleFileScanner scanner = new SingleFileScanner();
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.setFollowSymlinks(followSymlinks);
        scanner.setCaseSensitive(globCaseSensitive);
        return scanner.isIncluded(file);
    }
}

