/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.jaxb.runtime.v2.JAXBContextFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxbUtil {
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getJAXBContext(Class type) throws JAXBException {
        Object object = lock;
        synchronized (object) {
            JAXBContextFactory jaxbContextFactory = new JAXBContextFactory();
            return jaxbContextFactory.createContext(new Class[]{type}, null);
        }
    }

    public static <JaxbObject> JaxbObject readFromPath(File xmlFile, Class<JaxbObject> jaxbObjectType) {
        JaxbObject jaxbObject;
        try {
            InputStream is = Files.newInputStream(xmlFile.toPath(), new OpenOption[0]);
            jaxbObject = JaxbUtil.readJaxbObject(is, jaxbObjectType);
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse xml", e);
        }
        return jaxbObject;
    }

    public static <JaxbObject> JaxbObject readJaxbObject(String xmlContent, Class<JaxbObject> jaxbObjectType) throws JAXBException {
        return JaxbUtil.readJaxbObject(new ByteArrayInputStream(xmlContent.getBytes()), jaxbObjectType);
    }

    public static <JaxbObject> JaxbObject readJaxbObject(InputStream inputStream, Class<JaxbObject> jaxbObjectType) throws JAXBException {
        try {
            JAXBContext jaxbContext = JaxbUtil.getJAXBContext(jaxbObjectType);
            Unmarshaller um = jaxbContext.createUnmarshaller();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(inputStream);
            Object jaxbObject = um.unmarshal((Node)doc);
            return (JaxbObject)jaxbObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <JaxbObject> byte[] writeJaxbObjectToBytes(JaxbObject jaxbObject) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JaxbUtil.writeJaxbObject(out, jaxbObject);
        return out.toByteArray();
    }

    public static <JaxbObject> String write(JaxbObject jaxbObject) {
        try {
            return JaxbUtil.writeJaxbObject(jaxbObject);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to write jaxbObject " + jaxbObject.toString(), e);
        }
    }

    public static <JaxbObject> String writeJaxbObject(JaxbObject jaxbObject) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JaxbUtil.writeJaxbObject(out, jaxbObject);
        return out.toString();
    }

    public static <JaxbObject> void writeJaxbObject(OutputStream outputStream, JaxbObject jaxbObject) throws JAXBException {
        JAXBContext jaxbContext = JaxbUtil.getJAXBContext(jaxbObject.getClass());
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(jaxbObject, outputStream);
    }

    public static <JaxbObject> void writeToFile(JaxbObject jaxbObject, File file) {
        try {
            JAXBContext jaxbContext = JaxbUtil.getJAXBContext(jaxbObject.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(jaxbObject, file);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to write jaxbObject " + jaxbObject.toString(), e);
        }
    }

    public static <JaxbObject> JaxbObject clone(JaxbObject jaxbObject) throws JAXBException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JaxbUtil.writeJaxbObject(byteArrayOutputStream, jaxbObject);
        return (JaxbObject)JaxbUtil.readJaxbObject(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), jaxbObject.getClass());
    }
}

