/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.FileSystemScanner;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.fs.ExtensionUtils;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.configuration.ConfigurationSerializer;
import org.whitesource.fs.configuration.ResolverConfiguration;

public class ComponentScan {
    private final Logger logger = LoggerFactory.getLogger(ComponentScan.class);
    private Properties config;

    public ComponentScan(Properties config) {
        this.config = config;
    }

    public synchronized String scan() {
        Thread thread = Thread.currentThread();
        this.logger.debug("[CX-FSA] Thread name: " + thread.getName() + ", Thread id: " + thread.getId());
        this.logger.info("Starting analysis - component scan has started");
        String directory = this.config.getProperty("d");
        String[] directories = directory.split(",");
        ArrayList<String> scannerBaseDirs = new ArrayList<String>(Arrays.asList(directories));
        if (!scannerBaseDirs.isEmpty()) {
            this.logger.info("Getting properties");
            FSAConfiguration fsaConfiguration = new FSAConfiguration(this.config);
            ResolverConfiguration resolverConfiguration = fsaConfiguration.getResolver();
            String[] includes = this.config.getProperty("includes") != null ? this.config.getProperty("includes").split("[,;\\s]+") : ExtensionUtils.INCLUDES;
            String[] excludes = this.config.getProperty("excludes") != null ? this.config.getProperty("excludes").split("[,;\\s]+") : ExtensionUtils.EXCLUDES;
            Object[] acceptExtensionsList = (String[])this.config.get("acceptExtensionsList");
            if (!resolverConfiguration.isDependenciesOnly()) {
                try {
                    acceptExtensionsList = (String[])ArrayUtils.addAll((Object[])acceptExtensionsList, (Object[])ExtensionUtils.SOURCE_EXTENSIONS.toArray());
                }
                catch (Exception e) {
                    this.logger.error("Fail to add source extensions to accepted list.", (Throwable)e);
                }
            }
            boolean globCaseSensitive = this.config.getProperty("case.sensitive.glob") != null && Boolean.parseBoolean(this.config.getProperty("case.sensitive.glob"));
            boolean followSymlinks = this.config.getProperty("followSymbolicLinks") != null && Boolean.parseBoolean(this.config.getProperty("followSymbolicLinks"));
            boolean includeFsDependencies = this.config.getProperty("includeFsDependencies") != null && Boolean.parseBoolean(this.config.getProperty("includeFsDependencies"));
            Collection<String> excludedCopyrights = fsaConfiguration.getAgent().getExcludedCopyrights();
            excludedCopyrights.remove("");
            this.logger.info("Resolving dependencies");
            HashSet<String> setDirs = new HashSet<String>();
            setDirs.addAll(scannerBaseDirs);
            HashMap<String, Set<String>> appPathsToDependencyDirs = new HashMap<String, Set<String>>();
            appPathsToDependencyDirs.put("defaultKey", setDirs);
            Set<AgentProjectInfo> projects = new FileSystemScanner(resolverConfiguration, fsaConfiguration.getAgent(), false).createProjects(scannerBaseDirs, appPathsToDependencyDirs, false, includes, excludes, globCaseSensitive, fsaConfiguration.getAgent().getArchiveExtractionDepth(), fsaConfiguration.getAgent().getArchiveIncludes(), fsaConfiguration.getAgent().getArchiveExcludes(), fsaConfiguration.getAgent().isArchiveFastUnpack(), followSymlinks, excludedCopyrights, fsaConfiguration.getAgent().isPartialSha1Match(), fsaConfiguration.getAgent().isCalculateHints(), fsaConfiguration.getAgent().isCalculateMd5(), fsaConfiguration.getAgent().getPythonRequirementsFileIncludes(), includeFsDependencies).keySet();
            this.logger.debug("Filtering {} dependencies in {} project(s) for accepted extensions", (Object)projects.stream().mapToInt(c -> c.getDependencies().size()).sum(), (Object)projects.size());
            for (AgentProjectInfo project : projects) {
                project.setProjectToken(" ");
                if (acceptExtensionsList == null || acceptExtensionsList.length <= 0) continue;
                project.setDependencies(this.getDependenciesFromExtensionsListOnly(project.getDependencies(), (String[])acceptExtensionsList));
            }
            this.logger.info("Finished dependency resolution, found {} dependencies in {} project(s)", (Object)projects.stream().mapToInt(c -> c.getDependencies().size()).sum(), (Object)projects.size());
            return new ConfigurationSerializer<Set<AgentProjectInfo>>().getAsString(projects, true);
        }
        return "";
    }

    private List<DependencyInfo> getDependenciesFromExtensionsListOnly(Collection<DependencyInfo> dependencies, String[] acceptExtensionsList) {
        LinkedList<DependencyInfo> filteredDependencies = new LinkedList<DependencyInfo>();
        block0: for (DependencyInfo dependency : dependencies) {
            for (String extension : acceptExtensionsList) {
                if (dependency.getDependencyType() == null && !dependency.getArtifactId().endsWith("." + extension) && !this.checkFileName(dependency, extension)) continue;
                filteredDependencies.add(dependency);
                dependency.setChildren(this.getDependenciesFromExtensionsListOnly(dependency.getChildren(), acceptExtensionsList));
                continue block0;
            }
        }
        return filteredDependencies;
    }

    private boolean checkFileName(DependencyInfo dependency, String extension) {
        boolean fileNameEndsWithExtension = false;
        if (dependency.getFilename() != null) {
            fileNameEndsWithExtension = dependency.getFilename().endsWith("." + extension);
        }
        return fileNameEndsWithExtension;
    }
}

