/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import com.beust.jcommander.JCommander;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.ViaLanguage;
import org.whitesource.agent.api.dispatch.UpdateType;
import org.whitesource.agent.utils.Pair;
import org.whitesource.fs.CommandLineArgs;
import org.whitesource.fs.configuration.AgentConfiguration;
import org.whitesource.fs.configuration.ConfigurationValidation;
import org.whitesource.fs.configuration.EndPointConfiguration;
import org.whitesource.fs.configuration.OfflineConfiguration;
import org.whitesource.fs.configuration.RequestConfiguration;
import org.whitesource.fs.configuration.ResolverConfiguration;
import org.whitesource.fs.configuration.ScmConfiguration;
import org.whitesource.fs.configuration.SenderConfiguration;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FSAConfiguration {
    public static Collection<String> ignoredWebProperties = Arrays.asList("scm.repositoriesFile", "log.level", "followSymbolicLinks", "showProgressBar", "configFilePath", "scanPackageManager", "whiteSourceFolderPath", "endpoint.enabled", "endpoint.port", "endpoint.certificate", "endpoint.pass", "endpoint.ssl", "offline", "offline.zip", "offline.prettyJson", "whitesourceConfiguration", "d");
    public static final int VIA_DEFAULT_ANALYSIS_LEVEL = 1;
    public static final String DEFAULT_KEY = "defaultKey";
    public static final String APP_PATH = "-appPath";
    private static final String FALSE = "false";
    private static final String INFO = "info";
    public static final String INCLUDES_EXCLUDES_SEPARATOR_REGEX = "[,;\\s]+";
    private static final int DEFAULT_ARCHIVE_DEPTH = 0;
    private static final String NONE = "(none)";
    public static final String WHITE_SOURCE_DEFAULT_FOLDER_PATH = ".";
    public static final String PIP = "pip";
    public static final String PYTHON = "python";
    public static final int DEFAULT_PORT = 443;
    public static final boolean DEFAULT_SSL = true;
    private static final boolean DEFAULT_ENABLED = false;
    private final ScmConfiguration scm;
    private final SenderConfiguration sender;
    private final OfflineConfiguration offline;
    private final ResolverConfiguration resolver;
    private final ConfigurationValidation configurationValidation;
    private final EndPointConfiguration endpoint;
    private final List<String> errors;
    private final List<String> offlineRequestFiles;
    private final String fileListPath;
    private List<String> dependencyDirs;
    private final String configFilePath;
    private final AgentConfiguration agent;
    private final RequestConfiguration request;
    private final List<String> requirementsFileIncludes;
    private final boolean scanPackageManager;
    private final boolean scanDockerImages;
    private final String scannedFolders;
    private String logLevel;
    private boolean useCommandLineProductName;
    private boolean useCommandLineProjectName;
    private List<String> appPaths;
    private Map<String, Set<String>> appPathsToDependencyDirs;
    private final Logger logger = LoggerFactory.getLogger(FSAConfiguration.class);

    public String toString() {
        return "FSA Configuration {\nlogLevel" + this.logLevel + '\n' + "configFilePath=" + this.configFilePath + '\n' + "fileListPath=" + this.fileListPath + '\n' + "dependencyDirs=" + Arrays.asList(this.dependencyDirs) + '\n' + this.sender.toString() + '\n' + this.resolver.toString() + '\n' + ", dependencyDirs=" + Arrays.asList(this.dependencyDirs) + '\n' + this.request.toString() + '\n' + ", requirementsFileIncludes=" + Arrays.asList(this.requirementsFileIncludes) + '\n' + ", scanPackageManager=" + this.scanPackageManager + '\n' + ", scanDockerImages=" + this.scanDockerImages + '\n' + ", requirementsFileIncludes=" + Arrays.asList(this.requirementsFileIncludes) + '\n' + this.getAgent().toString() + '\n' + '}';
    }

    public FSAConfiguration(Properties config) {
        this(config, null);
    }

    public FSAConfiguration() {
        this(new Properties(), null);
    }

    public FSAConfiguration(String[] args) {
        this(null, args);
    }

    public FSAConfiguration(Properties config, String[] args) {
        String projectName;
        config = this.addConfigurationFromEnvVariable(config);
        this.logger.info("Configuration: ");
        if (config != null) {
            for (Object key : new TreeSet<Object>(config.keySet())) {
                this.logger.info("\t{}\t{}", (Object)String.format("%-30s", key), config.get(key));
            }
        }
        this.configurationValidation = new ConfigurationValidation();
        this.errors = new ArrayList<String>();
        this.appPathsToDependencyDirs = new HashMap<String, Set<String>>();
        this.requirementsFileIncludes = new LinkedList<String>();
        this.appPaths = null;
        if (args != null) {
            CommandLineArgs commandLineArgs = new CommandLineArgs();
            new JCommander((Object)commandLineArgs, args);
            if (config == null) {
                Pair<Properties, List<String>> propertiesWithErrors = FSAConfiguration.readWithError(commandLineArgs.configFilePath);
                this.errors.addAll((Collection<String>)propertiesWithErrors.getValue());
                config = propertiesWithErrors.getKey();
                if (StringUtils.isNotEmpty((String)commandLineArgs.project)) {
                    config.setProperty("projectName", commandLineArgs.project);
                }
            }
            this.scannedFolders = config.getProperty("d");
            if (this.scannedFolders != null) {
                String[] libsList = this.scannedFolders.split(",");
                Arrays.stream(libsList).map(String::trim).toArray(unused -> libsList);
                this.dependencyDirs = Arrays.asList(libsList);
            }
            this.configFilePath = commandLineArgs.configFilePath;
            config.setProperty("configFilePath", commandLineArgs.configFilePath);
            this.offlineRequestFiles = this.updateProperties(config, commandLineArgs);
            projectName = config.getProperty("projectName");
            this.fileListPath = commandLineArgs.fileListPath;
            if (commandLineArgs.dependencyDirs != null && !commandLineArgs.dependencyDirs.isEmpty()) {
                this.dependencyDirs = commandLineArgs.dependencyDirs;
            }
            this.appPaths = commandLineArgs.appPath;
            if (StringUtils.isNotBlank((String)commandLineArgs.whiteSourceFolder)) {
                config.setProperty("whiteSourceFolderPath", commandLineArgs.whiteSourceFolder);
            }
            this.requirementsFileIncludes.addAll(commandLineArgs.requirementsFileIncludes);
            if (!this.requirementsFileIncludes.isEmpty()) {
                String requirements = null;
                for (String requirementFileIncludes : this.requirementsFileIncludes) {
                    if (requirements == null) {
                        requirements = requirementFileIncludes + " ";
                        continue;
                    }
                    requirements = requirements + requirementFileIncludes + " ";
                }
                config.setProperty("python.requirementsFileIncludes", requirements);
            }
            this.commandLineArgsOverride(commandLineArgs);
        } else {
            projectName = config.getProperty("projectName");
            this.configFilePath = NONE;
            this.offlineRequestFiles = new ArrayList<String>();
            this.fileListPath = null;
            this.scannedFolders = null;
            this.dependencyDirs = new ArrayList<String>();
            this.commandLineArgsOverride(null);
        }
        this.scanPackageManager = FSAConfiguration.getBooleanProperty(config, "scanPackageManager", false);
        this.scanDockerImages = FSAConfiguration.getBooleanProperty(config, "docker.scanImages", false);
        if (this.dependencyDirs == null) {
            this.dependencyDirs = new ArrayList<String>();
        }
        if (this.dependencyDirs.isEmpty()) {
            this.dependencyDirs.add(WHITE_SOURCE_DEFAULT_FOLDER_PATH);
        }
        String projectToken = config.getProperty("projectToken");
        String projectNameFinal = !StringUtils.isBlank((String)projectName) ? projectName : config.getProperty("projectName");
        boolean projectPerFolder = FSAConfiguration.getBooleanProperty(config, "projectPerFolder", false);
        String apiToken = config.getProperty("apiKey");
        String userKey = config.getProperty("userKey");
        int archiveExtractionDepth = FSAConfiguration.getArchiveDepth(config);
        String[] includes = FSAConfiguration.getIncludes(config);
        String[] projectPerFolderIncludes = FSAConfiguration.getProjectPerFolderIncludes(config);
        String[] pythonRequirementsFileIncludes = FSAConfiguration.getPythonIncludes(config);
        String[] argsForAppPathAndDirs = args;
        if (argsForAppPathAndDirs != null && argsForAppPathAndDirs.length == 0 && !this.dependencyDirs.isEmpty()) {
            argsForAppPathAndDirs = this.dependencyDirs.toArray(new String[0]);
        }
        this.initializeDependencyDirs(argsForAppPathAndDirs, config);
        String iaLanguage = config.getProperty("iaLanguage");
        boolean iaLanguageValid = false;
        if (iaLanguage != null) {
            for (ViaLanguage viaLanguage : ViaLanguage.values()) {
                if (!iaLanguage.toLowerCase().equals(viaLanguage.toString().toLowerCase())) continue;
                iaLanguageValid = true;
            }
            if (!iaLanguageValid) {
                this.errors.add("Error: VIA setting are not applicable parameters are not valid. exiting... ");
            }
            if (iaLanguageValid && !FSAConfiguration.getBooleanProperty(config, "enableImpactAnalysis", false)) {
                this.errors.add("Error: VIA setting are not applicable parameters are not valid. exiting... ");
            }
        }
        this.errors.addAll(this.configurationValidation.getConfigurationErrors(projectPerFolder, projectToken, projectNameFinal, apiToken, this.configFilePath, archiveExtractionDepth, includes, projectPerFolderIncludes, pythonRequirementsFileIncludes));
        this.logLevel = config.getProperty("log.level", INFO);
        this.request = this.getRequest(config, apiToken, userKey, projectName, projectToken);
        this.scm = this.getScm(config);
        this.agent = this.getAgent(config);
        this.offline = this.getOffline(config);
        this.sender = this.getSender(config);
        this.resolver = this.getResolver(config);
        this.endpoint = this.getEndpoint(config);
    }

    private Properties addConfigurationFromEnvVariable(Properties config) {
        try {
            String[] parts;
            String fsaEnvConfig = System.getenv("FSA_CONFIGURATION");
            String string = fsaEnvConfig = StringUtils.isNotEmpty((String)fsaEnvConfig) ? fsaEnvConfig : System.getProperty("FSA_CONFIGURATION");
            if (StringUtils.isEmpty((String)fsaEnvConfig)) {
                return config;
            }
            if (config == null) {
                config = new Properties();
            }
            this.logger.info("Loading configuration from FSA_CONFIGURATION environment variable");
            for (String part : parts = fsaEnvConfig.split(";")) {
                if (StringUtils.isEmpty((String)part)) continue;
                String[] pair = part.split("=");
                if (pair.length == 1) {
                    config.put(pair[0].trim(), "");
                    continue;
                }
                config.put(pair[0].trim(), pair[1].trim());
            }
        }
        catch (Exception exception) {
            this.logger.error("Invalid value for FSA_CONFIGURATION environment variable.");
            this.logger.error("Please use key=value pairs separated by semicolons.");
            this.logger.error("e.g. \"maven.ignorePomModules=false;python.resolveHierarchyTree=true\"");
            System.exit(1);
        }
        return config;
    }

    private void initializeDependencyDirs(String[] argsForAppPathAndDirs, Properties config) {
        if (StringUtils.isNotEmpty((String)config.getProperty("xPaths"))) {
            try {
                String textFromFile = new String(Files.readAllBytes(Paths.get(config.getProperty("xPaths"), new String[0])), StandardCharsets.UTF_8);
                textFromFile = textFromFile.replaceAll(", ", ",");
                textFromFile = textFromFile.replaceAll(System.lineSeparator(), " ");
                argsForAppPathAndDirs = textFromFile.split(" ");
                if (argsForAppPathAndDirs != null && argsForAppPathAndDirs.length > 0) {
                    this.initializeDependencyDirsToAppPath(argsForAppPathAndDirs);
                }
                for (String appPath : this.appPathsToDependencyDirs.keySet()) {
                    for (String dir : this.appPathsToDependencyDirs.get(appPath)) {
                        this.dependencyDirs.add(dir);
                    }
                }
            }
            catch (IOException e) {
                this.errors.add("Error: Could not read the xPaths file: " + config.getProperty("xPaths"));
            }
        } else if (argsForAppPathAndDirs != null && argsForAppPathAndDirs.length > 0) {
            this.initializeDependencyDirsToAppPath(argsForAppPathAndDirs);
        }
    }

    private EndPointConfiguration getEndpoint(Properties config) {
        return new EndPointConfiguration(FSAConfiguration.getIntProperty(config, "endpoint.port", 443), config.getProperty("endpoint.certificate"), config.getProperty("endpoint.pass"), FSAConfiguration.getBooleanProperty(config, "endpoint.enabled", false), FSAConfiguration.getBooleanProperty(config, "endpoint.ssl", true));
    }

    private ResolverConfiguration getResolver(Properties config) {
        boolean npmRunPreStep = FSAConfiguration.getBooleanProperty(config, "npm.runPreStep", false);
        boolean npmIgnoreScripts = FSAConfiguration.getBooleanProperty(config, "npm.ignoreScripts", false);
        boolean npmResolveDependencies = FSAConfiguration.getBooleanProperty(config, "npm.resolveDependencies", true);
        boolean npmIncludeDevDependencies = FSAConfiguration.getBooleanProperty(config, "npm.includeDevDependencies", false);
        boolean npmIgnoreJavaScriptFiles = FSAConfiguration.getBooleanProperty(config, "npm.ignoreJavaScriptFiles", true);
        long npmTimeoutDependenciesCollector = FSAConfiguration.getLongProperty(config, "npm.timeoutDependenciesCollectorInSeconds", 60L);
        boolean npmIgnoreNpmLsErrors = FSAConfiguration.getBooleanProperty(config, "npm.ignoreNpmLsErrors", true);
        String npmAccessToken = config.getProperty("npm.accessToken");
        boolean npmYarnProject = FSAConfiguration.getBooleanProperty(config, "npm.yarnProject", false);
        boolean bowerResolveDependencies = FSAConfiguration.getBooleanProperty(config, "bower.resolveDependencies", true);
        boolean bowerRunPreStep = FSAConfiguration.getBooleanProperty(config, "bower.runPreStep", false);
        boolean nugetResolveDependencies = FSAConfiguration.getBooleanProperty(config, "nuget.resolveDependencies", true);
        boolean nugetRestoreDependencies = FSAConfiguration.getBooleanProperty(config, "nuget.restoreDependencies", false);
        boolean mavenResolveDependencies = FSAConfiguration.getBooleanProperty(config, "maven.resolveDependencies", true);
        String[] mavenIgnoredScopes = FSAConfiguration.getListProperty(config, "maven.ignoredScopes", null);
        boolean mavenAggregateModules = FSAConfiguration.getBooleanProperty(config, "maven.aggregateModules", false);
        boolean mavenIgnoredPomModules = FSAConfiguration.getBooleanProperty(config, "maven.ignorePomModules", true);
        boolean mavenIgnoredFailedModules = FSAConfiguration.getBooleanProperty(config, "maven.ignoreFailedModules", false);
        boolean mavenRunPreStep = FSAConfiguration.getBooleanProperty(config, "maven.runPreStep", false);
        boolean dependenciesOnly = FSAConfiguration.getBooleanProperty(config, "dependenciesOnly", true);
        String whiteSourceConfiguration = config.getProperty("configFilePath");
        boolean pythonResolveDependencies = FSAConfiguration.getBooleanProperty(config, "python.resolveDependencies", true);
        String pipPath = config.getProperty("python.pipPath", PIP);
        String pythonPath = config.getProperty("python.path", PYTHON);
        boolean pythonIsWssPluginInstalled = FSAConfiguration.getBooleanProperty(config, "python.isWssPluginInstalled", false);
        boolean pythonUninstallWssPluginInstalled = FSAConfiguration.getBooleanProperty(config, "python.uninstallWssPlugin", false);
        boolean pythonIgnorePipInstallErrors = FSAConfiguration.getBooleanProperty(config, "python.ignorePipInstallErrors", false);
        boolean pythonInstallVirtualenv = FSAConfiguration.getBooleanProperty(config, "python.installVirtualenv", false);
        boolean pythonResolveHierarchyTree = FSAConfiguration.getBooleanProperty(config, "python.resolveHierarchyTree", true);
        boolean pythonResolveSetupPyFiles = FSAConfiguration.getBooleanProperty(config, "python.resolveSetupPyFiles", false);
        String[] bomPatternForPython = pythonResolveSetupPyFiles ? new String[]{"**/*requirements.txt", "**/*setup.py"} : new String[]{"**/*requirements.txt"};
        String[] pythonRequirementsFileIncludes = FSAConfiguration.getListProperty(config, "python.requirementsFileIncludes", bomPatternForPython);
        boolean gradleResolveDependencies = FSAConfiguration.getBooleanProperty(config, "gradle.resolveDependencies", true);
        boolean gradleRunAssembleCommand = FSAConfiguration.getBooleanProperty(config, "gradle.runAssembleCommand", true);
        boolean gradleAggregateModules = FSAConfiguration.getBooleanProperty(config, "gradle.aggregateModules", false);
        String[] gradleIgnoredScopes = FSAConfiguration.getListProperty(config, "gradle.ignoredScopes", new String[0]);
        boolean gradleAllowDaemon = FSAConfiguration.getBooleanProperty(config, "gradle.allowDaemon", false);
        boolean paketResolveDependencies = FSAConfiguration.getBooleanProperty(config, "paket.resolveDependencies", true);
        String[] paketIgnoredScopes = FSAConfiguration.getListProperty(config, "paket.ignoredGroups", null);
        boolean paketIgnoreFiles = FSAConfiguration.getBooleanProperty(config, "paket.ignoreFiles", true);
        boolean paketRunPreStep = FSAConfiguration.getBooleanProperty(config, "paket.runPreStep", false);
        String paketPath = config.getProperty("paket.exePath", null);
        boolean goResolveDependencies = FSAConfiguration.getBooleanProperty(config, "go.resolveDependencies", true);
        String goDependencyManager = config.getProperty("go.dependencyManager", "");
        boolean goCollectDependenciesAtRuntime = FSAConfiguration.getBooleanProperty(config, "go.collectDependenciesAtRuntime", false);
        boolean rubyResolveDependencies = FSAConfiguration.getBooleanProperty(config, "ruby.resolveDependencies", true);
        boolean rubyRunBundleInstall = FSAConfiguration.getBooleanProperty(config, "ruby.runBundleInstall", false);
        boolean rubyOverwriteGemFile = FSAConfiguration.getBooleanProperty(config, "ruby.overwriteGemFile", false);
        boolean rubyInstallMissingGems = FSAConfiguration.getBooleanProperty(config, "ruby.installMissingGems", false);
        boolean phpResolveDependencies = FSAConfiguration.getBooleanProperty(config, "php.resolveDependencies", true);
        boolean phpRunPreStep = FSAConfiguration.getBooleanProperty(config, "php.runPreStep", false);
        boolean phpIncludeDevDependencies = FSAConfiguration.getBooleanProperty(config, "php.includeDevDependencies", false);
        boolean sbtResolveDependencies = FSAConfiguration.getBooleanProperty(config, "sbt.resolveDependencies", true);
        boolean sbtAggregateModules = FSAConfiguration.getBooleanProperty(config, "sbt.aggregateModules", false);
        boolean sbtRunPreStep = FSAConfiguration.getBooleanProperty(config, "sbt.runPreStep", false);
        String sbtTargetFolder = config.getProperty("sbt.targetFolder", "");
        boolean htmlResolveDependencies = FSAConfiguration.getBooleanProperty(config, "html.resolveDependencies", true);
        boolean jsResolveDependencies = FSAConfiguration.getBooleanProperty(config, "js.resolveDependencies", true);
        return new ResolverConfiguration(npmRunPreStep, npmResolveDependencies, npmIgnoreScripts, npmIncludeDevDependencies, npmIgnoreJavaScriptFiles, npmTimeoutDependenciesCollector, npmAccessToken, npmIgnoreNpmLsErrors, npmYarnProject, bowerResolveDependencies, bowerRunPreStep, nugetResolveDependencies, nugetRestoreDependencies, mavenResolveDependencies, mavenIgnoredScopes, mavenAggregateModules, mavenIgnoredPomModules, mavenIgnoredFailedModules, mavenRunPreStep, pythonResolveDependencies, pipPath, pythonPath, pythonIsWssPluginInstalled, pythonUninstallWssPluginInstalled, pythonIgnorePipInstallErrors, pythonInstallVirtualenv, pythonResolveHierarchyTree, pythonRequirementsFileIncludes, pythonResolveSetupPyFiles, dependenciesOnly, whiteSourceConfiguration, gradleResolveDependencies, gradleRunAssembleCommand, gradleAggregateModules, gradleIgnoredScopes, gradleAllowDaemon, paketResolveDependencies, paketIgnoredScopes, paketIgnoreFiles, paketRunPreStep, paketPath, goResolveDependencies, goDependencyManager, goCollectDependenciesAtRuntime, rubyResolveDependencies, rubyRunBundleInstall, rubyOverwriteGemFile, rubyInstallMissingGems, phpResolveDependencies, phpRunPreStep, phpIncludeDevDependencies, sbtResolveDependencies, sbtAggregateModules, sbtRunPreStep, sbtTargetFolder, htmlResolveDependencies, jsResolveDependencies);
    }

    private RequestConfiguration getRequest(Properties config, String apiToken, String userKey, String projectName, String projectToken) {
        String productToken = config.getProperty("productToken");
        String productName = config.getProperty("productName");
        String productVersion = config.getProperty("productVersion");
        String projectVersion = config.getProperty("projectVersion");
        List appPath = (List)config.get("appPath");
        String iaLanguage = config.getProperty("iaLanguage", null);
        String viaDebug = config.getProperty("viaDebug", "");
        boolean projectPerSubFolder = FSAConfiguration.getBooleanProperty(config, "projectPerFolder", false);
        String requesterEmail = config.getProperty("requesterEmail");
        int viaAnalysis = FSAConfiguration.getIntProperty(config, "viaAnalysysLevel", 1);
        return new RequestConfiguration(apiToken, userKey, requesterEmail, projectPerSubFolder, projectName, projectToken, projectVersion, productName, productToken, productVersion, appPath, viaDebug, viaAnalysis, iaLanguage);
    }

    private SenderConfiguration getSender(Properties config) {
        String updateTypeValue = config.getProperty("updateType", UpdateType.OVERRIDE.toString());
        boolean checkPolicies = FSAConfiguration.getBooleanProperty(config, "checkPolicies", false);
        boolean forceCheckAllDependencies = FSAConfiguration.getBooleanProperty(config, "forceCheckAllDependencies", false);
        boolean forceUpdate = FSAConfiguration.getBooleanProperty(config, "forceUpdate", false);
        boolean forceUpdateBuildFailed = FSAConfiguration.getBooleanProperty(config, "forceUpdate.failBuildOnPolicyViolation", false);
        boolean enableImpactAnalysis = FSAConfiguration.getBooleanProperty(config, "enableImpactAnalysis", false);
        String serviceUrl = config.getProperty("wss.url", "https://saas.whitesourcesoftware.com/agent");
        String proxyHost = config.getProperty("proxy.host");
        int connectionTimeOut = Integer.parseInt(config.getProperty("wss.connectionTimeoutMinutes", String.valueOf(60)));
        int connectionRetries = FSAConfiguration.getIntProperty(config, "connectionRetries", 1);
        int connectionRetriesIntervals = FSAConfiguration.getIntProperty(config, "connectionRetriesInterval", 3000);
        String senderPort = config.getProperty("proxy.port");
        int proxyPort = StringUtils.isNotEmpty((String)senderPort) ? Integer.parseInt(senderPort) : -1;
        String proxyUser = config.getProperty("proxy.user");
        String proxyPassword = config.getProperty("proxy.pass");
        boolean ignoreCertificateCheck = FSAConfiguration.getBooleanProperty(config, "ignoreCertificateCheck", false);
        boolean isSendLogsToWss = FSAConfiguration.getBooleanProperty(config, "sendLogsToWss", false);
        return new SenderConfiguration(checkPolicies, serviceUrl, connectionTimeOut, proxyHost, proxyPort, proxyUser, proxyPassword, forceCheckAllDependencies, forceUpdate, forceUpdateBuildFailed, updateTypeValue, enableImpactAnalysis, ignoreCertificateCheck, connectionRetries, connectionRetriesIntervals, isSendLogsToWss);
    }

    private OfflineConfiguration getOffline(Properties config) {
        boolean enabled = FSAConfiguration.getBooleanProperty(config, "offline", false);
        boolean zip = FSAConfiguration.getBooleanProperty(config, "offline.zip", false);
        boolean prettyJson = FSAConfiguration.getBooleanProperty(config, "offline.prettyJson", false);
        String wsFolder = StringUtils.isBlank((String)config.getProperty("whiteSourceFolderPath")) ? WHITE_SOURCE_DEFAULT_FOLDER_PATH : config.getProperty("whiteSourceFolderPath");
        return new OfflineConfiguration(enabled, zip, prettyJson, wsFolder);
    }

    private AgentConfiguration getAgent(Properties config) {
        String[] includes = FSAConfiguration.getIncludes(config);
        String[] excludes = config.getProperty("excludes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        String[] dockerIncludes = FSAConfiguration.getDockerIncludes(config);
        String[] dockerExcludes = config.getProperty("docker.excludes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        String[] projectPerFolderIncludes = FSAConfiguration.getProjectPerFolderIncludes(config);
        String[] projectPerFolderExcludes = FSAConfiguration.getProjectPerFolderExcludes(config);
        int archiveExtractionDepth = FSAConfiguration.getArchiveDepth(config);
        String[] archiveIncludes = config.getProperty("archiveIncludes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        String[] archiveExcludes = config.getProperty("archiveExcludes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        String[] pythonRequirementsFileIncludes = FSAConfiguration.getPythonIncludes(config);
        boolean archiveFastUnpack = FSAConfiguration.getBooleanProperty(config, "archiveFastUnpack", false);
        boolean archiveFollowSymbolicLinks = FSAConfiguration.getBooleanProperty(config, "followSymbolicLinks", true);
        boolean dockerScan = FSAConfiguration.getBooleanProperty(config, "docker.scanImages", false);
        boolean partialSha1Match = FSAConfiguration.getBooleanProperty(config, "partialSha1Match", false);
        boolean calculateHints = FSAConfiguration.getBooleanProperty(config, "calculate.hints", false);
        boolean calculateMd5 = FSAConfiguration.getBooleanProperty(config, "calculate.md5", false);
        boolean showProgress = FSAConfiguration.getBooleanProperty(config, "showProgressBar", true);
        Pair<Boolean, String> globalCaseSensitive = this.getGlobalCaseSensitive(config.getProperty("case.sensitive.glob"));
        Collection<String> excludesCopyrights = this.getExcludeCopyrights(config.getProperty("copyright.excludes", ""));
        return new AgentConfiguration(includes, excludes, dockerIncludes, dockerExcludes, archiveExtractionDepth, archiveIncludes, archiveExcludes, archiveFastUnpack, archiveFollowSymbolicLinks, partialSha1Match, calculateHints, calculateMd5, showProgress, globalCaseSensitive.getKey(), dockerScan, excludesCopyrights, projectPerFolderIncludes, projectPerFolderExcludes, pythonRequirementsFileIncludes, globalCaseSensitive.getValue());
    }

    private Collection<String> getExcludeCopyrights(String excludedCopyrightsValue) {
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList(excludedCopyrightsValue.split(",")));
        excludes.remove("");
        return excludes;
    }

    private Pair<Boolean, String> getGlobalCaseSensitive(String globCaseSensitiveValue) {
        boolean globCaseSensitive = false;
        String error = null;
        if (StringUtils.isNotBlank((String)globCaseSensitiveValue)) {
            if (globCaseSensitiveValue.equalsIgnoreCase("true") || globCaseSensitiveValue.equalsIgnoreCase("y")) {
                globCaseSensitive = true;
                error = null;
            } else if (globCaseSensitiveValue.equalsIgnoreCase(FALSE) || globCaseSensitiveValue.equalsIgnoreCase("n")) {
                globCaseSensitive = false;
                error = null;
            } else {
                error = "Bad case.sensitive.glob. Received " + globCaseSensitiveValue + ", required true/false or y/n";
            }
        } else {
            error = null;
        }
        return new Pair<Boolean, Object>(globCaseSensitive, error);
    }

    private ScmConfiguration getScm(Properties config) {
        String type = config.getProperty("scm.type");
        String url = config.getProperty("scm.url");
        String user = config.getProperty("scm.user");
        String pass = config.getProperty("scm.pass");
        String branch = config.getProperty("scm.branch");
        String tag = config.getProperty("scm.tag");
        String ppk = config.getProperty("scm.ppk");
        String repositoriesPath = config.getProperty("scm.repositoriesFile");
        boolean npmInstall = FSAConfiguration.getBooleanProperty(config, "scm.npmInstall", true);
        int npmInstallTimeoutMinutes = FSAConfiguration.getIntProperty(config, "scm.npmInstallTimeoutMinutes", 15);
        return new ScmConfiguration(type, user, pass, ppk, url, branch, tag, repositoriesPath, npmInstall, npmInstallTimeoutMinutes);
    }

    private void initializeDependencyDirsToAppPath(String[] args) {
        boolean wasDir = false;
        for (int i = 0; i < args.length; ++i) {
            HashSet<String> value;
            List<String> paths;
            if (!wasDir && args[i].equals(APP_PATH)) {
                if (i + 3 < args.length && args[i + 2].equals("-d")) {
                    paths = Arrays.asList(args[i + 3].split(","));
                    value = new HashSet();
                    value.addAll(paths);
                    this.appPathsToDependencyDirs.put(args[i + 1], value);
                    i += 3;
                    continue;
                }
                this.errors.add("Error: the '-appPath' parameter must have a following '-d'.");
                return;
            }
            if (wasDir && args[i].equals(APP_PATH)) {
                this.errors.add("Error: the '-appPath' parameter cannot follow the parameter '-d'.");
                break;
            }
            if (!args[i].equals("-d")) continue;
            if (i + 1 < args.length) {
                if (this.appPathsToDependencyDirs.containsKey(DEFAULT_KEY)) {
                    this.appPathsToDependencyDirs.get(DEFAULT_KEY).addAll(Arrays.asList(args[i + 1].split(",")));
                } else {
                    paths = Arrays.asList(args[i + 1].split(","));
                    value = new HashSet<String>();
                    value.addAll(paths);
                    this.appPathsToDependencyDirs.put(DEFAULT_KEY, value);
                }
                ++i;
            } else {
                this.errors.add("Error: there is not path after the '-d' parameter.");
                return;
            }
            wasDir = true;
        }
        if (!wasDir) {
            this.appPathsToDependencyDirs.put(DEFAULT_KEY, new HashSet<String>(this.dependencyDirs));
        }
    }

    public static Pair<Properties, List<String>> readWithError(String configFilePath) {
        Properties configProps = new Properties();
        ArrayList<String> errors = new ArrayList<String>();
        try (FileInputStream inputStream = new FileInputStream(configFilePath);){
            try {
                configProps.load(inputStream);
            }
            catch (FileNotFoundException e) {
                errors.add("Failed to open " + configFilePath + " for reading " + e);
            }
            catch (IOException e) {
                errors.add("Error occurred when reading from " + configFilePath + e);
            }
        }
        catch (IOException e) {
            errors.add("Error occurred when reading from " + configFilePath + " - " + e);
        }
        return new Pair<Properties, List<String>>(configProps, errors);
    }

    public RequestConfiguration getRequest() {
        return this.request;
    }

    public EndPointConfiguration getEndpoint() {
        return this.endpoint;
    }

    public SenderConfiguration getSender() {
        return this.sender;
    }

    public ScmConfiguration getScm() {
        return this.scm;
    }

    public AgentConfiguration getAgent() {
        return this.agent;
    }

    public OfflineConfiguration getOffline() {
        return this.offline;
    }

    public ResolverConfiguration getResolver() {
        return this.resolver;
    }

    public String getScannedFolders() {
        return this.scannedFolders;
    }

    List<String> getErrors() {
        return this.errors;
    }

    public List<String> getOfflineRequestFiles() {
        return this.offlineRequestFiles;
    }

    public String getFileListPath() {
        return this.fileListPath;
    }

    public List<String> getDependencyDirs() {
        return this.dependencyDirs;
    }

    public boolean getUseCommandLineProductName() {
        return this.useCommandLineProductName;
    }

    public boolean getUseCommandLineProjectName() {
        return this.useCommandLineProjectName;
    }

    public List<String> getAppPaths() {
        return this.appPaths;
    }

    public Map<String, Set<String>> getAppPathsToDependencyDirs() {
        return this.appPathsToDependencyDirs;
    }

    @JsonProperty(value="scanPackageManager")
    public boolean isScanProjectManager() {
        return this.scanPackageManager;
    }

    @JsonProperty(value="docker.scanImages")
    public boolean isScanDockerImages() {
        return this.scanDockerImages;
    }

    @JsonProperty(value="log.level")
    public String getLogLevel() {
        return this.logLevel;
    }

    public static int getIntProperty(Properties config, String propertyKey, int defaultValue) {
        int value = defaultValue;
        String propertyValue = config.getProperty(propertyKey);
        if (StringUtils.isNotBlank((String)propertyValue)) {
            try {
                value = Integer.valueOf(propertyValue);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            value = config.get(propertyKey) != null ? (Integer)config.get(propertyKey) : value;
        }
        return value;
    }

    public static boolean getBooleanProperty(Properties config, String propertyKey, boolean defaultValue) {
        boolean property = defaultValue;
        String propertyValue = config.getProperty(propertyKey);
        if (StringUtils.isNotBlank((String)propertyValue)) {
            property = Boolean.valueOf(propertyValue);
        }
        return property;
    }

    public static long getLongProperty(Properties config, String propertyKey, long defaultValue) {
        long property = defaultValue;
        String propertyValue = config.getProperty(propertyKey);
        if (StringUtils.isNotBlank((String)propertyValue)) {
            property = Long.parseLong(propertyValue);
        }
        return property;
    }

    public static String[] getListProperty(Properties config, String propertyName, String[] defaultValue) {
        String property = config.getProperty(propertyName);
        if (property == null) {
            return defaultValue;
        }
        return property.split(" ");
    }

    public static int getArchiveDepth(Properties configProps) {
        return FSAConfiguration.getIntProperty(configProps, "archiveExtractionDepth", 0);
    }

    public static String[] getIncludes(Properties configProps) {
        String includesString = configProps.getProperty("includes", "");
        if (StringUtils.isNotBlank((String)includesString)) {
            return configProps.getProperty("includes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        }
        return new String[0];
    }

    private static String[] getPythonIncludes(Properties configProps) {
        String includesString = configProps.getProperty("python.requirementsFileIncludes", "requirements.txt");
        if (StringUtils.isNotBlank((String)includesString)) {
            return configProps.getProperty("python.requirementsFileIncludes", "requirements.txt").split(" ");
        }
        return new String[0];
    }

    public static String[] getProjectPerFolderIncludes(Properties configProps) {
        String projectPerFolderIncludesString = configProps.getProperty("projectPerFolderIncludes", null);
        if (StringUtils.isNotBlank((String)projectPerFolderIncludesString)) {
            return configProps.getProperty("projectPerFolderIncludes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        }
        if ("".equals(projectPerFolderIncludesString)) {
            return null;
        }
        String[] result = new String[]{"*"};
        return result;
    }

    public static String[] getProjectPerFolderExcludes(Properties configProps) {
        String projectPerFolderExcludesString = configProps.getProperty("projectPerFolderExcludes", "");
        if (StringUtils.isNotBlank((String)projectPerFolderExcludesString)) {
            return configProps.getProperty("projectPerFolderExcludes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        }
        return new String[0];
    }

    public static String[] getDockerIncludes(Properties configProps) {
        String includesString = configProps.getProperty("docker.includes", "");
        if (StringUtils.isNotBlank((String)includesString)) {
            return configProps.getProperty("docker.includes", "").split(INCLUDES_EXCLUDES_SEPARATOR_REGEX);
        }
        return new String[0];
    }

    public List<String> getRequirementsFileIncludes() {
        return this.requirementsFileIncludes;
    }

    private List<String> updateProperties(Properties configProps, CommandLineArgs commandLineArgs) {
        this.readPropertyFromCommandLine(configProps, "apiKey", commandLineArgs.apiKey);
        this.readPropertyFromCommandLine(configProps, "updateType", commandLineArgs.updateType);
        this.readPropertyFromCommandLine(configProps, "productName", commandLineArgs.product);
        this.readPropertyFromCommandLine(configProps, "productVersion", commandLineArgs.productVersion);
        this.readPropertyFromCommandLine(configProps, "projectVersion", commandLineArgs.projectVersion);
        this.readPropertyFromCommandLine(configProps, "userKey", commandLineArgs.userKey);
        this.readPropertyFromCommandLine(configProps, "projectToken", commandLineArgs.projectToken);
        this.readPropertyFromCommandLine(configProps, "productToken", commandLineArgs.productToken);
        this.readPropertyFromCommandLine(configProps, "log.level", commandLineArgs.logLevel);
        LinkedList<String> offlineRequestFiles = new LinkedList<String>();
        offlineRequestFiles.addAll(commandLineArgs.requestFiles);
        if (offlineRequestFiles.size() > 0) {
            configProps.put("offline", FALSE);
        }
        this.readPropertyFromCommandLine(configProps, "offline", commandLineArgs.offline);
        this.readListFromCommandLine(configProps, "appPath", commandLineArgs.appPath);
        this.readPropertyFromCommandLine(configProps, "viaDebug", commandLineArgs.viaDebug);
        this.readPropertyFromCommandLine(configProps, "viaAnalysysLevel", commandLineArgs.viaLevel);
        this.readPropertyFromCommandLine(configProps, "enableImpactAnalysis", commandLineArgs.enableImpactAnalysis);
        this.readPropertyFromCommandLine(configProps, "iaLanguage", commandLineArgs.iaLanguage);
        this.readPropertyFromCommandLine(configProps, "xPaths", commandLineArgs.xPaths);
        this.readPropertyFromCommandLine(configProps, "proxy.host", commandLineArgs.proxyHost);
        this.readPropertyFromCommandLine(configProps, "proxy.port", commandLineArgs.proxyPort);
        this.readPropertyFromCommandLine(configProps, "proxy.user", commandLineArgs.proxyUser);
        this.readPropertyFromCommandLine(configProps, "proxy.pass", commandLineArgs.proxyPass);
        this.readPropertyFromCommandLine(configProps, "archiveFastUnpack", commandLineArgs.archiveFastUnpack);
        this.readPropertyFromCommandLine(configProps, "projectPerFolder", commandLineArgs.projectPerFolder);
        this.readPropertyFromCommandLine(configProps, "scm.repositoriesFile", commandLineArgs.repositoriesFile);
        return offlineRequestFiles;
    }

    private void readPropertyFromCommandLine(Properties configProps, String propertyKey, String propertyValue) {
        if (StringUtils.isNotBlank((String)propertyValue)) {
            configProps.put(propertyKey, propertyValue);
        }
    }

    private void readListFromCommandLine(Properties configProps, String propertyKey, List<String> propertyValue) {
        if (!propertyValue.isEmpty()) {
            configProps.put(propertyKey, propertyValue);
        }
    }

    private void commandLineArgsOverride(CommandLineArgs commandLineArgs) {
        this.useCommandLineProductName = commandLineArgs != null && StringUtils.isNotBlank((String)commandLineArgs.product);
        this.useCommandLineProjectName = commandLineArgs != null && StringUtils.isNotBlank((String)commandLineArgs.project);
    }

    public void validate() {
        this.getErrors().clear();
        this.errors.addAll(this.configurationValidation.getConfigurationErrors(this.getRequest().isProjectPerSubFolder(), this.getRequest().getProjectToken(), this.getRequest().getProjectName(), this.getRequest().getApiToken(), this.configFilePath, this.getAgent().getArchiveExtractionDepth(), this.getAgent().getIncludes(), this.getAgent().getProjectPerFolderIncludes(), this.getAgent().getPythonRequirementsFileIncludes()));
    }
}

