/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.contracts.PluginInfo;
import org.whitesource.fs.Main;

public class FileSystemAgentInfo
implements PluginInfo {
    private final Logger logger = LoggerFactory.getLogger(FileSystemAgentInfo.class);
    private static final String AGENT_TYPE = "fs-agent";
    private static final String AGENTS_VERSION = "agentsVersion";
    private Properties artifactProperties = this.getArtifactProperties();

    @Override
    public String getAgentType() {
        return AGENT_TYPE;
    }

    @Override
    public String getAgentVersion() {
        return this.getResource(AGENTS_VERSION);
    }

    @Override
    public String getPluginVersion() {
        return this.getResource("version");
    }

    private String getResource(String propertyName) {
        String val = this.artifactProperties.getProperty(propertyName);
        if (StringUtils.isNotBlank((String)val)) {
            return val;
        }
        return "";
    }

    private Properties getArtifactProperties() {
        Properties properties = new Properties();
        try (InputStream stream = Main.class.getResourceAsStream("/project.properties");){
            properties.load(stream);
        }
        catch (IOException e) {
            this.logger.error("Failed to get version ", (Throwable)e);
        }
        return properties;
    }
}

