/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.LoggerFactory;

public class LogMapAppender
extends AppenderBase<ILoggingEvent> {
    private ConcurrentSkipListMap<Long, ILoggingEvent> logEvents = new ConcurrentSkipListMap();
    private Level rootLevel;

    protected void append(ILoggingEvent iLoggingEvent) {
        long timeStamp = iLoggingEvent.getTimeStamp();
        while (this.logEvents.get(timeStamp) != null) {
            ++timeStamp;
        }
        this.logEvents.put(timeStamp, iLoggingEvent);
        Logger logsSet = (Logger)LoggerFactory.getLogger((String)"org.whitesource");
        logsSet.setAdditive(iLoggingEvent.getLevel().levelInt >= this.rootLevel.levelInt);
    }

    public ConcurrentSkipListMap getLogEvents() {
        return this.logEvents;
    }

    public void setRootLevel(Level rootLevel) {
        this.rootLevel = rootLevel;
    }
}

