/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.JCommander;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.ProjectsSender;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.Coordinates;
import org.whitesource.agent.utils.Pair;
import org.whitesource.fs.CommandLineArgs;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.FileSystemAgentInfo;
import org.whitesource.fs.LogMapAppender;
import org.whitesource.fs.OfflineReader;
import org.whitesource.fs.ProjectsCalculator;
import org.whitesource.fs.ProjectsDetails;
import org.whitesource.fs.StatusCode;
import org.whitesource.fs.configuration.ConfigurationSerializer;
import org.whitesource.fs.configuration.RequestConfiguration;
import org.whitesource.web.FsaVerticle;

public class Main {
    protected static final String LOGBACK_FSA_XML = "logback-FSA.xml";
    public static Logger logger;
    public static final long MAX_TIMEOUT = 3600000L;
    private static ProjectsSender projectsSender;
    private static Vertx vertx;
    public static int exitCode;
    ProjectsCalculator projectsCalculator = new ProjectsCalculator();
    public static final String HELP_CONTENT_FILE_NAME = "helpContent.txt";

    public static void main(String[] args) {
        int exitCode = Main.mainScan(args);
        System.exit(exitCode);
    }

    private static int mainScan(String[] args) {
        CommandLineArgs commandLineArgs = new CommandLineArgs();
        if (Main.isHelpArg(args)) {
            Main.printHelpContent();
            System.exit(StatusCode.SUCCESS.getValue());
        }
        new JCommander((Object)commandLineArgs, args);
        FSAConfiguration fsaConfiguration = new FSAConfiguration(args);
        Main.setLoggerConfiguration(fsaConfiguration.getLogLevel());
        boolean isStandalone = commandLineArgs.web.equals("false");
        logger.info(fsaConfiguration.toString());
        if (fsaConfiguration.getSender().isSendLogsToWss()) {
            logger.info("-----------------------------------------------------------------------------");
            logger.info("'sendLogsToWss' parameter is enabled");
            logger.info("Data of your scan will be sent to WhiteSource for diagnostic purposes");
            logger.info("-----------------------------------------------------------------------------");
        }
        if (isStandalone) {
            StatusCode processExitCode;
            try {
                if (fsaConfiguration.getErrors() == null || fsaConfiguration.getErrors().size() > 0) {
                    processExitCode = StatusCode.ERROR;
                    fsaConfiguration.getErrors().forEach(error -> logger.error(error));
                    logger.warn("Exiting");
                } else {
                    processExitCode = new Main().scanAndSend(fsaConfiguration, true).getStatusCode();
                }
            }
            catch (Exception e) {
                logger.warn("Process encountered an error: {}" + e.getMessage(), (Throwable)e);
                processExitCode = StatusCode.ERROR;
            }
            logger.info("Process finished with exit code {} ({})", (Object)processExitCode.name(), (Object)processExitCode.getValue());
            exitCode = Main.getValue(processExitCode);
        } else {
            vertx = Vertx.vertx((VertxOptions)new VertxOptions().setBlockedThreadCheckInterval(3600000L));
            JsonObject config = new JsonObject();
            config.put("configuration", new ConfigurationSerializer<FSAConfiguration>().getAsString(fsaConfiguration, false));
            DeploymentOptions options = new DeploymentOptions().setConfig(config).setWorker(true);
            vertx.deployVerticle(FsaVerticle.class.getName(), options);
        }
        return exitCode;
    }

    private static int getValue(StatusCode processExitCode) {
        return processExitCode.getValue();
    }

    private static void setLoggerConfiguration(String logLevel) {
        System.setProperty("logback.configurationFile", LOGBACK_FSA_XML);
        logger = LoggerFactory.getLogger(Main.class);
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        ch.qos.logback.classic.Logger mapLog = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"org.whitesource");
        root.setLevel(Level.toLevel((String)logLevel, (Level)Level.INFO));
        ((LogMapAppender)mapLog.getAppender("collectToMap")).setRootLevel(root.getLevel());
    }

    public ProjectsDetails scanAndSend(FSAConfiguration fsaConfiguration, boolean shouldSend) {
        if (fsaConfiguration.getErrors() != null && fsaConfiguration.getErrors().size() > 0) {
            return new ProjectsDetails(new ArrayList<AgentProjectInfo>(), StatusCode.ERROR, String.join((CharSequence)System.lineSeparator(), fsaConfiguration.getErrors()));
        }
        ProjectsDetails result = this.projectsCalculator.getAllProjects(fsaConfiguration);
        OfflineReader offlineReader = new OfflineReader();
        Collection<UpdateInventoryRequest> updateInventoryRequests = offlineReader.getAgentProjectsFromRequests(fsaConfiguration.getOfflineRequestFiles());
        Collection offlineProjects = updateInventoryRequests.stream().flatMap(updateInventoryRequest -> updateInventoryRequest.getProjects().stream()).collect(Collectors.toList());
        if (fsaConfiguration.getOfflineRequestFiles() != null) {
            result.addOfflineProjects(offlineProjects);
        }
        if (fsaConfiguration.getUseCommandLineProjectName()) {
            String projectName = fsaConfiguration.getRequest().getProjectName();
            HashSet<AgentProjectInfo> agentProjectInfos = new HashSet<AgentProjectInfo>();
            for (AgentProjectInfo projectInfo : result.getProjectToViaComponents().keySet()) {
                agentProjectInfos.add(projectInfo);
            }
            if (agentProjectInfos.size() == 1 && projectName != null) {
                for (AgentProjectInfo project : agentProjectInfos) {
                    project.getCoordinates().setArtifactId(projectName);
                }
            }
        }
        RequestConfiguration req = fsaConfiguration.getRequest();
        if (fsaConfiguration != null && !fsaConfiguration.getUseCommandLineProductName() && updateInventoryRequests.size() > 0) {
            UpdateInventoryRequest offLineReq = updateInventoryRequests.stream().findFirst().get();
            req = new RequestConfiguration(req.getApiToken(), req.getUserKey(), req.getRequesterEmail(), req.isProjectPerSubFolder(), req.getProjectName(), req.getProjectToken(), req.getProjectVersion(), offLineReq.product(), null, offLineReq.productVersion(), req.getAppPaths(), req.getViaDebug(), req.getViaAnalysisLevel(), req.getIaLanguage());
        }
        if (!result.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
            return new ProjectsDetails(result.getProjects(), result.getStatusCode(), "");
        }
        if (shouldSend) {
            ProjectsSender projectsSender = this.getProjectsSender(fsaConfiguration, req);
            Pair<String, StatusCode> processExitCode = this.sendProjects(projectsSender, result);
            logger.debug("Process finished with exit code {} ({})", (Object)processExitCode.getKey(), (Object)processExitCode.getValue());
            return new ProjectsDetails(new ArrayList<AgentProjectInfo>(), processExitCode.getValue(), processExitCode.getKey());
        }
        return new ProjectsDetails(result.getProjects(), result.getStatusCode(), "");
    }

    private ProjectsSender getProjectsSender(FSAConfiguration fsaConfiguration, RequestConfiguration req) {
        ProjectsSender projectsSender = !this.projectSenderExist() ? new ProjectsSender(fsaConfiguration.getSender(), fsaConfiguration.getOffline(), req, new FileSystemAgentInfo()) : Main.projectsSender;
        return projectsSender;
    }

    private Pair<String, StatusCode> sendProjects(ProjectsSender projectsSender, ProjectsDetails projectsDetails) {
        Collection<AgentProjectInfo> projects = projectsDetails.getProjects();
        Iterator<AgentProjectInfo> iterator = projects.iterator();
        while (iterator.hasNext()) {
            AgentProjectInfo project = iterator.next();
            if (!project.getDependencies().isEmpty()) continue;
            iterator.remove();
            Coordinates coordinates = project.getCoordinates();
            String projectIdentifier = coordinates == null ? project.getProjectToken() : coordinates.getArtifactId();
            logger.info("Removing empty project {} from update (found 0 matching files)", (Object)projectIdentifier);
        }
        if (projects.isEmpty()) {
            logger.info("Exiting, nothing to update");
            return new Pair<String, StatusCode>("Exiting, nothing to update", StatusCode.SUCCESS);
        }
        return projectsSender.sendRequest(projectsDetails);
    }

    private static boolean isHelpArg(String[] args) {
        for (String arg : args) {
            if (!"-help".equals(arg) && !"-h".equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static void printHelpContent() {
        logger = LoggerFactory.getLogger(Main.class);
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            ClassLoader classLoader = Main.class.getClassLoader();
            inputStream = classLoader.getResourceAsStream(HELP_CONTENT_FILE_NAME);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String result = "";
            String line = bufferedReader.readLine();
            while (line != null) {
                result = result + line + System.lineSeparator();
                line = bufferedReader.readLine();
            }
            logger.info(result);
        }
        catch (IOException e) {
            logger.warn("Could not show the help command");
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException e) {
            logger.warn("Could not close the help file");
        }
    }

    private boolean projectSenderExist() {
        return projectsSender != null;
    }

    protected static void endToEndIntegration(String[] args, ProjectsSender testProjectsSender) {
        projectsSender = testProjectsSender;
        Main.mainScan(args);
    }

    static {
        projectsSender = null;
        exitCode = 0;
    }
}

