/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.scm;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.utils.FilesUtils;
import org.whitesource.fs.FsUtils;
import org.whitesource.scm.GitConnector;
import org.whitesource.scm.MercurialConnector;
import org.whitesource.scm.ScmType;
import org.whitesource.scm.SvnConnector;

public abstract class ScmConnector {
    private final Logger logger = LoggerFactory.getLogger(ScmConnector.class);
    public static final String SCM_CONNECTOR_TMP_DIRECTORY = Paths.get(FsUtils.getTmpDir(), "WhiteSource-ScmConnector").toString();
    public static final String MASTER = "master";
    private final String username;
    private final String password;
    private final String url;
    private final String branch;
    private final String tag;
    private final String privateKey;
    private File cloneDirectory;

    protected ScmConnector(String username, String password, String url, String branch, String tag, String privateKey) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.branch = branch;
        this.tag = tag;
        this.privateKey = privateKey;
    }

    public static ScmConnector create(String scmType, String url, String privateKey, String username, String password, String branch, String tag) {
        ScmConnector scmConnector = null;
        if (StringUtils.isNotBlank((String)scmType)) {
            ScmType type = ScmType.getValue(scmType);
            if (type == null) {
                throw new IllegalArgumentException("Invalid scm type, please select git / svn / mercurial");
            }
            if (StringUtils.isBlank((String)url)) {
                throw new IllegalArgumentException("No scm link provided");
            }
            switch (type) {
                case GIT: {
                    scmConnector = new GitConnector(privateKey, username, password, url, branch, tag);
                    break;
                }
                case SVN: {
                    scmConnector = new SvnConnector(username, password, url, branch, tag);
                    break;
                }
                case MERCURIAL: {
                    scmConnector = new MercurialConnector(username, password, url, branch, tag);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported scm type");
                }
            }
        }
        return scmConnector;
    }

    public File cloneRepository() {
        this.cloneDirectory = new File(SCM_CONNECTOR_TMP_DIRECTORY, this.getType().toString().toLowerCase() + "_" + this.getUrlName() + "_" + this.getBranch());
        FilesUtils.deleteDirectory(this.cloneDirectory);
        this.logger.info("Cloning repository {} ...this may take a few minutes", (Object)this.getUrl());
        File branchDirectory = this.cloneRepository(this.cloneDirectory);
        return branchDirectory;
    }

    public void deleteCloneDirectory() {
        FilesUtils.deleteDirectory(this.cloneDirectory);
    }

    protected abstract File cloneRepository(File var1);

    public abstract ScmType getType();

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlName() {
        return this.url.substring(this.url.lastIndexOf(47) + 1, this.url.length());
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTag() {
        return this.tag;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }
}

