/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin;

import com.cx.plugin.dto.ScanResults;
import com.cx.plugin.utils.CxPluginUtils;
import com.cx.restclient.CxShragaClient;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ThresholdResult;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.SASTResults;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.MavenLoggerAdapter;

@Mojo(name="scan", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST, inheritByDefault=false)
public class CxScanPlugin
extends AbstractMojo {
    public static final String SOURCES_ZIP_NAME = "sources";
    private static Logger log = LoggerFactory.getLogger(CxScanPlugin.class);
    @Parameter(required=true, property="cx.username")
    private String username;
    @Parameter(required=true, property="cx.password")
    private String password;
    @Parameter(defaultValue="http://localhost", property="cx.url")
    private URL url;
    @Parameter(defaultValue="${project.name}", property="cx.projectName")
    private String projectName;
    @Parameter(property="cx.fullTeamPath", defaultValue="\\CxServer")
    private String fullTeamPath;
    @Parameter(defaultValue="Checkmarx Default", property="cx.preset")
    private String preset;
    @Parameter(defaultValue="true", property="cx.isIncrementalScan")
    private boolean isIncrementalScan;
    @Parameter(property="cx.comment")
    private String comment;
    @Parameter(property="cx.folderExclusions")
    private String[] folderExclusions = new String[0];
    @Parameter(property="cx.fileExclusions")
    private String[] fileExclusions = new String[0];
    @Parameter(defaultValue="true", property="cx.isSynchronous")
    private boolean isSynchronous;
    @Parameter(defaultValue="true", property="cx.generatePDFReport")
    private boolean generatePDFReport;
    @Parameter(defaultValue="-1", property="cx.highSeveritiesThreshold")
    private int highSeveritiesThreshold;
    @Parameter(defaultValue="-1", property="cx.mediumSeveritiesThreshold")
    private int mediumSeveritiesThreshold;
    @Parameter(defaultValue="-1", property="cx.lowSeveritiesThreshold")
    private int lowSeveritiesThreshold;
    @Parameter(defaultValue="0", property="cx.scanTimeoutInMinutes")
    private int scanTimeoutInMinutes;
    @Parameter(defaultValue="false", property="cx.osaEnabled")
    private boolean osaEnabled;
    @Deprecated
    @Parameter(property="cx.osaExclusions")
    private String[] osaExclusions = new String[0];
    @Parameter(property="cx.osaIgnoreScopes")
    private String[] osaIgnoreScopes = new String[0];
    @Parameter(defaultValue="-1", property="cx.osaHighSeveritiesThreshold")
    private int osaHighSeveritiesThreshold;
    @Parameter(defaultValue="-1", property="cx.osaMediumSeveritiesThreshold")
    private int osaMediumSeveritiesThreshold;
    @Parameter(defaultValue="-1", property="cx.osaLowSeveritiesThreshold")
    private int osaLowSeveritiesThreshold;
    @Deprecated
    @Parameter(defaultValue="true", property="cx.osaGeneratePDFReport")
    private boolean osaGeneratePDFReport;
    @Deprecated
    @Parameter(defaultValue="true", property="cx.osaGenerateHTMLReport")
    private boolean osaGenerateHTMLReport;
    @Parameter(defaultValue="true", property="cx.osaGenerateJsonReport")
    private boolean osaGenerateJsonReport;
    @Parameter(defaultValue="${project.build.directory}/checkmarx", property="cx.outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="false", property="cx.disableCertificateVerification")
    private boolean disableCertificateVerification;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;
    private String pluginVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenLoggerAdapter.setLogger(this.getLog());
        CxPluginUtils.printLogo(log);
        CxShragaClient shraga = null;
        boolean sastCreated = false;
        boolean osaCreated = false;
        try {
            ThresholdResult thresholdResult;
            PluginDescriptor pd = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
            if (pd != null) {
                this.pluginVersion = pd.getVersion();
            }
            CxScanConfig config = this.resolveConfigurationMap();
            CxPluginUtils.printConfiguration(config, this.osaIgnoreScopes, this.pluginVersion, log);
            if (!config.getSastEnabled().booleanValue() && !config.getOsaEnabled().booleanValue()) {
                throw new MojoFailureException("Both SAST and OSA are disabled. exiting");
            }
            ScanResults ret = new ScanResults(new SASTResults(), new OSAResults());
            try {
                shraga = new CxShragaClient(config, log);
                shraga.init();
            }
            catch (Exception ex) {
                if (ex.getMessage().contains("Server is unavailable")) {
                    try {
                        shraga.login();
                    }
                    catch (CxClientException e) {
                        throw new MojoFailureException(e.getMessage());
                    }
                    String errorMsg = "Connection Failed.\nValidate the provided login credentials and server URL are correct.\nIn addition, make sure the installed plugin version is compatible with the CxSAST version according to CxSAST release notes.";
                    throw new MojoFailureException(ex.getMessage() + ": " + errorMsg);
                }
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (config.getSastEnabled().booleanValue()) {
                try {
                    log.info("Zipping sources");
                    File zipFile = CxPluginUtils.zipSources(this.reactorProjects, this.zipArchiver, this.outputDirectory, log);
                    config.setZipFile(zipFile);
                    shraga.createSASTScan();
                    sastCreated = true;
                }
                catch (CxClientException | IOException e) {
                    ret.setSastCreateException((Exception)e);
                    log.error(e.getMessage());
                }
            }
            if (config.getOsaEnabled().booleanValue()) {
                File dummyFileForOSA = null;
                try {
                    dummyFileForOSA = this.createDummyFileForOSA();
                    Properties scannerProperties = CxPluginUtils.generateOSAScanConfiguration(this.project.getBasedir().getAbsolutePath(), this.osaIgnoreScopes, dummyFileForOSA.getName());
                    shraga.setOsaFSAProperties(scannerProperties);
                    shraga.createOSAScan();
                    osaCreated = true;
                }
                catch (CxClientException | IOException e) {
                    ret.setOsaCreateException((Exception)e);
                    log.warn(e.getMessage());
                }
                finally {
                    FileUtils.deleteQuietly((File)dummyFileForOSA);
                }
            }
            if (!config.getSynchronous().booleanValue()) {
                if (ret.getSastCreateException() != null) {
                    throw new MojoExecutionException(ret.getSastCreateException().getMessage());
                }
                if (ret.getOsaCreateException() != null) {
                    throw new MojoExecutionException(ret.getOsaCreateException().getMessage());
                }
                log.info("Running in Asynchronous mode. Not waiting for scan to finish");
                return;
            }
            if (sastCreated) {
                try {
                    SASTResults sastResults = shraga.waitForSASTResults();
                    ret.setSastResults(sastResults);
                }
                catch (InterruptedException e) {
                    if (config.getSynchronous().booleanValue()) {
                        this.cancelScan(shraga);
                    }
                    throw e;
                }
                catch (CxClientException | IOException e) {
                    ret.setSastWaitException((Exception)e);
                    log.error(e.getMessage());
                }
            }
            if (osaCreated) {
                try {
                    OSAResults osaResults = shraga.waitForOSAResults();
                    ret.setOsaResults(osaResults);
                }
                catch (CxClientException | IOException e) {
                    ret.setOsaWaitException((Exception)e);
                    log.error(e.getMessage());
                }
            }
            if ((thresholdResult = shraga.getThresholdResult()).isFail() || ret.getSastWaitException() != null || ret.getSastCreateException() != null || ret.getOsaCreateException() != null || ret.getOsaWaitException() != null) {
                CxPluginUtils.assertBuildFailure(thresholdResult.getFailDescription(), ret);
            }
        }
        catch (InterruptedException e) {
            log.error("Interrupted exception: " + e.getMessage(), (Throwable)e);
            if (shraga != null && sastCreated) {
                log.error("Canceling scan on the Checkmarx server...");
                this.cancelScan(shraga);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected exception: " + e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            if (shraga != null) {
                shraga.close();
            }
        }
    }

    private File createDummyFileForOSA() throws IOException {
        String dummyFilename = "dummy" + RandomStringUtils.randomNumeric((int)4) + ".java";
        File file = new File(this.project.getBasedir().getAbsolutePath(), dummyFilename);
        file.createNewFile();
        return file;
    }

    private void cancelScan(CxShragaClient shraga) {
        try {
            shraga.cancelSASTScan();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CxScanConfig resolveConfigurationMap() {
        CxScanConfig scanConfig = new CxScanConfig();
        scanConfig.setCxOrigin("Maven");
        scanConfig.setSastEnabled(Boolean.valueOf(true));
        scanConfig.setDisableCertificateValidation(this.disableCertificateVerification);
        scanConfig.setUsername(this.username);
        scanConfig.setPassword(this.password);
        scanConfig.setUrl(this.url.toString());
        scanConfig.setReportsDir(this.outputDirectory);
        scanConfig.setProjectName(this.projectName);
        scanConfig.setTeamPath(this.fullTeamPath);
        scanConfig.setPresetName(this.preset);
        scanConfig.setSastScanTimeoutInMinutes(Integer.valueOf(this.scanTimeoutInMinutes));
        scanConfig.setScanComment(this.comment);
        scanConfig.setIncremental(Boolean.valueOf(this.isIncrementalScan));
        scanConfig.setSynchronous(Boolean.valueOf(this.isSynchronous));
        boolean thresholdEnabled = this.highSeveritiesThreshold > 0 || this.mediumSeveritiesThreshold > 0 || this.lowSeveritiesThreshold > 0;
        scanConfig.setSastThresholdsEnabled(Boolean.valueOf(thresholdEnabled));
        scanConfig.setSastHighThreshold(Integer.valueOf(this.highSeveritiesThreshold));
        scanConfig.setSastMediumThreshold(Integer.valueOf(this.mediumSeveritiesThreshold));
        scanConfig.setSastLowThreshold(Integer.valueOf(this.lowSeveritiesThreshold));
        scanConfig.setGeneratePDFReport(Boolean.valueOf(this.generatePDFReport));
        scanConfig.setOsaEnabled(Boolean.valueOf(this.osaEnabled));
        boolean osaThresholdEnabled = this.highSeveritiesThreshold > 0 || this.mediumSeveritiesThreshold > 0 || this.lowSeveritiesThreshold > 0;
        scanConfig.setOsaGenerateJsonReport(Boolean.valueOf(this.osaGenerateJsonReport));
        scanConfig.setOsaThresholdsEnabled(Boolean.valueOf(osaThresholdEnabled));
        scanConfig.setOsaHighThreshold(Integer.valueOf(this.osaHighSeveritiesThreshold));
        scanConfig.setOsaMediumThreshold(Integer.valueOf(this.osaMediumSeveritiesThreshold));
        scanConfig.setOsaLowThreshold(Integer.valueOf(this.osaLowSeveritiesThreshold));
        return scanConfig;
    }
}

