/*
 * Decompiled with CFR 0.152.
 */
package com.cx.plugin.utils;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ScanResults;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.slf4j.Logger;

public abstract class CxPluginUtils {
    private static final String[] SUPPORTED_SUFFIX = new String[]{".java", ".cpp", ".c++", ".cxx", ".hpp", ".hh", ".h++", ".hxx", ".c", "cc", "h"};
    private static boolean containFileExt = false;

    public static void printLogo(Logger log) {
        log.info("                                            \n         CxCxCxCxCxCxCxCxCxCxCxC            \n        CxCxCxCxCxCxCxCxCxCxCxCxCx          \n       CxCxCxCxCxCxCxCxCxCxCxCxCxCx         \n      CxCxCx                CxCxCxCx        \n      CxCxCx                CxCxCxCx        \n      CxCxCx  CxCxCx      CxCxCxCxC         \n      CxCxCx  xCxCxCx  .CxCxCxCxCx          \n      CxCxCx   xCxCxCxCxCxCxCxCx            \n      CxCxCx    xCxCxCxCxCxCx               \n      CxCxCx     CxCxCxCxCx   CxCxCx        \n      CxCxCx       xCxCxC     CxCxCx        \n      CxCxCx                 CxCxCx         \n       CxCxCxCxCxCxCxCxCxCxCxCxCxCx         \n        CxCxCxCxCxCxCxCxCxCxCxCxCx          \n          CxCxCxCxCxCxCxCxCxCxCx            \n                                            \n            C H E C K M A R X               \n");
    }

    public static void printConfiguration(CxScanConfig config, String[] osaIgnoreScopes, String pluginVersion, Logger log) {
        log.info("---------------------------------------Configurations:------------------------------------");
        log.info("Maven plugin version: " + pluginVersion);
        log.info("Username: " + config.getUsername());
        log.info("URL: " + config.getUrl());
        log.info("Project name: " + config.getProjectName());
        log.info("outputDirectory: " + config.getReportsDir());
        log.info("Deny project creation: " + config.getDenyProject());
        log.info("Scan timeout in minutes: " + (config.getSastScanTimeoutInMinutes() <= 0 ? "" : config.getSastScanTimeoutInMinutes()));
        log.info("Full team path: " + config.getTeamPath());
        log.info("Preset: " + config.getPresetName());
        log.info("Is incremental scan: " + config.getIncremental());
        log.info("Folder exclusions: " + config.getSastFolderExclusions());
        log.info("Is synchronous scan: " + config.getSynchronous());
        log.info("Generate PDF report: " + config.getGeneratePDFReport());
        log.info("Policy violations enabled: " + config.getEnablePolicyViolations());
        log.info("CxSAST thresholds enabled: " + config.getSastThresholdsEnabled());
        if (config.getSastThresholdsEnabled().booleanValue()) {
            log.info("CxSAST high threshold: " + (config.getSastHighThreshold() == null ? "[No Threshold]" : config.getSastHighThreshold()));
            log.info("CxSAST medium threshold: " + (config.getSastMediumThreshold() == null ? "[No Threshold]" : config.getSastMediumThreshold()));
            log.info("CxSAST low threshold: " + (config.getSastLowThreshold() == null ? "[No Threshold]" : config.getSastLowThreshold()));
        }
        log.info("CxOSA enabled: " + config.getOsaEnabled());
        if (config.getOsaEnabled().booleanValue()) {
            log.info("osaIgnoreScopes: " + Arrays.toString(osaIgnoreScopes));
            log.info("CxOSA thresholds enabled: " + config.getOsaThresholdsEnabled());
            if (config.getOsaThresholdsEnabled().booleanValue()) {
                log.info("CxOSA high threshold: " + (config.getOsaHighThreshold() == null ? "[No Threshold]" : config.getOsaHighThreshold()));
                log.info("CxOSA medium threshold: " + (config.getOsaMediumThreshold() == null ? "[No Threshold]" : config.getOsaMediumThreshold()));
                log.info("CxOSA low threshold: " + (config.getOsaLowThreshold() == null ? "[No Threshold]" : config.getOsaLowThreshold()));
            }
        }
        log.info("------------------------------------------------------------------------------------------");
    }

    public static void assertBuildFailure(String thDescription, ScanResults ret) throws MojoFailureException {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        builder.append("*****The Build Failed for the Following Reasons: *****");
        CxPluginUtils.appendError(ret.getGeneralException(), builder);
        CxPluginUtils.appendError(ret.getSastCreateException(), builder);
        CxPluginUtils.appendError(ret.getSastWaitException(), builder);
        CxPluginUtils.appendError(ret.getOsaCreateException(), builder);
        CxPluginUtils.appendError(ret.getOsaWaitException(), builder);
        for (String s : lines = thDescription.split("\\n")) {
            builder.append(s);
        }
        builder.append("-----------------------------------------------------------------------------------------\n");
        throw new MojoFailureException(builder.toString());
    }

    private static StringBuilder appendError(Exception ex, StringBuilder builder) {
        if (ex != null) {
            builder.append(ex.getMessage()).append("\\n");
        }
        return builder;
    }

    public static Integer resolveInt(String value, Logger log) {
        Integer inti = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            try {
                inti = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                log.warn("failed to parse integer value: " + value);
            }
        }
        return inti;
    }

    public static File zipSources(List<MavenProject> projects, ZipArchiver zipArchiver, File outputDirectory, Logger log) throws MojoExecutionException {
        for (MavenProject p : projects) {
            MavenProject subProject = CxPluginUtils.getProject(p);
            if ("pom".equals(subProject.getPackaging())) continue;
            String prefix = subProject.getName() + "\\";
            List compileSourceRoots = subProject.getCompileSourceRoots();
            File sourceDir = subProject.getBasedir();
            for (Object c : compileSourceRoots) {
                sourceDir = new File((String)c);
                if (!sourceDir.exists() || !CxPluginUtils.isContainFileExt(sourceDir)) continue;
                zipArchiver.addDirectory(sourceDir, prefix);
            }
            File[] webappDir = sourceDir.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String fileName) {
                    return fileName.endsWith("webapp");
                }
            });
            if (webappDir != null && webappDir.length > 0 && webappDir[0].exists()) {
                zipArchiver.addDirectory(webappDir[0], prefix);
            }
            List reSourceRoots = subProject.getResources();
            for (Object c : reSourceRoots) {
                Resource resource = (Resource)c;
                File resourceDir = new File(resource.getDirectory());
                if (!resourceDir.exists()) continue;
                zipArchiver.addDirectory(resourceDir, prefix);
            }
            List scriptSourceRoots = subProject.getScriptSourceRoots();
            for (Object c : scriptSourceRoots) {
                File scriptDir = new File((String)c);
                if (!scriptDir.exists()) continue;
                zipArchiver.addDirectory(scriptDir, prefix);
            }
        }
        zipArchiver.setDestFile(new File(outputDirectory, "sources.zip"));
        try {
            zipArchiver.createArchive();
            log.info("Sources zip location: " + outputDirectory + File.separator + "sources" + ".zip");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to zip sources: ", (Exception)e);
        }
        return new File(outputDirectory, "sources.zip");
    }

    private static boolean isContainFileExt(File dir) {
        if (containFileExt) {
            return true;
        }
        if (dir != null && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    CxPluginUtils.isContainFileExt(file);
                    continue;
                }
                for (String suffix : SUPPORTED_SUFFIX) {
                    if (!file.getName().endsWith(suffix)) continue;
                    containFileExt = true;
                }
            }
        }
        return containFileExt;
    }

    private static MavenProject getProject(MavenProject p) {
        if (p.getExecutionProject() != null) {
            return p.getExecutionProject();
        }
        return p;
    }

    public static Properties generateOSAScanConfiguration(String scanFolder, String[] osaIgnoreScopes, String dummyFilename) {
        Properties ret = new Properties();
        ret.put("includes", dummyFilename);
        if (osaIgnoreScopes != null && osaIgnoreScopes.length > 0) {
            ret.put("maven.ignoredScopes", StringUtils.join((Object[])new Serializable[]{",", osaIgnoreScopes}));
        }
        ret.put("d", scanFolder);
        return ret;
    }
}

