/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.ItemsResponse;
import com.checkout.Serializer;
import com.checkout.accounts.payout.schedule.response.CurrencySchedule;
import com.checkout.accounts.payout.schedule.response.GetScheduleResponse;
import com.checkout.accounts.payout.schedule.response.ScheduleFrequencyDailyResponse;
import com.checkout.accounts.payout.schedule.response.ScheduleFrequencyMonthlyResponse;
import com.checkout.accounts.payout.schedule.response.ScheduleFrequencyWeeklyResponse;
import com.checkout.accounts.payout.schedule.response.ScheduleResponse;
import com.checkout.common.Currency;
import com.checkout.common.InstrumentType;
import com.checkout.common.Link;
import com.checkout.common.PaymentSourceType;
import com.checkout.events.previous.EventTypes;
import com.checkout.instruments.create.CreateInstrumentBankAccountResponse;
import com.checkout.instruments.create.CreateInstrumentResponse;
import com.checkout.instruments.create.CreateInstrumentTokenResponse;
import com.checkout.instruments.get.GetBankAccountInstrumentResponse;
import com.checkout.instruments.get.GetCardInstrumentResponse;
import com.checkout.instruments.get.GetInstrumentResponse;
import com.checkout.instruments.update.UpdateInstrumentBankAccountResponse;
import com.checkout.instruments.update.UpdateInstrumentCardResponse;
import com.checkout.instruments.update.UpdateInstrumentResponse;
import com.checkout.issuing.cards.CardType;
import com.checkout.issuing.cards.responses.CardDetailsResponse;
import com.checkout.issuing.cards.responses.PhysicalCardDetailsResponse;
import com.checkout.issuing.cards.responses.VirtualCardDetailsResponse;
import com.checkout.issuing.controls.requests.ControlType;
import com.checkout.issuing.controls.responses.create.CardControlResponse;
import com.checkout.issuing.controls.responses.create.MccCardControlResponse;
import com.checkout.issuing.controls.responses.create.VelocityCardControlResponse;
import com.checkout.payments.PaymentDestinationType;
import com.checkout.payments.previous.PaymentAction;
import com.checkout.payments.previous.response.destination.PaymentResponseAlternativeDestination;
import com.checkout.payments.previous.response.destination.PaymentResponseCardDestination;
import com.checkout.payments.response.destination.PaymentResponseBankAccountDestination;
import com.checkout.payments.response.destination.PaymentResponseDestination;
import com.checkout.payments.response.source.CardResponseSource;
import com.checkout.payments.response.source.CurrencyAccountResponseSource;
import com.checkout.payments.response.source.contexts.AlternativePaymentSourceResponse;
import com.checkout.payments.response.source.contexts.PaymentContextsPayPayResponseSource;
import com.checkout.payments.response.source.contexts.ResponseSource;
import com.checkout.payments.sender.PaymentCorporateSender;
import com.checkout.payments.sender.PaymentIndividualSender;
import com.checkout.payments.sender.PaymentInstrumentSender;
import com.checkout.payments.sender.ResponseAlternativeSender;
import com.checkout.payments.sender.Sender;
import com.checkout.payments.sender.SenderType;
import com.checkout.webhooks.previous.WebhookResponse;
import com.checkout.workflows.actions.WorkflowActionType;
import com.checkout.workflows.actions.response.WebhookWorkflowActionResponse;
import com.checkout.workflows.actions.response.WorkflowActionResponse;
import com.checkout.workflows.conditions.WorkflowConditionType;
import com.checkout.workflows.conditions.response.EntityWorkflowConditionResponse;
import com.checkout.workflows.conditions.response.EventWorkflowConditionResponse;
import com.checkout.workflows.conditions.response.ProcessingChannelWorkflowConditionResponse;
import com.checkout.workflows.conditions.response.WorkflowConditionResponse;
import com.checkout.workflows.events.WorkflowEventTypes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.EnumUtils;

public class GsonSerializer
implements Serializer {
    private static final List<DateTimeFormatter> DEFAULT_FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSXXX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXX"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX"));
    private static final Type MAP_TYPE_TOKEN = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Type EVENT_TYPES_TYPE = new TypeToken<ItemsResponse<EventTypes>>(){}.getType();
    private static final Type WORKFLOWS_EVENT_TYPES_TYPE = new TypeToken<ItemsResponse<WorkflowEventTypes>>(){}.getType();
    private static final Type WEBHOOKS_TYPE = new TypeToken<ItemsResponse<WebhookResponse>>(){}.getType();
    private static final Type PREVIOUS_PAYMENT_ACTIONS_TYPE = new TypeToken<ItemsResponse<PaymentAction>>(){}.getType();
    private static final Type PAYMENT_ACTIONS_TYPE = new TypeToken<ItemsResponse<com.checkout.payments.PaymentAction>>(){}.getType();
    private static final Gson DEFAULT_GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Instant.class, (date, typeOfSrc, context) -> new JsonPrimitive(date.truncatedTo(ChronoUnit.SECONDS).toString())).registerTypeAdapter(Instant.class, GsonSerializer.getInstantJsonDeserializer()).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(com.checkout.payments.previous.response.source.ResponseSource.class, "type", true, com.checkout.payments.previous.response.source.AlternativePaymentSourceResponse.class).registerSubtype(com.checkout.payments.previous.response.source.CardResponseSource.class, GsonSerializer.identifier(PaymentSourceType.CARD))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(com.checkout.payments.previous.response.destination.PaymentResponseDestination.class, "type", true, PaymentResponseAlternativeDestination.class).registerSubtype(PaymentResponseCardDestination.class, GsonSerializer.identifier(PaymentDestinationType.CARD))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(com.checkout.payments.response.source.ResponseSource.class, "type", true, com.checkout.payments.response.source.AlternativePaymentSourceResponse.class).registerSubtype(CardResponseSource.class, GsonSerializer.identifier(PaymentSourceType.CARD)).registerSubtype(CurrencyAccountResponseSource.class, GsonSerializer.identifier(PaymentSourceType.CURRENCY_ACCOUNT))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(ResponseSource.class, "type", true, AlternativePaymentSourceResponse.class).registerSubtype(PaymentContextsPayPayResponseSource.class, GsonSerializer.identifier(PaymentSourceType.PAYPAL))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(PaymentResponseDestination.class, "type", true, com.checkout.payments.response.destination.PaymentResponseAlternativeDestination.class).registerSubtype(PaymentResponseBankAccountDestination.class, GsonSerializer.identifier(PaymentDestinationType.BANK_ACCOUNT))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(Sender.class, "type", true, ResponseAlternativeSender.class).registerSubtype(PaymentCorporateSender.class, GsonSerializer.identifier(SenderType.CORPORATE)).registerSubtype(PaymentIndividualSender.class, GsonSerializer.identifier(SenderType.INDIVIDUAL)).registerSubtype(PaymentInstrumentSender.class, GsonSerializer.identifier(SenderType.INSTRUMENT))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(CreateInstrumentResponse.class, "type").registerSubtype(CreateInstrumentBankAccountResponse.class, GsonSerializer.identifier(InstrumentType.BANK_ACCOUNT)).registerSubtype(CreateInstrumentTokenResponse.class, GsonSerializer.identifier(InstrumentType.CARD))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(GetInstrumentResponse.class, "type").registerSubtype(GetBankAccountInstrumentResponse.class, GsonSerializer.identifier(InstrumentType.BANK_ACCOUNT)).registerSubtype(GetCardInstrumentResponse.class, GsonSerializer.identifier(InstrumentType.CARD))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(UpdateInstrumentResponse.class, "type").registerSubtype(UpdateInstrumentBankAccountResponse.class, GsonSerializer.identifier(InstrumentType.BANK_ACCOUNT)).registerSubtype(UpdateInstrumentCardResponse.class, GsonSerializer.identifier(InstrumentType.CARD))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(WorkflowActionResponse.class, "type").registerSubtype(WebhookWorkflowActionResponse.class, GsonSerializer.identifier(WorkflowActionType.WEBHOOK))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(WorkflowConditionResponse.class, "type").registerSubtype(EventWorkflowConditionResponse.class, GsonSerializer.identifier(WorkflowConditionType.EVENT)).registerSubtype(EntityWorkflowConditionResponse.class, GsonSerializer.identifier(WorkflowConditionType.ENTITY)).registerSubtype(ProcessingChannelWorkflowConditionResponse.class, GsonSerializer.identifier(WorkflowConditionType.PROCESSING_CHANNEL))).registerTypeAdapter(GetScheduleResponse.class, GsonSerializer.getScheduleResponseDeserializer()).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(ScheduleResponse.class, "frequency").registerSubtype(ScheduleFrequencyDailyResponse.class, "Daily").registerSubtype(ScheduleFrequencyWeeklyResponse.class, "Weekly").registerSubtype(ScheduleFrequencyMonthlyResponse.class, "Monthly")).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(CardDetailsResponse.class, "type").registerSubtype(PhysicalCardDetailsResponse.class, GsonSerializer.identifier(CardType.PHYSICAL)).registerSubtype(VirtualCardDetailsResponse.class, GsonSerializer.identifier(CardType.VIRTUAL))).registerTypeAdapterFactory(RuntimeTypeAdapterFactory.of(CardControlResponse.class, "control_type").registerSubtype(VelocityCardControlResponse.class, GsonSerializer.identifier(ControlType.VELOCITY_LIMIT)).registerSubtype(MccCardControlResponse.class, GsonSerializer.identifier(ControlType.MCC_LIMIT))).registerTypeAdapter(EVENT_TYPES_TYPE, GsonSerializer.eventTypesResponseDeserializer()).registerTypeAdapter(WORKFLOWS_EVENT_TYPES_TYPE, GsonSerializer.workflowEventTypesResponseDeserializer()).registerTypeAdapter(WEBHOOKS_TYPE, GsonSerializer.webhooksResponseDeserializer()).registerTypeAdapter(PREVIOUS_PAYMENT_ACTIONS_TYPE, GsonSerializer.paymentActionsResponsePreviousDeserializer()).registerTypeAdapter(PAYMENT_ACTIONS_TYPE, GsonSerializer.paymentActionsResponseDeserializer()).create();
    private final Gson gson;

    public GsonSerializer() {
        this(DEFAULT_GSON);
    }

    public GsonSerializer(Gson gson) {
        this.gson = gson;
    }

    public Gson getGson() {
        return this.gson;
    }

    @Override
    public <T> String toJson(T object) {
        return this.gson.toJson(object);
    }

    @Override
    public <T> T fromJson(String json, Class<T> type) {
        return (T)this.gson.fromJson(json, type);
    }

    @Override
    public <T> T fromJson(String json, Type type) {
        return (T)this.gson.fromJson(json, type);
    }

    @Override
    public Map<String, Object> fromJson(String json) {
        return (Map)this.gson.fromJson(json, MAP_TYPE_TOKEN);
    }

    private static <E extends Enum<E>> String identifier(E enumEntry) {
        if (enumEntry == null) {
            throw new IllegalStateException("invalid enum entry");
        }
        return enumEntry.name().toLowerCase();
    }

    private static JsonDeserializer<ItemsResponse<EventTypes>> eventTypesResponseDeserializer() {
        return (json, typeOfT, context) -> {
            ItemsResponse<EventTypes> eventTypesResponse = new ItemsResponse<EventTypes>();
            if (json.isJsonArray()) {
                eventTypesResponse.setItems(GsonSerializer.deserializeJsonArray(json, EventTypes.class));
            }
            return eventTypesResponse;
        };
    }

    private static JsonDeserializer<ItemsResponse<WorkflowEventTypes>> workflowEventTypesResponseDeserializer() {
        return (json, typeOfT, context) -> {
            ItemsResponse<WorkflowEventTypes> workflowEventTypesResponse = new ItemsResponse<WorkflowEventTypes>();
            if (json.isJsonArray()) {
                workflowEventTypesResponse.setItems(GsonSerializer.deserializeJsonArray(json, WorkflowEventTypes.class));
            }
            return workflowEventTypesResponse;
        };
    }

    private static JsonDeserializer<ItemsResponse<WebhookResponse>> webhooksResponseDeserializer() {
        return (json, typeOfT, context) -> {
            ItemsResponse<WebhookResponse> webhooksResponse = new ItemsResponse<WebhookResponse>();
            if (json.isJsonArray()) {
                webhooksResponse.setItems(GsonSerializer.deserializeJsonArray(json, WebhookResponse.class));
            }
            return webhooksResponse;
        };
    }

    private static JsonDeserializer<ItemsResponse<PaymentAction>> paymentActionsResponsePreviousDeserializer() {
        return (json, typeOfT, context) -> {
            ItemsResponse<PaymentAction> paymentActionsResponse = new ItemsResponse<PaymentAction>();
            if (json.isJsonArray()) {
                paymentActionsResponse.setItems(GsonSerializer.deserializeJsonArray(json, PaymentAction.class));
            }
            return paymentActionsResponse;
        };
    }

    private static JsonDeserializer<ItemsResponse<com.checkout.payments.PaymentAction>> paymentActionsResponseDeserializer() {
        return (json, typeOfT, context) -> {
            ItemsResponse<com.checkout.payments.PaymentAction> paymentActionsResponse = new ItemsResponse<com.checkout.payments.PaymentAction>();
            if (json.isJsonArray()) {
                paymentActionsResponse.setItems(GsonSerializer.deserializeJsonArray(json, com.checkout.payments.PaymentAction.class));
            }
            return paymentActionsResponse;
        };
    }

    private static <T> List<T> deserializeJsonArray(JsonElement json, Class<T> itemsType) {
        JsonArray jsonArray = json.getAsJsonArray();
        return IntStream.range(0, json.getAsJsonArray().size()).mapToObj(i -> DEFAULT_GSON.fromJson(jsonArray.get(i), itemsType)).collect(Collectors.toList());
    }

    private static JsonDeserializer<GetScheduleResponse> getScheduleResponseDeserializer() {
        return (json, typeOfT, context) -> {
            JsonObject jsonObject = json.getAsJsonObject();
            EnumMap currency = new EnumMap(Currency.class);
            GetScheduleResponse getScheduleResponse = new GetScheduleResponse();
            jsonObject.keySet().forEach(key -> {
                if (EnumUtils.isValidEnum(Currency.class, (String)key)) {
                    CurrencySchedule currencySchedule = (CurrencySchedule)DEFAULT_GSON.fromJson(jsonObject.get(key), CurrencySchedule.class);
                    currency.put(Currency.valueOf(key), currencySchedule);
                    getScheduleResponse.setCurrency(currency);
                }
                if (key.equalsIgnoreCase("_links")) {
                    Type type = new TypeToken<Map<String, Link>>(){}.getType();
                    Map links = (Map)DEFAULT_GSON.fromJson(jsonObject.get(key), type);
                    getScheduleResponse.setLinks(links);
                }
            });
            return getScheduleResponse;
        };
    }

    private static JsonDeserializer<Instant> getInstantJsonDeserializer() {
        return (json, typeOfT, context) -> {
            String dateString = json.getAsString();
            try {
                return Instant.parse(dateString);
            }
            catch (DateTimeParseException ex) {
                for (DateTimeFormatter formatter : DEFAULT_FORMATTERS) {
                    try {
                        LocalDateTime dateTime = LocalDateTime.parse(dateString, formatter);
                        return dateTime.toInstant(ZoneOffset.UTC);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                    }
                }
                throw ex;
            }
        };
    }
}

