/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.issuing;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.IdResponse;
import com.checkout.issuing.IssuingClient;
import com.checkout.issuing.cardholders.CardholderCardsResponse;
import com.checkout.issuing.cardholders.CardholderDetailsResponse;
import com.checkout.issuing.cardholders.CardholderRequest;
import com.checkout.issuing.cardholders.CardholderResponse;
import com.checkout.issuing.cards.requests.create.CardRequest;
import com.checkout.issuing.cards.requests.credentials.CardCredentialsQuery;
import com.checkout.issuing.cards.requests.enrollment.ThreeDSEnrollmentRequest;
import com.checkout.issuing.cards.requests.enrollment.ThreeDSUpdateRequest;
import com.checkout.issuing.cards.requests.revoke.RevokeCardRequest;
import com.checkout.issuing.cards.requests.suspend.SuspendCardRequest;
import com.checkout.issuing.cards.responses.CardDetailsResponse;
import com.checkout.issuing.cards.responses.CardResponse;
import com.checkout.issuing.cards.responses.credentials.CardCredentialsResponse;
import com.checkout.issuing.cards.responses.enrollment.ThreeDSEnrollmentDetailsResponse;
import com.checkout.issuing.cards.responses.enrollment.ThreeDSEnrollmentResponse;
import com.checkout.issuing.cards.responses.enrollment.ThreeDSUpdateResponse;
import com.checkout.issuing.controls.requests.create.CardControlRequest;
import com.checkout.issuing.controls.requests.query.CardControlsQuery;
import com.checkout.issuing.controls.requests.update.UpdateCardControlRequest;
import com.checkout.issuing.controls.responses.create.CardControlResponse;
import com.checkout.issuing.controls.responses.query.CardControlsQueryResponse;
import com.checkout.issuing.testing.requests.CardAuthorizationClearingRequest;
import com.checkout.issuing.testing.requests.CardAuthorizationIncrementingRequest;
import com.checkout.issuing.testing.requests.CardAuthorizationRequest;
import com.checkout.issuing.testing.requests.CardAuthorizationReversalRequest;
import com.checkout.issuing.testing.responses.CardAuthorizationIncrementingResponse;
import com.checkout.issuing.testing.responses.CardAuthorizationResponse;
import com.checkout.issuing.testing.responses.CardAuthorizationReversalResponse;
import com.checkout.payments.VoidResponse;
import java.util.concurrent.CompletableFuture;

public class IssuingClientImpl
extends AbstractClient
implements IssuingClient {
    private static final String ISSUING_PATH = "issuing";
    private static final String CARDHOLDERS_PATH = "cardholders";
    private static final String CARDS_PATH = "cards";
    private static final String THREE_DS_ENROLLMENT_PATH = "3ds-enrollment";
    private static final String ACTIVATE_PATH = "activate";
    private static final String CREDENTIALS_PATH = "credentials";
    private static final String REVOKE_PATH = "revoke";
    private static final String SUSPEND_PATH = "suspend";
    private static final String CONTROLS_PATH = "controls";
    private static final String SIMULATE_PATH = "simulate";
    private static final String AUTHORIZATIONS_PATH = "authorizations";
    private static final String PRESENTMENTS_PATH = "presentments";
    private static final String REVERSALS_PATH = "reversals";

    public IssuingClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<CardholderResponse> createCardholder(CardholderRequest cardholderRequest) {
        CheckoutUtils.validateParams("cardholderRequest", cardholderRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDHOLDERS_PATH), this.sdkAuthorization(), CardholderResponse.class, (Object)cardholderRequest, null);
    }

    @Override
    public CompletableFuture<CardholderDetailsResponse> getCardholder(String cardholderId) {
        CheckoutUtils.validateParams("cardholderId", cardholderId);
        return this.apiClient.getAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDHOLDERS_PATH, cardholderId), this.sdkAuthorization(), CardholderDetailsResponse.class);
    }

    @Override
    public CompletableFuture<CardholderCardsResponse> getCardholderCards(String cardholderId) {
        CheckoutUtils.validateParams("cardholderId", cardholderId);
        return this.apiClient.getAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDHOLDERS_PATH, cardholderId, CARDS_PATH), this.sdkAuthorization(), CardholderCardsResponse.class);
    }

    @Override
    public CompletableFuture<CardResponse> createCard(CardRequest cardRequest) {
        CheckoutUtils.validateParams("cardRequest", cardRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH), this.sdkAuthorization(), CardResponse.class, (Object)cardRequest, null);
    }

    @Override
    public CompletableFuture<CardDetailsResponse> getCardDetails(String cardId) {
        CheckoutUtils.validateParams("cardId", cardId);
        return this.apiClient.getAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId), this.sdkAuthorization(), CardDetailsResponse.class);
    }

    @Override
    public CompletableFuture<ThreeDSEnrollmentResponse> enrollThreeDS(String cardId, ThreeDSEnrollmentRequest enrollmentRequest) {
        CheckoutUtils.validateParams("cardId", cardId, "enrollmentRequest", enrollmentRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, THREE_DS_ENROLLMENT_PATH), this.sdkAuthorization(), ThreeDSEnrollmentResponse.class, (Object)enrollmentRequest, null);
    }

    @Override
    public CompletableFuture<ThreeDSUpdateResponse> updateThreeDS(String cardId, ThreeDSUpdateRequest threeDSUpdateRequest) {
        CheckoutUtils.validateParams("cardId", cardId, "threeDSUpdateRequest", threeDSUpdateRequest);
        return this.apiClient.patchAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, THREE_DS_ENROLLMENT_PATH), this.sdkAuthorization(), ThreeDSUpdateResponse.class, (Object)threeDSUpdateRequest, null);
    }

    @Override
    public CompletableFuture<ThreeDSEnrollmentDetailsResponse> getCardThreeDSDetails(String cardId) {
        CheckoutUtils.validateParams("cardId", cardId);
        return this.apiClient.getAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, THREE_DS_ENROLLMENT_PATH), this.sdkAuthorization(), ThreeDSEnrollmentDetailsResponse.class);
    }

    @Override
    public CompletableFuture<VoidResponse> activateCard(String cardId) {
        CheckoutUtils.validateParams("cardId", cardId);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, ACTIVATE_PATH), this.sdkAuthorization(), VoidResponse.class, null, null);
    }

    @Override
    public CompletableFuture<CardCredentialsResponse> getCardCredentials(String cardId, CardCredentialsQuery queryFilter) {
        CheckoutUtils.validateParams("cardId", cardId, "queryFilter", queryFilter);
        return this.apiClient.queryAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, CREDENTIALS_PATH), this.sdkAuthorization(), queryFilter, CardCredentialsResponse.class);
    }

    @Override
    public CompletableFuture<VoidResponse> revokeCard(String cardId, RevokeCardRequest revokeCardRequest) {
        CheckoutUtils.validateParams("cardId", cardId, "revokeCardRequest", revokeCardRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, REVOKE_PATH), this.sdkAuthorization(), VoidResponse.class, (Object)revokeCardRequest, null);
    }

    @Override
    public CompletableFuture<VoidResponse> suspendCard(String cardId, SuspendCardRequest suspendCardRequest) {
        CheckoutUtils.validateParams("cardId", cardId, "suspendCardRequest", suspendCardRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CARDS_PATH, cardId, SUSPEND_PATH), this.sdkAuthorization(), VoidResponse.class, (Object)suspendCardRequest, null);
    }

    @Override
    public CompletableFuture<CardControlResponse> createControl(CardControlRequest cardControlRequest) {
        CheckoutUtils.validateParams("cardControlRequest", cardControlRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CONTROLS_PATH), this.sdkAuthorization(), CardControlResponse.class, (Object)cardControlRequest, null);
    }

    @Override
    public CompletableFuture<CardControlsQueryResponse> getCardControls(CardControlsQuery queryFilter) {
        CheckoutUtils.validateParams("queryFilter", queryFilter);
        return this.apiClient.queryAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CONTROLS_PATH), this.sdkAuthorization(), queryFilter, CardControlsQueryResponse.class);
    }

    @Override
    public CompletableFuture<CardControlResponse> getCardControlDetails(String controlId) {
        CheckoutUtils.validateParams("controlId", controlId);
        return this.apiClient.getAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CONTROLS_PATH, controlId), this.sdkAuthorization(), CardControlResponse.class);
    }

    @Override
    public CompletableFuture<CardControlResponse> updateCardControl(String controlId, UpdateCardControlRequest updateCardControlRequest) {
        CheckoutUtils.validateParams("controlId", controlId, "updateCardControlRequest", updateCardControlRequest);
        return this.apiClient.putAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CONTROLS_PATH, controlId), this.sdkAuthorization(), CardControlResponse.class, updateCardControlRequest);
    }

    @Override
    public CompletableFuture<IdResponse> removeCardControl(String controlId) {
        CheckoutUtils.validateParams("controlId", controlId);
        return this.apiClient.deleteAsync(IssuingClientImpl.buildPath(ISSUING_PATH, CONTROLS_PATH, controlId), this.sdkAuthorization(), IdResponse.class);
    }

    @Override
    public CompletableFuture<CardAuthorizationResponse> simulateAuthorization(CardAuthorizationRequest cardAuthorizationRequest) {
        CheckoutUtils.validateParams("cardAuthorizationRequest", cardAuthorizationRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, SIMULATE_PATH, AUTHORIZATIONS_PATH), this.sdkAuthorization(), CardAuthorizationResponse.class, (Object)cardAuthorizationRequest, null);
    }

    @Override
    public CompletableFuture<CardAuthorizationIncrementingResponse> simulateIncrementingAuthorization(String authorizationId, CardAuthorizationIncrementingRequest cardAuthorizationIncrementingRequest) {
        CheckoutUtils.validateParams("authorizationId", authorizationId, "cardAuthorizationIncrementingRequest", cardAuthorizationIncrementingRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, SIMULATE_PATH, AUTHORIZATIONS_PATH, authorizationId, AUTHORIZATIONS_PATH), this.sdkAuthorization(), CardAuthorizationIncrementingResponse.class, (Object)cardAuthorizationIncrementingRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> simulateClearing(String authorizationId, CardAuthorizationClearingRequest cardAuthorizationClearingRequest) {
        CheckoutUtils.validateParams("authorizationId", authorizationId, "cardAuthorizationClearingRequest", cardAuthorizationClearingRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, SIMULATE_PATH, AUTHORIZATIONS_PATH, authorizationId, PRESENTMENTS_PATH), this.sdkAuthorization(), EmptyResponse.class, (Object)cardAuthorizationClearingRequest, null);
    }

    @Override
    public CompletableFuture<CardAuthorizationReversalResponse> simulateReversal(String authorizationId, CardAuthorizationReversalRequest cardAuthorizationReversalRequest) {
        CheckoutUtils.validateParams("authorizationId", authorizationId, "cardAuthorizationReversalRequest", cardAuthorizationReversalRequest);
        return this.apiClient.postAsync(IssuingClientImpl.buildPath(ISSUING_PATH, SIMULATE_PATH, AUTHORIZATIONS_PATH, authorizationId, REVERSALS_PATH), this.sdkAuthorization(), CardAuthorizationReversalResponse.class, (Object)cardAuthorizationReversalRequest, null);
    }
}

