/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.payments.hosted;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.payments.hosted.HostedPaymentDetailsResponse;
import com.checkout.payments.hosted.HostedPaymentRequest;
import com.checkout.payments.hosted.HostedPaymentResponse;
import com.checkout.payments.hosted.HostedPaymentsClient;
import java.util.concurrent.CompletableFuture;

public class HostedPaymentsClientImpl
extends AbstractClient
implements HostedPaymentsClient {
    private static final String HOSTED_PAYMENTS_PATH = "hosted-payments";

    public HostedPaymentsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<HostedPaymentResponse> createHostedPaymentsPageSession(HostedPaymentRequest hostedPaymentRequest) {
        CheckoutUtils.validateParams("hostedPaymentRequest", hostedPaymentRequest);
        return this.apiClient.postAsync(HOSTED_PAYMENTS_PATH, this.sdkAuthorization(), HostedPaymentResponse.class, (Object)hostedPaymentRequest, null);
    }

    @Override
    public CompletableFuture<HostedPaymentDetailsResponse> getHostedPaymentsPageDetails(String hostedPaymentId) {
        CheckoutUtils.validateParams("hostedPayment", hostedPaymentId);
        return this.apiClient.getAsync(HostedPaymentsClientImpl.buildPath(HOSTED_PAYMENTS_PATH, hostedPaymentId), this.sdkAuthorization(), HostedPaymentDetailsResponse.class);
    }
}

