/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.payments.request;

import com.checkout.common.AmountAllocations;
import com.checkout.common.Currency;
import com.checkout.common.CustomerRequest;
import com.checkout.common.MarketplaceData;
import com.checkout.payments.AuthorizationType;
import com.checkout.payments.BillingDescriptor;
import com.checkout.payments.PaymentRecipient;
import com.checkout.payments.PaymentType;
import com.checkout.payments.ProcessingSettings;
import com.checkout.payments.Product;
import com.checkout.payments.RiskRequest;
import com.checkout.payments.ShippingDetails;
import com.checkout.payments.ThreeDSRequest;
import com.checkout.payments.request.PaymentRetryRequest;
import com.checkout.payments.request.PaymentSegment;
import com.checkout.payments.request.source.AbstractRequestSource;
import com.checkout.payments.sender.PaymentSender;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class PaymentRequest {
    private AbstractRequestSource source;
    private Long amount;
    private Currency currency;
    @SerializedName(value="payment_type")
    private PaymentType paymentType;
    @SerializedName(value="merchant_initiated")
    private Boolean merchantInitiated;
    private String reference;
    private String description;
    @SerializedName(value="authorization_type")
    private AuthorizationType authorizationType;
    private Boolean capture;
    @SerializedName(value="capture_on")
    private Instant captureOn;
    private CustomerRequest customer;
    @SerializedName(value="billing_descriptor")
    private BillingDescriptor billingDescriptor;
    private ShippingDetails shipping;
    @SerializedName(value="3ds")
    private ThreeDSRequest threeDS;
    @SerializedName(value="processing_channel_id")
    private String processingChannelId;
    @SerializedName(value="previous_payment_id")
    private String previousPaymentId;
    private RiskRequest risk;
    @SerializedName(value="success_url")
    private String successUrl;
    @SerializedName(value="failure_url")
    private String failureUrl;
    @SerializedName(value="payment_ip")
    private String paymentIp;
    private PaymentSender sender;
    private PaymentRecipient recipient;
    @Deprecated
    private MarketplaceData marketplace;
    @SerializedName(value="amount_allocations")
    private List<AmountAllocations> amountAllocations;
    private ProcessingSettings processing;
    private List<Product> items;
    private PaymentRetryRequest retry;
    private Map<String, Object> metadata;
    private PaymentSegment segment;

    @Generated
    private static Map<String, Object> $default$metadata() {
        return new HashMap<String, Object>();
    }

    @Generated
    PaymentRequest(AbstractRequestSource source, Long amount, Currency currency, PaymentType paymentType, Boolean merchantInitiated, String reference, String description, AuthorizationType authorizationType, Boolean capture, Instant captureOn, CustomerRequest customer, BillingDescriptor billingDescriptor, ShippingDetails shipping, ThreeDSRequest threeDS, String processingChannelId, String previousPaymentId, RiskRequest risk, String successUrl, String failureUrl, String paymentIp, PaymentSender sender, PaymentRecipient recipient, MarketplaceData marketplace, List<AmountAllocations> amountAllocations, ProcessingSettings processing, List<Product> items, PaymentRetryRequest retry, Map<String, Object> metadata, PaymentSegment segment) {
        this.source = source;
        this.amount = amount;
        this.currency = currency;
        this.paymentType = paymentType;
        this.merchantInitiated = merchantInitiated;
        this.reference = reference;
        this.description = description;
        this.authorizationType = authorizationType;
        this.capture = capture;
        this.captureOn = captureOn;
        this.customer = customer;
        this.billingDescriptor = billingDescriptor;
        this.shipping = shipping;
        this.threeDS = threeDS;
        this.processingChannelId = processingChannelId;
        this.previousPaymentId = previousPaymentId;
        this.risk = risk;
        this.successUrl = successUrl;
        this.failureUrl = failureUrl;
        this.paymentIp = paymentIp;
        this.sender = sender;
        this.recipient = recipient;
        this.marketplace = marketplace;
        this.amountAllocations = amountAllocations;
        this.processing = processing;
        this.items = items;
        this.retry = retry;
        this.metadata = metadata;
        this.segment = segment;
    }

    @Generated
    public static PaymentRequestBuilder builder() {
        return new PaymentRequestBuilder();
    }

    @Generated
    public AbstractRequestSource getSource() {
        return this.source;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Currency getCurrency() {
        return this.currency;
    }

    @Generated
    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    @Generated
    public Boolean getMerchantInitiated() {
        return this.merchantInitiated;
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public AuthorizationType getAuthorizationType() {
        return this.authorizationType;
    }

    @Generated
    public Boolean getCapture() {
        return this.capture;
    }

    @Generated
    public Instant getCaptureOn() {
        return this.captureOn;
    }

    @Generated
    public CustomerRequest getCustomer() {
        return this.customer;
    }

    @Generated
    public BillingDescriptor getBillingDescriptor() {
        return this.billingDescriptor;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public ThreeDSRequest getThreeDS() {
        return this.threeDS;
    }

    @Generated
    public String getProcessingChannelId() {
        return this.processingChannelId;
    }

    @Generated
    public String getPreviousPaymentId() {
        return this.previousPaymentId;
    }

    @Generated
    public RiskRequest getRisk() {
        return this.risk;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    @Generated
    public String getFailureUrl() {
        return this.failureUrl;
    }

    @Generated
    public String getPaymentIp() {
        return this.paymentIp;
    }

    @Generated
    public PaymentSender getSender() {
        return this.sender;
    }

    @Generated
    public PaymentRecipient getRecipient() {
        return this.recipient;
    }

    @Deprecated
    @Generated
    public MarketplaceData getMarketplace() {
        return this.marketplace;
    }

    @Generated
    public List<AmountAllocations> getAmountAllocations() {
        return this.amountAllocations;
    }

    @Generated
    public ProcessingSettings getProcessing() {
        return this.processing;
    }

    @Generated
    public List<Product> getItems() {
        return this.items;
    }

    @Generated
    public PaymentRetryRequest getRetry() {
        return this.retry;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public PaymentSegment getSegment() {
        return this.segment;
    }

    @Generated
    public void setSource(AbstractRequestSource source) {
        this.source = source;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Generated
    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    @Generated
    public void setMerchantInitiated(Boolean merchantInitiated) {
        this.merchantInitiated = merchantInitiated;
    }

    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setAuthorizationType(AuthorizationType authorizationType) {
        this.authorizationType = authorizationType;
    }

    @Generated
    public void setCapture(Boolean capture) {
        this.capture = capture;
    }

    @Generated
    public void setCaptureOn(Instant captureOn) {
        this.captureOn = captureOn;
    }

    @Generated
    public void setCustomer(CustomerRequest customer) {
        this.customer = customer;
    }

    @Generated
    public void setBillingDescriptor(BillingDescriptor billingDescriptor) {
        this.billingDescriptor = billingDescriptor;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setThreeDS(ThreeDSRequest threeDS) {
        this.threeDS = threeDS;
    }

    @Generated
    public void setProcessingChannelId(String processingChannelId) {
        this.processingChannelId = processingChannelId;
    }

    @Generated
    public void setPreviousPaymentId(String previousPaymentId) {
        this.previousPaymentId = previousPaymentId;
    }

    @Generated
    public void setRisk(RiskRequest risk) {
        this.risk = risk;
    }

    @Generated
    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    @Generated
    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    @Generated
    public void setPaymentIp(String paymentIp) {
        this.paymentIp = paymentIp;
    }

    @Generated
    public void setSender(PaymentSender sender) {
        this.sender = sender;
    }

    @Generated
    public void setRecipient(PaymentRecipient recipient) {
        this.recipient = recipient;
    }

    @Deprecated
    @Generated
    public void setMarketplace(MarketplaceData marketplace) {
        this.marketplace = marketplace;
    }

    @Generated
    public void setAmountAllocations(List<AmountAllocations> amountAllocations) {
        this.amountAllocations = amountAllocations;
    }

    @Generated
    public void setProcessing(ProcessingSettings processing) {
        this.processing = processing;
    }

    @Generated
    public void setItems(List<Product> items) {
        this.items = items;
    }

    @Generated
    public void setRetry(PaymentRetryRequest retry) {
        this.retry = retry;
    }

    @Generated
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setSegment(PaymentSegment segment) {
        this.segment = segment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentRequest)) {
            return false;
        }
        PaymentRequest other = (PaymentRequest)o;
        AbstractRequestSource this$source = this.getSource();
        AbstractRequestSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !((Object)((Object)this$paymentType)).equals((Object)other$paymentType)) {
            return false;
        }
        Boolean this$merchantInitiated = this.getMerchantInitiated();
        Boolean other$merchantInitiated = other.getMerchantInitiated();
        if (this$merchantInitiated == null ? other$merchantInitiated != null : !((Object)this$merchantInitiated).equals(other$merchantInitiated)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        AuthorizationType this$authorizationType = this.getAuthorizationType();
        AuthorizationType other$authorizationType = other.getAuthorizationType();
        if (this$authorizationType == null ? other$authorizationType != null : !((Object)((Object)this$authorizationType)).equals((Object)other$authorizationType)) {
            return false;
        }
        Boolean this$capture = this.getCapture();
        Boolean other$capture = other.getCapture();
        if (this$capture == null ? other$capture != null : !((Object)this$capture).equals(other$capture)) {
            return false;
        }
        Instant this$captureOn = this.getCaptureOn();
        Instant other$captureOn = other.getCaptureOn();
        if (this$captureOn == null ? other$captureOn != null : !((Object)this$captureOn).equals(other$captureOn)) {
            return false;
        }
        CustomerRequest this$customer = this.getCustomer();
        CustomerRequest other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !((Object)this$customer).equals(other$customer)) {
            return false;
        }
        BillingDescriptor this$billingDescriptor = this.getBillingDescriptor();
        BillingDescriptor other$billingDescriptor = other.getBillingDescriptor();
        if (this$billingDescriptor == null ? other$billingDescriptor != null : !((Object)this$billingDescriptor).equals(other$billingDescriptor)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        ThreeDSRequest this$threeDS = this.getThreeDS();
        ThreeDSRequest other$threeDS = other.getThreeDS();
        if (this$threeDS == null ? other$threeDS != null : !((Object)this$threeDS).equals(other$threeDS)) {
            return false;
        }
        String this$processingChannelId = this.getProcessingChannelId();
        String other$processingChannelId = other.getProcessingChannelId();
        if (this$processingChannelId == null ? other$processingChannelId != null : !this$processingChannelId.equals(other$processingChannelId)) {
            return false;
        }
        String this$previousPaymentId = this.getPreviousPaymentId();
        String other$previousPaymentId = other.getPreviousPaymentId();
        if (this$previousPaymentId == null ? other$previousPaymentId != null : !this$previousPaymentId.equals(other$previousPaymentId)) {
            return false;
        }
        RiskRequest this$risk = this.getRisk();
        RiskRequest other$risk = other.getRisk();
        if (this$risk == null ? other$risk != null : !((Object)this$risk).equals(other$risk)) {
            return false;
        }
        String this$successUrl = this.getSuccessUrl();
        String other$successUrl = other.getSuccessUrl();
        if (this$successUrl == null ? other$successUrl != null : !this$successUrl.equals(other$successUrl)) {
            return false;
        }
        String this$failureUrl = this.getFailureUrl();
        String other$failureUrl = other.getFailureUrl();
        if (this$failureUrl == null ? other$failureUrl != null : !this$failureUrl.equals(other$failureUrl)) {
            return false;
        }
        String this$paymentIp = this.getPaymentIp();
        String other$paymentIp = other.getPaymentIp();
        if (this$paymentIp == null ? other$paymentIp != null : !this$paymentIp.equals(other$paymentIp)) {
            return false;
        }
        PaymentSender this$sender = this.getSender();
        PaymentSender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        PaymentRecipient this$recipient = this.getRecipient();
        PaymentRecipient other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient)) {
            return false;
        }
        MarketplaceData this$marketplace = this.getMarketplace();
        MarketplaceData other$marketplace = other.getMarketplace();
        if (this$marketplace == null ? other$marketplace != null : !((Object)this$marketplace).equals(other$marketplace)) {
            return false;
        }
        List<AmountAllocations> this$amountAllocations = this.getAmountAllocations();
        List<AmountAllocations> other$amountAllocations = other.getAmountAllocations();
        if (this$amountAllocations == null ? other$amountAllocations != null : !((Object)this$amountAllocations).equals(other$amountAllocations)) {
            return false;
        }
        ProcessingSettings this$processing = this.getProcessing();
        ProcessingSettings other$processing = other.getProcessing();
        if (this$processing == null ? other$processing != null : !((Object)this$processing).equals(other$processing)) {
            return false;
        }
        List<Product> this$items = this.getItems();
        List<Product> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        PaymentRetryRequest this$retry = this.getRetry();
        PaymentRetryRequest other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        PaymentSegment this$segment = this.getSegment();
        PaymentSegment other$segment = other.getSegment();
        return !(this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbstractRequestSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : ((Object)((Object)$paymentType)).hashCode());
        Boolean $merchantInitiated = this.getMerchantInitiated();
        result = result * 59 + ($merchantInitiated == null ? 43 : ((Object)$merchantInitiated).hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        AuthorizationType $authorizationType = this.getAuthorizationType();
        result = result * 59 + ($authorizationType == null ? 43 : ((Object)((Object)$authorizationType)).hashCode());
        Boolean $capture = this.getCapture();
        result = result * 59 + ($capture == null ? 43 : ((Object)$capture).hashCode());
        Instant $captureOn = this.getCaptureOn();
        result = result * 59 + ($captureOn == null ? 43 : ((Object)$captureOn).hashCode());
        CustomerRequest $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : ((Object)$customer).hashCode());
        BillingDescriptor $billingDescriptor = this.getBillingDescriptor();
        result = result * 59 + ($billingDescriptor == null ? 43 : ((Object)$billingDescriptor).hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        ThreeDSRequest $threeDS = this.getThreeDS();
        result = result * 59 + ($threeDS == null ? 43 : ((Object)$threeDS).hashCode());
        String $processingChannelId = this.getProcessingChannelId();
        result = result * 59 + ($processingChannelId == null ? 43 : $processingChannelId.hashCode());
        String $previousPaymentId = this.getPreviousPaymentId();
        result = result * 59 + ($previousPaymentId == null ? 43 : $previousPaymentId.hashCode());
        RiskRequest $risk = this.getRisk();
        result = result * 59 + ($risk == null ? 43 : ((Object)$risk).hashCode());
        String $successUrl = this.getSuccessUrl();
        result = result * 59 + ($successUrl == null ? 43 : $successUrl.hashCode());
        String $failureUrl = this.getFailureUrl();
        result = result * 59 + ($failureUrl == null ? 43 : $failureUrl.hashCode());
        String $paymentIp = this.getPaymentIp();
        result = result * 59 + ($paymentIp == null ? 43 : $paymentIp.hashCode());
        PaymentSender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        PaymentRecipient $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
        MarketplaceData $marketplace = this.getMarketplace();
        result = result * 59 + ($marketplace == null ? 43 : ((Object)$marketplace).hashCode());
        List<AmountAllocations> $amountAllocations = this.getAmountAllocations();
        result = result * 59 + ($amountAllocations == null ? 43 : ((Object)$amountAllocations).hashCode());
        ProcessingSettings $processing = this.getProcessing();
        result = result * 59 + ($processing == null ? 43 : ((Object)$processing).hashCode());
        List<Product> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        PaymentRetryRequest $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        PaymentSegment $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentRequest(source=" + this.getSource() + ", amount=" + this.getAmount() + ", currency=" + (Object)((Object)this.getCurrency()) + ", paymentType=" + (Object)((Object)this.getPaymentType()) + ", merchantInitiated=" + this.getMerchantInitiated() + ", reference=" + this.getReference() + ", description=" + this.getDescription() + ", authorizationType=" + (Object)((Object)this.getAuthorizationType()) + ", capture=" + this.getCapture() + ", captureOn=" + this.getCaptureOn() + ", customer=" + this.getCustomer() + ", billingDescriptor=" + this.getBillingDescriptor() + ", shipping=" + this.getShipping() + ", threeDS=" + this.getThreeDS() + ", processingChannelId=" + this.getProcessingChannelId() + ", previousPaymentId=" + this.getPreviousPaymentId() + ", risk=" + this.getRisk() + ", successUrl=" + this.getSuccessUrl() + ", failureUrl=" + this.getFailureUrl() + ", paymentIp=" + this.getPaymentIp() + ", sender=" + this.getSender() + ", recipient=" + this.getRecipient() + ", marketplace=" + this.getMarketplace() + ", amountAllocations=" + this.getAmountAllocations() + ", processing=" + this.getProcessing() + ", items=" + this.getItems() + ", retry=" + this.getRetry() + ", metadata=" + this.getMetadata() + ", segment=" + this.getSegment() + ")";
    }

    @Generated
    public static class PaymentRequestBuilder {
        @Generated
        private AbstractRequestSource source;
        @Generated
        private Long amount;
        @Generated
        private Currency currency;
        @Generated
        private PaymentType paymentType;
        @Generated
        private Boolean merchantInitiated;
        @Generated
        private String reference;
        @Generated
        private String description;
        @Generated
        private AuthorizationType authorizationType;
        @Generated
        private Boolean capture;
        @Generated
        private Instant captureOn;
        @Generated
        private CustomerRequest customer;
        @Generated
        private BillingDescriptor billingDescriptor;
        @Generated
        private ShippingDetails shipping;
        @Generated
        private ThreeDSRequest threeDS;
        @Generated
        private String processingChannelId;
        @Generated
        private String previousPaymentId;
        @Generated
        private RiskRequest risk;
        @Generated
        private String successUrl;
        @Generated
        private String failureUrl;
        @Generated
        private String paymentIp;
        @Generated
        private PaymentSender sender;
        @Generated
        private PaymentRecipient recipient;
        @Generated
        private MarketplaceData marketplace;
        @Generated
        private List<AmountAllocations> amountAllocations;
        @Generated
        private ProcessingSettings processing;
        @Generated
        private List<Product> items;
        @Generated
        private PaymentRetryRequest retry;
        @Generated
        private boolean metadata$set;
        @Generated
        private Map<String, Object> metadata;
        @Generated
        private PaymentSegment segment;

        @Generated
        PaymentRequestBuilder() {
        }

        @Generated
        public PaymentRequestBuilder source(AbstractRequestSource source) {
            this.source = source;
            return this;
        }

        @Generated
        public PaymentRequestBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public PaymentRequestBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        @Generated
        public PaymentRequestBuilder paymentType(PaymentType paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        @Generated
        public PaymentRequestBuilder merchantInitiated(Boolean merchantInitiated) {
            this.merchantInitiated = merchantInitiated;
            return this;
        }

        @Generated
        public PaymentRequestBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Generated
        public PaymentRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public PaymentRequestBuilder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Generated
        public PaymentRequestBuilder capture(Boolean capture) {
            this.capture = capture;
            return this;
        }

        @Generated
        public PaymentRequestBuilder captureOn(Instant captureOn) {
            this.captureOn = captureOn;
            return this;
        }

        @Generated
        public PaymentRequestBuilder customer(CustomerRequest customer) {
            this.customer = customer;
            return this;
        }

        @Generated
        public PaymentRequestBuilder billingDescriptor(BillingDescriptor billingDescriptor) {
            this.billingDescriptor = billingDescriptor;
            return this;
        }

        @Generated
        public PaymentRequestBuilder shipping(ShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        @Generated
        public PaymentRequestBuilder threeDS(ThreeDSRequest threeDS) {
            this.threeDS = threeDS;
            return this;
        }

        @Generated
        public PaymentRequestBuilder processingChannelId(String processingChannelId) {
            this.processingChannelId = processingChannelId;
            return this;
        }

        @Generated
        public PaymentRequestBuilder previousPaymentId(String previousPaymentId) {
            this.previousPaymentId = previousPaymentId;
            return this;
        }

        @Generated
        public PaymentRequestBuilder risk(RiskRequest risk) {
            this.risk = risk;
            return this;
        }

        @Generated
        public PaymentRequestBuilder successUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }

        @Generated
        public PaymentRequestBuilder failureUrl(String failureUrl) {
            this.failureUrl = failureUrl;
            return this;
        }

        @Generated
        public PaymentRequestBuilder paymentIp(String paymentIp) {
            this.paymentIp = paymentIp;
            return this;
        }

        @Generated
        public PaymentRequestBuilder sender(PaymentSender sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public PaymentRequestBuilder recipient(PaymentRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        @Deprecated
        @Generated
        public PaymentRequestBuilder marketplace(MarketplaceData marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        @Generated
        public PaymentRequestBuilder amountAllocations(List<AmountAllocations> amountAllocations) {
            this.amountAllocations = amountAllocations;
            return this;
        }

        @Generated
        public PaymentRequestBuilder processing(ProcessingSettings processing) {
            this.processing = processing;
            return this;
        }

        @Generated
        public PaymentRequestBuilder items(List<Product> items) {
            this.items = items;
            return this;
        }

        @Generated
        public PaymentRequestBuilder retry(PaymentRetryRequest retry) {
            this.retry = retry;
            return this;
        }

        @Generated
        public PaymentRequestBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            this.metadata$set = true;
            return this;
        }

        @Generated
        public PaymentRequestBuilder segment(PaymentSegment segment) {
            this.segment = segment;
            return this;
        }

        @Generated
        public PaymentRequest build() {
            Map metadata = this.metadata;
            if (!this.metadata$set) {
                metadata = PaymentRequest.$default$metadata();
            }
            return new PaymentRequest(this.source, this.amount, this.currency, this.paymentType, this.merchantInitiated, this.reference, this.description, this.authorizationType, this.capture, this.captureOn, this.customer, this.billingDescriptor, this.shipping, this.threeDS, this.processingChannelId, this.previousPaymentId, this.risk, this.successUrl, this.failureUrl, this.paymentIp, this.sender, this.recipient, this.marketplace, this.amountAllocations, this.processing, this.items, this.retry, metadata, this.segment);
        }

        @Generated
        public String toString() {
            return "PaymentRequest.PaymentRequestBuilder(source=" + this.source + ", amount=" + this.amount + ", currency=" + (Object)((Object)this.currency) + ", paymentType=" + (Object)((Object)this.paymentType) + ", merchantInitiated=" + this.merchantInitiated + ", reference=" + this.reference + ", description=" + this.description + ", authorizationType=" + (Object)((Object)this.authorizationType) + ", capture=" + this.capture + ", captureOn=" + this.captureOn + ", customer=" + this.customer + ", billingDescriptor=" + this.billingDescriptor + ", shipping=" + this.shipping + ", threeDS=" + this.threeDS + ", processingChannelId=" + this.processingChannelId + ", previousPaymentId=" + this.previousPaymentId + ", risk=" + this.risk + ", successUrl=" + this.successUrl + ", failureUrl=" + this.failureUrl + ", paymentIp=" + this.paymentIp + ", sender=" + this.sender + ", recipient=" + this.recipient + ", marketplace=" + this.marketplace + ", amountAllocations=" + this.amountAllocations + ", processing=" + this.processing + ", items=" + this.items + ", retry=" + this.retry + ", metadata=" + this.metadata + ", segment=" + this.segment + ")";
        }
    }
}

