/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.transfers;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.transfers.CreateTransferRequest;
import com.checkout.transfers.CreateTransferResponse;
import com.checkout.transfers.TransferDetailsResponse;
import com.checkout.transfers.TransfersClient;
import java.util.concurrent.CompletableFuture;

public class TransfersClientImpl
extends AbstractClient
implements TransfersClient {
    private static final String TRANSFERS_PATH = "transfers";

    public TransfersClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<CreateTransferResponse> initiateTransferOfFunds(CreateTransferRequest createTransferRequest) {
        return this.requestInitiateTransferOfFunds(createTransferRequest, null);
    }

    @Override
    public CompletableFuture<CreateTransferResponse> initiateTransferOfFunds(CreateTransferRequest createTransferRequest, String idempotencyKey) {
        return this.requestInitiateTransferOfFunds(createTransferRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<TransferDetailsResponse> retrieveATransfer(String transferId) {
        CheckoutUtils.validateParams("transferId", transferId);
        return this.apiClient.getAsync(TransfersClientImpl.buildPath(TRANSFERS_PATH, transferId), this.sdkAuthorization(), TransferDetailsResponse.class);
    }

    private CompletableFuture<CreateTransferResponse> requestInitiateTransferOfFunds(CreateTransferRequest createTransferRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("createTransferRequest", createTransferRequest);
        return this.apiClient.postAsync(TRANSFERS_PATH, this.sdkAuthorization(), CreateTransferResponse.class, (Object)createTransferRequest, idempotencyKey);
    }
}

