/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutApiClient;
import com.checkout.CheckoutArgumentException;
import com.checkout.CheckoutConfiguration;
import com.checkout.DefaultCheckoutConfiguration;
import com.checkout.IEnvironment;
import com.checkout.SdkCredentials;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class AbstractCheckoutSdkBuilder<T extends CheckoutApiClient> {
    protected HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
    private IEnvironment environment;
    private Executor executor = ForkJoinPool.commonPool();

    public AbstractCheckoutSdkBuilder<T> environment(IEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public AbstractCheckoutSdkBuilder<T> httpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this;
    }

    public AbstractCheckoutSdkBuilder<T> executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    protected IEnvironment getEnvironment() {
        return this.environment;
    }

    protected abstract SdkCredentials getSdkCredentials();

    protected CheckoutConfiguration getCheckoutConfiguration() {
        if (this.environment == null) {
            throw new CheckoutArgumentException("environment must be specified");
        }
        SdkCredentials sdkCredentials = this.getSdkCredentials();
        return this.buildCheckoutConfiguration(sdkCredentials);
    }

    private CheckoutConfiguration buildCheckoutConfiguration(SdkCredentials sdkCredentials) {
        return new DefaultCheckoutConfiguration(sdkCredentials, this.getEnvironment(), this.httpClientBuilder, this.executor);
    }

    public abstract T build();
}

