/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutException;
import com.checkout.ClientOperation;
import com.checkout.Response;
import com.checkout.SdkAuthorization;
import com.checkout.Transport;
import com.checkout.accounts.AccountsFileRequest;
import com.checkout.common.AbstractFileRequest;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.FileRequest;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpClientTransport
implements Transport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClientTransport.class);
    private static final String ACCEPT_CSV = "text/csv";
    private static final String ACCEPT_JSON = "application/json;charset=UTF-8";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CKO_IDEMPOTENCY_KEY = "Cko-Idempotency-Key";
    private static final String FILE = "file";
    private static final String PURPOSE = "purpose";
    private static final String USER_AGENT = "user-agent";
    private static final String ACCEPT = "Accept";
    private static final String PATH = "path";
    private final URI baseUri;
    private final CloseableHttpClient httpClient;
    private final Executor executor;

    ApacheHttpClientTransport(URI baseUri, HttpClientBuilder httpClientBuilder, Executor executor) {
        CheckoutUtils.validateParams("baseUri", baseUri, "httpClientBuilder", httpClientBuilder, "executor", executor);
        this.baseUri = baseUri;
        this.httpClient = httpClientBuilder.build();
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Response> invoke(ClientOperation clientOperation, String path, SdkAuthorization authorization, String requestBody, String idempotencyKey, Map<String, String> queryParams) {
        return CompletableFuture.supplyAsync(() -> {
            HttpGet request;
            switch (clientOperation) {
                case GET: 
                case GET_CSV_CONTENT: {
                    request = new HttpGet(this.getRequestUrl(path));
                    break;
                }
                case PUT: {
                    request = new HttpPut(this.getRequestUrl(path));
                    break;
                }
                case POST: {
                    request = new HttpPost(this.getRequestUrl(path));
                    break;
                }
                case DELETE: {
                    request = new HttpDelete(this.getRequestUrl(path));
                    break;
                }
                case PATCH: {
                    request = new HttpPatch(this.getRequestUrl(path));
                    break;
                }
                case QUERY: {
                    List params = queryParams.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
                    try {
                        request = new HttpGet(new URIBuilder(this.getRequestUrl(path)).addParameters(params).build());
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new CheckoutException(e);
                    }
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported HTTP Method: " + (Object)((Object)clientOperation));
                }
            }
            if (idempotencyKey != null) {
                request.setHeader(CKO_IDEMPOTENCY_KEY, idempotencyKey);
            }
            return this.performCall(authorization, requestBody, (HttpUriRequest)request, clientOperation);
        }, this.executor);
    }

    @Override
    public CompletableFuture<Response> submitFile(String path, SdkAuthorization authorization, AbstractFileRequest fileRequest) {
        return CompletableFuture.supplyAsync(() -> {
            HttpPost request = new HttpPost(this.getRequestUrl(path));
            request.setEntity(this.getMultipartFileEntity(fileRequest));
            return this.performCall(authorization, null, (HttpUriRequest)request, ClientOperation.POST);
        }, this.executor);
    }

    private HttpEntity getMultipartFileEntity(AbstractFileRequest abstractFileRequest) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (abstractFileRequest instanceof FileRequest) {
            FileRequest fileRequest = (FileRequest)abstractFileRequest;
            builder.addBinaryBody(FILE, fileRequest.getFile(), fileRequest.getContentType(), fileRequest.getFile().getName()).addTextBody(PURPOSE, fileRequest.getPurpose().getPurpose(), ContentType.DEFAULT_BINARY).build();
        } else if (abstractFileRequest instanceof AccountsFileRequest) {
            AccountsFileRequest fileRequest = (AccountsFileRequest)abstractFileRequest;
            builder.addBinaryBody(PATH, fileRequest.getFile(), fileRequest.getContentType(), fileRequest.getFile().getName()).addTextBody(PURPOSE, fileRequest.getPurpose().getPurpose(), ContentType.DEFAULT_TEXT).build();
        } else {
            throw new CheckoutException("Not supported request object");
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response performCall(SdkAuthorization authorization, String requestBody, HttpUriRequest request, ClientOperation clientOperation) {
        log.info("{}: {}", (Object)clientOperation, (Object)request.getURI());
        request.setHeader(USER_AGENT, "checkout-sdk-java/" + CheckoutUtils.getVersionFromManifest());
        request.setHeader(ACCEPT, this.getAcceptHeader(clientOperation));
        request.setHeader(AUTHORIZATION, authorization.getAuthorizationHeader());
        log.info("Request: " + Arrays.toString(this.sanitiseHeaders(request.getAllHeaders())));
        if (requestBody != null && request instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
        }
        try (CloseableHttpResponse response2 = this.httpClient.execute(request);){
            log.info("Response: " + response2.getStatusLine().getStatusCode() + " " + Arrays.toString(response2.getAllHeaders()));
            int statusCode = response2.getStatusLine().getStatusCode();
            Map<String, String> headers = Arrays.stream(response2.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            if (statusCode != 404 && response2.getEntity() != null && response2.getEntity().getContent() != null) {
                Response response3 = Response.builder().statusCode(statusCode).body(EntityUtils.toString((HttpEntity)response2.getEntity())).headers(headers).build();
                return response3;
            }
            Response response = Response.builder().statusCode(statusCode).headers(headers).build();
            return response;
        }
        catch (Exception e) {
            log.error("Exception occurred during the execution of the client...", (Throwable)e);
            return Response.builder().statusCode(400).build();
        }
    }

    private Header[] sanitiseHeaders(Header[] headers) {
        return (Header[])Arrays.stream(headers).filter(it -> !it.getName().equals(AUTHORIZATION)).toArray(Header[]::new);
    }

    private String getAcceptHeader(ClientOperation clientOperation) {
        switch (clientOperation) {
            case GET: 
            case PUT: 
            case POST: 
            case DELETE: 
            case PATCH: 
            case QUERY: {
                return ACCEPT_JSON;
            }
            case GET_CSV_CONTENT: {
                return ACCEPT_CSV;
            }
        }
        throw new IllegalStateException(String.format("Accept header not configured for client operation %s", new Object[]{clientOperation}));
    }

    private String getRequestUrl(String path) {
        try {
            return this.baseUri.resolve(path).toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new CheckoutException(e);
        }
    }
}

