/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import java.time.LocalDateTime;

final class OAuthAccessToken {
    private final String token;
    private final LocalDateTime expirationDate;

    OAuthAccessToken(String token, LocalDateTime expirationDate) {
        this.token = token;
        this.expirationDate = expirationDate;
    }

    boolean isValid() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.isAfter(LocalDateTime.now());
    }

    String getToken() {
        return this.token;
    }

    LocalDateTime getExpirationDate() {
        return this.expirationDate;
    }
}

