/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.AbstractStaticKeysSdkCredentials;
import com.checkout.CheckoutAuthorizationException;
import com.checkout.PlatformType;
import com.checkout.SdkAuthorization;
import com.checkout.SdkAuthorizationType;

final class PreviousStaticKeysSdkCredentials
extends AbstractStaticKeysSdkCredentials {
    private static final String PREVIOUS_SECRET_KEY_PATTERN = "^sk_(test_)?(\\w{8})-(\\w{4})-(\\w{4})-(\\w{4})-(\\w{12})$";
    private static final String PREVIOUS_PUBLIC_KEY_PATTEN = "^pk_(test_)?(\\w{8})-(\\w{4})-(\\w{4})-(\\w{4})-(\\w{12})$";

    PreviousStaticKeysSdkCredentials(String secretKey, String publicKey) {
        super(PlatformType.PREVIOUS, PREVIOUS_SECRET_KEY_PATTERN, PREVIOUS_PUBLIC_KEY_PATTEN, secretKey, publicKey);
    }

    @Override
    public SdkAuthorization getAuthorization(SdkAuthorizationType authorizationType) {
        switch (authorizationType) {
            case SECRET_KEY: {
                return new SdkAuthorization(this.platformType, this.secretKey);
            }
            case PUBLIC_KEY: {
                return new SdkAuthorization(this.platformType, this.publicKey);
            }
        }
        throw CheckoutAuthorizationException.invalidAuthorization(authorizationType);
    }
}

