/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.accounts;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.accounts.AccountsClient;
import com.checkout.accounts.AccountsFileRequest;
import com.checkout.accounts.AccountsPaymentInstrument;
import com.checkout.accounts.OnboardEntityDetailsResponse;
import com.checkout.accounts.OnboardEntityRequest;
import com.checkout.accounts.OnboardEntityResponse;
import com.checkout.accounts.PaymentInstrumentDetailsResponse;
import com.checkout.accounts.PaymentInstrumentQueryResponse;
import com.checkout.accounts.PaymentInstrumentRequest;
import com.checkout.accounts.PaymentInstrumentsQuery;
import com.checkout.accounts.payout.schedule.request.UpdateScheduleRequest;
import com.checkout.accounts.payout.schedule.response.GetScheduleResponse;
import com.checkout.accounts.payout.schedule.response.VoidResponse;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.Currency;
import com.checkout.common.IdResponse;
import java.util.EnumMap;
import java.util.concurrent.CompletableFuture;

public class AccountsClientImpl
extends AbstractClient
implements AccountsClient {
    private static final String ACCOUNTS_PATH = "accounts";
    private static final String ENTITIES_PATH = "entities";
    private static final String INSTRUMENTS_PATH = "instruments";
    private static final String FILES_PATH = "files";
    private static final String PAYOUT_SCHEDULES_PATH = "payout-schedules";
    private static final String PAYMENT_INSTRUMENTS_PATH = "payment-instruments";
    private final ApiClient filesClient;

    public AccountsClientImpl(ApiClient apiClient, ApiClient filesClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
        this.filesClient = filesClient;
    }

    @Override
    public CompletableFuture<IdResponse> submitFile(AccountsFileRequest accountsFileRequest) {
        CheckoutUtils.validateParams("accountsFileRequest", accountsFileRequest);
        return this.filesClient.submitFileAsync(FILES_PATH, this.sdkAuthorization(), accountsFileRequest, IdResponse.class);
    }

    @Override
    public CompletableFuture<OnboardEntityResponse> createEntity(OnboardEntityRequest entityRequest) {
        CheckoutUtils.validateParams("entityRequest", entityRequest);
        return this.apiClient.postAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH), this.sdkAuthorization(), OnboardEntityResponse.class, (Object)entityRequest, null);
    }

    @Override
    public CompletableFuture<PaymentInstrumentDetailsResponse> retrievePaymentInstrumentDetails(String entityId, String paymentInstrumentId) {
        CheckoutUtils.validateParams("entityId", entityId, "paymentInstrumentId", paymentInstrumentId);
        return this.apiClient.getAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId, PAYMENT_INSTRUMENTS_PATH, paymentInstrumentId), this.sdkAuthorization(), PaymentInstrumentDetailsResponse.class);
    }

    @Override
    public CompletableFuture<OnboardEntityDetailsResponse> getEntity(String entityId) {
        CheckoutUtils.validateParams("entityId", entityId);
        return this.apiClient.getAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId), this.sdkAuthorization(), OnboardEntityDetailsResponse.class);
    }

    @Override
    public CompletableFuture<OnboardEntityResponse> updateEntity(OnboardEntityRequest entityRequest, String entityId) {
        CheckoutUtils.validateParams("entityRequest", entityRequest, "entityId", entityId);
        return this.apiClient.putAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId), this.sdkAuthorization(), OnboardEntityResponse.class, entityRequest);
    }

    @Override
    public CompletableFuture<EmptyResponse> createPaymentInstrument(AccountsPaymentInstrument accountsPaymentInstrument, String entityId) {
        CheckoutUtils.validateParams("accountsPaymentInstrument", accountsPaymentInstrument, "entityId", entityId);
        return this.apiClient.postAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId, INSTRUMENTS_PATH), this.sdkAuthorization(), EmptyResponse.class, (Object)accountsPaymentInstrument, null);
    }

    @Override
    public CompletableFuture<IdResponse> createPaymentInstrument(String entityId, PaymentInstrumentRequest paymentInstrumentRequest) {
        CheckoutUtils.validateParams("entityId", entityId, "paymentInstrumentRequest", paymentInstrumentRequest);
        return this.apiClient.postAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId, PAYMENT_INSTRUMENTS_PATH), this.sdkAuthorization(), IdResponse.class, (Object)paymentInstrumentRequest, null);
    }

    @Override
    public CompletableFuture<PaymentInstrumentQueryResponse> queryPaymentInstruments(String entityId, PaymentInstrumentsQuery query) {
        CheckoutUtils.validateParams("entityId", entityId, "query", query);
        return this.apiClient.queryAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId, PAYMENT_INSTRUMENTS_PATH), this.sdkAuthorization(), query, PaymentInstrumentQueryResponse.class);
    }

    @Override
    public CompletableFuture<GetScheduleResponse> retrievePayoutSchedule(String entityId) {
        CheckoutUtils.validateParams("entityId", entityId);
        return this.apiClient.getAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId, PAYOUT_SCHEDULES_PATH), this.sdkAuthorization(), GetScheduleResponse.class);
    }

    @Override
    public CompletableFuture<VoidResponse> updatePayoutSchedule(String entityId, Currency currency, UpdateScheduleRequest updateScheduleRequest) {
        CheckoutUtils.validateParams("entityId", entityId, "currency", (Object)currency, "updateScheduleRequest", updateScheduleRequest);
        EnumMap<Currency, UpdateScheduleRequest> request = new EnumMap<Currency, UpdateScheduleRequest>(Currency.class);
        request.put(currency, updateScheduleRequest);
        return this.apiClient.putAsync(AccountsClientImpl.buildPath(ACCOUNTS_PATH, ENTITIES_PATH, entityId, PAYOUT_SCHEDULES_PATH), this.sdkAuthorization(), VoidResponse.class, request);
    }
}

