/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.apm.previous.sepa;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.apm.previous.sepa.MandateResponse;
import com.checkout.apm.previous.sepa.SepaClient;
import com.checkout.apm.previous.sepa.SepaResource;
import com.checkout.common.CheckoutUtils;
import java.util.concurrent.CompletableFuture;

public class SepaClientImpl
extends AbstractClient
implements SepaClient {
    private static final String SEPA_MANDATES = "sepa/mandates";
    private static final String PPRO = "ppro";
    private static final String CANCEL = "cancel";
    private static final String MANDATE_ID = "mandateId";

    public SepaClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<MandateResponse> getMandate(String mandateId) {
        CheckoutUtils.validateParams(MANDATE_ID, mandateId);
        return this.apiClient.getAsync(SepaClientImpl.buildPath(SEPA_MANDATES, mandateId), this.sdkAuthorization(), MandateResponse.class);
    }

    @Override
    public CompletableFuture<SepaResource> cancelMandate(String mandateId) {
        CheckoutUtils.validateParams(MANDATE_ID, mandateId);
        return this.apiClient.postAsync(SepaClientImpl.buildPath(SEPA_MANDATES, mandateId, CANCEL), this.sdkAuthorization(), SepaResource.class, null, null);
    }

    @Override
    public CompletableFuture<MandateResponse> getMandateViaPPRO(String mandateId) {
        CheckoutUtils.validateParams(MANDATE_ID, mandateId);
        return this.apiClient.getAsync(SepaClientImpl.buildPath(PPRO, SEPA_MANDATES, mandateId), this.sdkAuthorization(), MandateResponse.class);
    }

    @Override
    public CompletableFuture<SepaResource> cancelMandateViaPPRO(String mandateId) {
        CheckoutUtils.validateParams(MANDATE_ID, mandateId);
        return this.apiClient.postAsync(SepaClientImpl.buildPath(PPRO, SEPA_MANDATES, mandateId, CANCEL), this.sdkAuthorization(), SepaResource.class, null, null);
    }
}

