/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.common;

import com.checkout.CheckoutArgumentException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class CheckoutUtils {
    public static final String PROJECT_NAME = "checkout-sdk-java";
    public static final String TYPE = "type";
    public static final String FREQUENCY = "frequency";
    public static final String DAILY = "Daily";
    public static final String WEEKLY = "Weekly";
    public static final String MONTHLY = "Monthly";
    private static final String CKO_REQUEST_ID = "Cko-Request-Id";

    private CheckoutUtils() {
    }

    public static String getVersionFromManifest() {
        return CheckoutUtils.class.getPackage().getImplementationVersion();
    }

    public static boolean isSuccessHttpStatusCode(int httpStatusCode) {
        return httpStatusCode >= 200 && httpStatusCode <= 299;
    }

    public static String getRequestId(Map<String, String> responseHeaders) {
        if (responseHeaders == null) {
            return null;
        }
        return responseHeaders.get(CKO_REQUEST_ID);
    }

    public static void validateParams(String p1, Object o1) {
        CheckoutUtils.validateMultipleRequires(new Object[][]{{p1, o1}});
    }

    public static void validateParams(String p1, Object o1, String p2, Object o2) {
        CheckoutUtils.validateMultipleRequires(new Object[][]{{p1, o1}, {p2, o2}});
    }

    public static void validateParams(String p1, Object o1, String p2, Object o2, String p3, Object o3) {
        CheckoutUtils.validateMultipleRequires(new Object[][]{{p1, o1}, {p2, o2}, {p3, o3}});
    }

    public static void validateParams(String p1, Object o1, String p2, Object o2, String p3, Object o3, String p4, Object o4) {
        CheckoutUtils.validateMultipleRequires(new Object[][]{{p1, o1}, {p2, o2}, {p3, o3}, {p4, o4}});
    }

    public static void validateParams(String p1, Object o1, String p2, Object o2, String p3, Object o3, String p4, Object o4, String p5, Object o5) {
        CheckoutUtils.validateMultipleRequires(new Object[][]{{p1, o1}, {p2, o2}, {p3, o3}, {p4, o4}, {p5, o5}});
    }

    private static void validateMultipleRequires(Object[][] params) {
        if (params.length == 0) {
            return;
        }
        for (Object[] param : params) {
            Object property = param[0];
            if (!(property instanceof String) || StringUtils.isBlank((CharSequence)((CharSequence)property))) {
                throw new IllegalStateException("invalid validation key");
            }
            Object value = param[1];
            if (value instanceof String) {
                CheckoutUtils.requiresNonBlank((String)property, (String)value);
                continue;
            }
            CheckoutUtils.requiresNonNull((String)property, value);
        }
    }

    private static void requiresNonBlank(String property, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new CheckoutArgumentException(property + " cannot be blank");
        }
    }

    private static void requiresNonNull(String property, Object obj) {
        if (obj == null) {
            throw new CheckoutArgumentException(property + " cannot be null");
        }
    }
}

