/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.reports;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.reports.ReportDetailsResponse;
import com.checkout.reports.ReportsClient;
import com.checkout.reports.ReportsQuery;
import com.checkout.reports.ReportsResponse;
import java.util.concurrent.CompletableFuture;

public class ReportsClientImpl
extends AbstractClient
implements ReportsClient {
    private static final String REPORTS_PATH = "reports";

    public ReportsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<ReportsResponse> getAllReports(ReportsQuery query) {
        return this.apiClient.queryAsync(REPORTS_PATH, this.sdkAuthorization(), query, ReportsResponse.class);
    }

    @Override
    public CompletableFuture<ReportDetailsResponse> getReportDetails(String reportId) {
        return this.apiClient.getAsync(ReportsClientImpl.buildPath(REPORTS_PATH, reportId), this.sdkAuthorization(), ReportDetailsResponse.class);
    }
}

