/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.sessions;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.HttpMetadata;
import com.checkout.SdkAuthorization;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.sessions.CreateSessionAcceptedResponse;
import com.checkout.sessions.CreateSessionOkResponse;
import com.checkout.sessions.GetSessionResponse;
import com.checkout.sessions.GetSessionResponseAfterChannelDataSupplied;
import com.checkout.sessions.SessionRequest;
import com.checkout.sessions.SessionResponse;
import com.checkout.sessions.SessionSecretSdkCredentials;
import com.checkout.sessions.SessionsClient;
import com.checkout.sessions.ThreeDsMethodCompletionRequest;
import com.checkout.sessions.channel.ChannelData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class SessionsClientImpl
extends AbstractClient
implements SessionsClient {
    private static final String SESSIONS_PATH = "sessions";
    private static final String COLLECT_DATA_PATH = "collect-data";
    private static final String COMPLETE_PATH = "complete";
    private static final String ISSUER_FINGERPRINT_PATH = "issuer-fingerprint";
    private static final String SESSION_ID = "sessionId";
    private static final Map<Integer, Class<? extends HttpMetadata>> SESSION_RESPONSE_MAPPINGS = new HashMap<Integer, Class<? extends HttpMetadata>>();

    public SessionsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.OAUTH);
    }

    @Override
    public CompletableFuture<SessionResponse> requestSession(SessionRequest sessionRequest) {
        CheckoutUtils.validateParams("sessionRequest", sessionRequest);
        return this.createSession(sessionRequest);
    }

    @Override
    public CompletableFuture<GetSessionResponse> getSessionDetails(String sessionId) {
        return this.getSessionDetails(sessionId, this.sdkAuthorization());
    }

    @Override
    public CompletableFuture<GetSessionResponse> getSessionDetails(String sessionSecret, String sessionId) {
        return this.getSessionDetails(sessionId, this.sessionSecretAuthorization(sessionSecret));
    }

    @Override
    public final CompletableFuture<GetSessionResponse> updateSession(String sessionId, ChannelData channelData) {
        return this.updateSession(sessionId, channelData, this.sdkAuthorization());
    }

    @Override
    public CompletableFuture<GetSessionResponse> updateSession(String sessionSecret, String sessionId, ChannelData channelData) {
        return this.updateSession(sessionId, channelData, this.sessionSecretAuthorization(sessionSecret));
    }

    @Override
    public CompletableFuture<EmptyResponse> completeSession(String sessionId) {
        return this.completeSession(sessionId, this.sdkAuthorization());
    }

    @Override
    public CompletableFuture<EmptyResponse> completeSession(String sessionSecret, String sessionId) {
        return this.completeSession(sessionId, this.sessionSecretAuthorization(sessionSecret));
    }

    @Override
    public CompletableFuture<GetSessionResponseAfterChannelDataSupplied> update3dsMethodCompletionIndicator(String sessionId, ThreeDsMethodCompletionRequest threeDsMethodCompletionRequest) {
        return this.update3dsMethodCompletionIndicator(sessionId, threeDsMethodCompletionRequest, this.sdkAuthorization());
    }

    @Override
    public CompletableFuture<GetSessionResponseAfterChannelDataSupplied> update3dsMethodCompletionIndicator(String sessionSecret, String sessionId, ThreeDsMethodCompletionRequest threeDsMethodCompletionRequest) {
        return this.update3dsMethodCompletionIndicator(sessionId, threeDsMethodCompletionRequest, this.sessionSecretAuthorization(sessionSecret));
    }

    private CompletableFuture<SessionResponse> createSession(SessionRequest sessionRequest) {
        return this.apiClient.postAsync(SESSIONS_PATH, this.sdkAuthorization(), SESSION_RESPONSE_MAPPINGS, (Object)sessionRequest, null).thenApply(resource -> {
            if (resource instanceof CreateSessionOkResponse) {
                return new SessionResponse((CreateSessionOkResponse)resource);
            }
            if (resource instanceof CreateSessionAcceptedResponse) {
                return new SessionResponse((CreateSessionAcceptedResponse)resource);
            }
            throw new IllegalStateException("Unexpected mapping type " + resource.getClass());
        });
    }

    private CompletableFuture<GetSessionResponse> getSessionDetails(String sessionId, SdkAuthorization sdkAuthorization) {
        CheckoutUtils.validateParams(SESSION_ID, sessionId);
        return this.apiClient.getAsync(SessionsClientImpl.buildPath(SESSIONS_PATH, sessionId), sdkAuthorization, GetSessionResponse.class);
    }

    private CompletableFuture<GetSessionResponse> updateSession(String sessionId, ChannelData channelData, SdkAuthorization sdkAuthorization) {
        CheckoutUtils.validateParams(SESSION_ID, sessionId, "channelData", channelData);
        return this.apiClient.putAsync(SessionsClientImpl.buildPath(SESSIONS_PATH, sessionId, COLLECT_DATA_PATH), sdkAuthorization, GetSessionResponse.class, channelData);
    }

    private CompletableFuture<EmptyResponse> completeSession(String sessionId, SdkAuthorization sdkAuthorization) {
        CheckoutUtils.validateParams(SESSION_ID, sessionId);
        return this.apiClient.postAsync(SessionsClientImpl.buildPath(SESSIONS_PATH, sessionId, COMPLETE_PATH), sdkAuthorization, EmptyResponse.class, null, null);
    }

    private CompletableFuture<GetSessionResponseAfterChannelDataSupplied> update3dsMethodCompletionIndicator(String sessionId, ThreeDsMethodCompletionRequest threeDsMethodCompletionRequest, SdkAuthorization sdkAuthorization) {
        CheckoutUtils.validateParams(SESSION_ID, sessionId, "threeDsMethodCompletionRequest", threeDsMethodCompletionRequest);
        return this.apiClient.putAsync(SessionsClientImpl.buildPath(SESSIONS_PATH, sessionId, ISSUER_FINGERPRINT_PATH), sdkAuthorization, GetSessionResponseAfterChannelDataSupplied.class, threeDsMethodCompletionRequest);
    }

    private SdkAuthorization sessionSecretAuthorization(String sessionSecret) {
        CheckoutUtils.validateParams("sessionSecret", sessionSecret);
        return new SessionSecretSdkCredentials(sessionSecret).getAuthorization(SdkAuthorizationType.CUSTOM);
    }

    static {
        SESSION_RESPONSE_MAPPINGS.put(201, CreateSessionOkResponse.class);
        SESSION_RESPONSE_MAPPINGS.put(202, CreateSessionAcceptedResponse.class);
    }
}

