/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokens;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.tokens.CardTokenRequest;
import com.checkout.tokens.CardTokenResponse;
import com.checkout.tokens.TokenResponse;
import com.checkout.tokens.TokensClient;
import com.checkout.tokens.WalletTokenRequest;
import java.util.concurrent.CompletableFuture;

public class TokensClientImpl
extends AbstractClient
implements TokensClient {
    private static final String TOKENS_PATH = "tokens";

    public TokensClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.PUBLIC_KEY);
    }

    @Override
    public CompletableFuture<CardTokenResponse> requestCardToken(CardTokenRequest cardTokenRequest) {
        CheckoutUtils.validateParams("cardTokenRequest", cardTokenRequest);
        return this.apiClient.postAsync(TOKENS_PATH, this.sdkAuthorization(), CardTokenResponse.class, (Object)cardTokenRequest, null);
    }

    @Override
    public CompletableFuture<TokenResponse> requestWalletToken(WalletTokenRequest walletTokenRequest) {
        CheckoutUtils.validateParams("walletTokenRequest", walletTokenRequest);
        return this.apiClient.postAsync(TOKENS_PATH, this.sdkAuthorization(), TokenResponse.class, (Object)walletTokenRequest, null);
    }
}

