/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.workflows;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.ItemsResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.workflows.CreateWorkflowRequest;
import com.checkout.workflows.CreateWorkflowResponse;
import com.checkout.workflows.GetWorkflowResponse;
import com.checkout.workflows.GetWorkflowsResponse;
import com.checkout.workflows.UpdateWorkflowRequest;
import com.checkout.workflows.UpdateWorkflowResponse;
import com.checkout.workflows.WorkflowsClient;
import com.checkout.workflows.actions.request.WorkflowActionRequest;
import com.checkout.workflows.actions.response.WorkflowActionInvocationsResponse;
import com.checkout.workflows.conditions.request.WorkflowConditionRequest;
import com.checkout.workflows.events.GetEventResponse;
import com.checkout.workflows.events.SubjectEventsResponse;
import com.checkout.workflows.events.WorkflowEventTypes;
import com.checkout.workflows.reflow.ReflowRequest;
import com.checkout.workflows.reflow.ReflowResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class WorkflowsClientImpl
extends AbstractClient
implements WorkflowsClient {
    private static final String WORKFLOWS_PATH = "workflows";
    private static final String WORKFLOW_PATH = "workflow";
    private static final String ACTIONS_PATH = "actions";
    private static final String CONDITIONS_PATH = "conditions";
    private static final String EVENT_TYPES_PATH = "event-types";
    private static final String EVENTS_PATH = "events";
    private static final String REFLOW_PATH = "reflow";
    private static final String SUBJECT_PATH = "subject";
    private static final String WORKFLOW_ID = "workflowId";
    private static final Type WORKFLOWS_EVENT_TYPES_TYPE = new TypeToken<ItemsResponse<WorkflowEventTypes>>(){}.getType();

    public WorkflowsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        CheckoutUtils.validateParams("createWorkflowRequest", createWorkflowRequest);
        return this.apiClient.postAsync(WORKFLOWS_PATH, this.sdkAuthorization(), CreateWorkflowResponse.class, (Object)createWorkflowRequest, null);
    }

    @Override
    public CompletableFuture<GetWorkflowsResponse> getWorkflows() {
        return this.apiClient.getAsync(WORKFLOWS_PATH, this.sdkAuthorization(), GetWorkflowsResponse.class);
    }

    @Override
    public CompletableFuture<GetWorkflowResponse> getWorkflow(String workflowId) {
        CheckoutUtils.validateParams(WORKFLOW_ID, workflowId);
        return this.apiClient.getAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, workflowId), this.sdkAuthorization(), GetWorkflowResponse.class);
    }

    @Override
    public CompletableFuture<UpdateWorkflowResponse> updateWorkflow(String workflowId, UpdateWorkflowRequest updateWorkflowRequest) {
        CheckoutUtils.validateParams(WORKFLOW_ID, workflowId, "updateWorkflowRequest", updateWorkflowRequest);
        return this.apiClient.patchAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, workflowId), this.sdkAuthorization(), UpdateWorkflowResponse.class, (Object)updateWorkflowRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> removeWorkflow(String workflowId) {
        CheckoutUtils.validateParams(WORKFLOW_ID, workflowId);
        return this.apiClient.deleteAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, workflowId), this.sdkAuthorization());
    }

    @Override
    public CompletableFuture<EmptyResponse> updateWorkflowAction(String workflowId, String actionId, WorkflowActionRequest workflowActionRequest) {
        CheckoutUtils.validateParams(WORKFLOW_ID, workflowId, "actionId", actionId, "workflowActionRequest", workflowActionRequest);
        return this.apiClient.putAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, workflowId, ACTIONS_PATH, actionId), this.sdkAuthorization(), EmptyResponse.class, workflowActionRequest);
    }

    @Override
    public CompletableFuture<EmptyResponse> updateWorkflowCondition(String workflowId, String conditionId, WorkflowConditionRequest workflowConditionRequest) {
        CheckoutUtils.validateParams(WORKFLOW_ID, workflowId, "conditionId", conditionId, "workflowConditionRequest", workflowConditionRequest);
        return this.apiClient.putAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, workflowId, CONDITIONS_PATH, conditionId), this.sdkAuthorization(), EmptyResponse.class, workflowConditionRequest);
    }

    @Override
    public CompletableFuture<ItemsResponse<WorkflowEventTypes>> getEventTypes() {
        return this.apiClient.getAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENT_TYPES_PATH), this.sdkAuthorization(), WORKFLOWS_EVENT_TYPES_TYPE);
    }

    @Override
    public CompletableFuture<SubjectEventsResponse> getSubjectEvents(String subjectId) {
        CheckoutUtils.validateParams("subjectId", subjectId);
        return this.apiClient.getAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, SUBJECT_PATH, subjectId), this.sdkAuthorization(), SubjectEventsResponse.class);
    }

    @Override
    public CompletableFuture<GetEventResponse> getEvent(String eventId) {
        CheckoutUtils.validateParams("eventId", eventId);
        return this.apiClient.getAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, eventId), this.sdkAuthorization(), GetEventResponse.class);
    }

    @Override
    public CompletableFuture<ReflowResponse> reflowByEvent(String eventId) {
        CheckoutUtils.validateParams("eventId", eventId);
        return this.apiClient.postAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, eventId, REFLOW_PATH), this.sdkAuthorization(), ReflowResponse.class, null, null);
    }

    @Override
    public CompletableFuture<ReflowResponse> reflowBySubject(String subjectId) {
        CheckoutUtils.validateParams("subjectId", subjectId);
        return this.apiClient.postAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, SUBJECT_PATH, subjectId, REFLOW_PATH), this.sdkAuthorization(), ReflowResponse.class, null, null);
    }

    @Override
    public CompletableFuture<ReflowResponse> reflowByEventAndWorkflow(String eventId, String workflowId) {
        CheckoutUtils.validateParams("eventId", eventId, WORKFLOW_ID, workflowId);
        return this.apiClient.postAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, eventId, WORKFLOW_PATH, workflowId, REFLOW_PATH), this.sdkAuthorization(), ReflowResponse.class, null, null);
    }

    @Override
    public CompletableFuture<ReflowResponse> reflowBySubjectAndWorkflow(String subjectId, String workflowId) {
        CheckoutUtils.validateParams("subjectId", subjectId, WORKFLOW_ID, workflowId);
        return this.apiClient.postAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, SUBJECT_PATH, subjectId, WORKFLOW_PATH, workflowId, REFLOW_PATH), this.sdkAuthorization(), ReflowResponse.class, null, null);
    }

    @Override
    public CompletableFuture<ReflowResponse> reflow(ReflowRequest reflowRequest) {
        CheckoutUtils.validateParams("reflowRequest", reflowRequest);
        return this.apiClient.postAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, REFLOW_PATH), this.sdkAuthorization(), ReflowResponse.class, (Object)reflowRequest, null);
    }

    @Override
    public CompletableFuture<WorkflowActionInvocationsResponse> getActionInvocations(String eventId, String actionId) {
        CheckoutUtils.validateParams("eventId", eventId, "actionId", actionId);
        return this.apiClient.getAsync(WorkflowsClientImpl.buildPath(WORKFLOWS_PATH, EVENTS_PATH, eventId, ACTIONS_PATH, actionId), this.sdkAuthorization(), WorkflowActionInvocationsResponse.class);
    }
}

