/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.ApiClient;
import com.checkout.ApiClientImpl;
import com.checkout.CheckoutConfiguration;
import com.checkout.UriStrategy;
import com.checkout.apm.ideal.IdealClient;
import com.checkout.apm.ideal.IdealClientImpl;
import com.checkout.apm.previous.klarna.KlarnaClient;
import com.checkout.apm.previous.klarna.KlarnaClientImpl;
import com.checkout.apm.previous.sepa.SepaClient;
import com.checkout.apm.previous.sepa.SepaClientImpl;
import java.net.URI;

public abstract class AbstractCheckoutApmApi {
    protected final ApiClient apiClient;
    private final IdealClient idealClient;
    private final KlarnaClient klarnaClient;
    private final SepaClient sepaClient;

    protected AbstractCheckoutApmApi(CheckoutConfiguration configuration) {
        this.apiClient = this.getBaseApiClient(configuration);
        this.idealClient = new IdealClientImpl(this.apiClient, configuration);
        this.klarnaClient = new KlarnaClientImpl(this.apiClient, configuration);
        this.sepaClient = new SepaClientImpl(this.apiClient, configuration);
    }

    public IdealClient idealClient() {
        return this.idealClient;
    }

    public KlarnaClient klarnaClient() {
        return this.klarnaClient;
    }

    public SepaClient sepaClient() {
        return this.sepaClient;
    }

    private ApiClient getBaseApiClient(CheckoutConfiguration configuration) {
        return new ApiClientImpl(configuration, new BaseUriStrategy(configuration));
    }

    private static class BaseUriStrategy
    implements UriStrategy {
        private final CheckoutConfiguration configuration;

        private BaseUriStrategy(CheckoutConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public URI getUri() {
            if (this.configuration.getEnvironmentSubdomain() != null) {
                return this.configuration.getEnvironmentSubdomain().getCheckoutApi();
            }
            return this.configuration.getEnvironment().getCheckoutApi();
        }
    }
}

